/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.nio.util;

import java.io.IOException;
import org.apache.http.nio.ContentDecoder;
import org.apache.http.nio.ContentIOControl;
import org.apache.http.nio.util.ExpandableBuffer;

public class ContentInputBuffer
extends ExpandableBuffer {
    private final ContentIOControl ioctrl;
    private final Object mutex;
    private volatile boolean shutdown = false;
    private volatile boolean endOfStream = false;
    private volatile IOException exception = null;

    public ContentInputBuffer(int buffersize, ContentIOControl ioctrl) {
        super(buffersize);
        if (ioctrl == null) {
            throw new IllegalArgumentException("I/O content control may not be null");
        }
        this.ioctrl = ioctrl;
        this.mutex = new Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        if (this.shutdown) {
            return;
        }
        Object object = this.mutex;
        synchronized (object) {
            this.clear();
            this.endOfStream = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void consumeContent(ContentDecoder decoder) throws IOException {
        if (this.shutdown) {
            return;
        }
        Object object = this.mutex;
        synchronized (object) {
            int bytesRead;
            this.setInputMode();
            int totalRead = 0;
            while ((bytesRead = decoder.read(this.buffer)) > 0) {
                totalRead += bytesRead;
            }
            if (bytesRead == -1 || decoder.isCompleted()) {
                this.endOfStream = true;
            }
            if (totalRead > 0) {
                this.ioctrl.suspendInput();
            }
            this.mutex.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void waitForData() throws IOException {
        Object object = this.mutex;
        synchronized (object) {
            try {
                while (!(this.hasData() || this.endOfStream || this.shutdown)) {
                    this.ioctrl.requestInput();
                    this.mutex.wait();
                }
                IOException ex = this.exception;
                if (ex != null) {
                    throw ex;
                }
            }
            catch (InterruptedException ex) {
                throw new IOException("Interrupted while waiting for more data");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        if (this.shutdown) {
            return;
        }
        this.shutdown = true;
        Object object = this.mutex;
        synchronized (object) {
            this.mutex.notifyAll();
        }
    }

    public void shutdown(IOException exception) {
        this.exception = exception;
        this.shutdown();
    }

    protected boolean isShutdown() {
        return this.shutdown;
    }

    protected boolean isEndOfStream() {
        return this.shutdown || !this.hasData() && this.endOfStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read() throws IOException {
        if (this.shutdown) {
            return -1;
        }
        Object object = this.mutex;
        synchronized (object) {
            if (!this.hasData()) {
                this.waitForData();
            }
            if (this.isEndOfStream()) {
                return -1;
            }
            return this.buffer.get() & 0xFF;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.shutdown) {
            return -1;
        }
        if (b == null) {
            return 0;
        }
        Object object = this.mutex;
        synchronized (object) {
            if (!this.hasData()) {
                this.waitForData();
            }
            if (this.isEndOfStream()) {
                return -1;
            }
            this.setOutputMode();
            int chunk = len;
            if (chunk > this.buffer.remaining()) {
                chunk = this.buffer.remaining();
            }
            this.buffer.get(b, off, chunk);
            return chunk;
        }
    }

    public int read(byte[] b) throws IOException {
        if (this.shutdown) {
            return -1;
        }
        if (b == null) {
            return 0;
        }
        return this.read(b, 0, b.length);
    }
}

