/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.nio.util;

import java.io.IOException;
import org.apache.http.nio.ContentEncoder;
import org.apache.http.nio.ContentIOControl;
import org.apache.http.nio.util.ExpandableBuffer;

public class ContentOutputBuffer
extends ExpandableBuffer {
    private final ContentIOControl ioctrl;
    private final Object mutex;
    private volatile boolean shutdown = false;
    private volatile boolean endOfStream = false;
    private volatile IOException exception = null;

    public ContentOutputBuffer(int buffersize, ContentIOControl ioctrl) {
        super(buffersize);
        if (ioctrl == null) {
            throw new IllegalArgumentException("I/O content control may not be null");
        }
        this.ioctrl = ioctrl;
        this.mutex = new Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        if (this.shutdown) {
            return;
        }
        Object object = this.mutex;
        synchronized (object) {
            this.clear();
            this.endOfStream = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void produceContent(ContentEncoder encoder) throws IOException {
        if (this.shutdown) {
            return;
        }
        Object object = this.mutex;
        synchronized (object) {
            this.setOutputMode();
            encoder.write(this.buffer);
            if (!this.hasData()) {
                if (this.endOfStream) {
                    encoder.complete();
                }
                this.ioctrl.suspendOutput();
                this.mutex.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void flushBuffer() throws IOException {
        Object object = this.mutex;
        synchronized (object) {
            this.setOutputMode();
            try {
                while (this.hasData() && !this.shutdown) {
                    this.ioctrl.requestOutput();
                    this.mutex.wait();
                }
                IOException ex = this.exception;
                if (ex != null) {
                    throw ex;
                }
            }
            catch (InterruptedException ex) {
                throw new IOException("Interrupted while waiting for more data");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        if (this.shutdown) {
            return;
        }
        this.shutdown = true;
        Object object = this.mutex;
        synchronized (object) {
            this.mutex.notifyAll();
        }
    }

    public void shutdown(IOException exception) {
        this.exception = exception;
        this.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            return;
        }
        if (this.shutdown || this.endOfStream) {
            return;
        }
        Object object = this.mutex;
        synchronized (object) {
            this.setInputMode();
            int remaining = len;
            while (remaining > 0) {
                if (!this.buffer.hasRemaining()) {
                    this.flushBuffer();
                    this.setInputMode();
                }
                int chunk = Math.min(remaining, this.buffer.remaining());
                this.buffer.put(b, off, chunk);
                remaining -= chunk;
                off += chunk;
            }
        }
    }

    public void write(byte[] b) throws IOException {
        if (b == null) {
            return;
        }
        this.write(b, 0, b.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(int b) throws IOException {
        if (this.shutdown || this.endOfStream) {
            return;
        }
        Object object = this.mutex;
        synchronized (object) {
            this.setInputMode();
            if (!this.buffer.hasRemaining()) {
                this.flushBuffer();
                this.setInputMode();
            }
            this.buffer.put((byte)b);
        }
    }

    public void flush() throws IOException {
        this.flushBuffer();
    }

    public void close() throws IOException {
        this.endOfStream = true;
        this.flushBuffer();
    }
}

