/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.nio.util;

import java.nio.ByteBuffer;

public class ExpandableBuffer {
    public static final int INPUT_MODE = 0;
    public static final int OUTPUT_MODE = 1;
    private int mode;
    protected ByteBuffer buffer = null;

    public ExpandableBuffer(int buffersize) {
        this.buffer = ByteBuffer.allocateDirect(buffersize);
        this.mode = 0;
    }

    protected int getMode() {
        return this.mode;
    }

    protected void setOutputMode() {
        if (this.mode != 1) {
            this.buffer.flip();
            this.mode = 1;
        }
    }

    protected void setInputMode() {
        if (this.mode != 0) {
            if (this.buffer.hasRemaining()) {
                this.buffer.compact();
            } else {
                this.buffer.clear();
            }
            this.mode = 0;
        }
    }

    private void expandCapacity(int capacity) {
        ByteBuffer oldbuffer = this.buffer;
        this.buffer = ByteBuffer.allocateDirect(capacity);
        oldbuffer.flip();
        this.buffer.put(oldbuffer);
    }

    protected void expand() {
        int newcapacity = this.buffer.capacity() + 1 << 1;
        if (newcapacity < 0) {
            newcapacity = Integer.MAX_VALUE;
        }
        this.expandCapacity(newcapacity);
    }

    protected void ensureCapacity(int requiredCapacity) {
        if (requiredCapacity > this.buffer.capacity()) {
            this.expandCapacity(requiredCapacity);
        }
    }

    public int capacity() {
        return this.buffer.capacity();
    }

    public boolean hasData() {
        this.setOutputMode();
        return this.buffer.hasRemaining();
    }

    public int length() {
        this.setOutputMode();
        return this.buffer.remaining();
    }

    protected void clear() {
        this.buffer.clear();
        this.mode = 0;
    }
}

