/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.nio.params;

import org.apache.http.params.HttpParams;

public final class HttpNIOParams {
    public static final String CONTENT_BUFFER_SIZE = "http.nio.content-buffer-size";

    private HttpNIOParams() {
    }

    public static int getContentBufferSize(HttpParams params) {
        if (params == null) {
            throw new IllegalArgumentException("HTTP parameters may not be null");
        }
        return params.getIntParameter(CONTENT_BUFFER_SIZE, -1);
    }

    public static void setContentBufferSize(HttpParams params, int size) {
        if (params == null) {
            throw new IllegalArgumentException("HTTP parameters may not be null");
        }
        params.setIntParameter(CONTENT_BUFFER_SIZE, size);
    }
}

