/*
 * Decompiled with CFR 0.152.
 */
package org.apache.httpcomponents.maven.plugin.notice;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Calendar;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.maven.model.License;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;

public final class NoticeMojo
extends AbstractMojo {
    private static final String UTF_8 = "UTF-8";
    protected MavenProject project = new MavenProject();
    private File directory;
    private String projectTitle;
    private String copyrightHolder;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.project.getPackaging().equalsIgnoreCase("pom")) {
            return;
        }
        this.getLog().info((CharSequence)"Generating NOTICE and LICENSE resources");
        File nalDir = new File(this.directory, "notice-and-license");
        if (!nalDir.exists()) {
            nalDir.mkdirs();
        }
        List licenses = this.project.getLicenses();
        for (int i = 0; i < licenses.size(); ++i) {
            License license = (License)licenses.get(i);
            try {
                URI uri = new URI(license.getUrl());
                String s = "LICENSE";
                if (i > 0) {
                    s = s + i;
                }
                s = s + ".txt";
                File out = new File(nalDir, s);
                if (!uri.isAbsolute()) {
                    File file = this.findFile(license.getUrl());
                    if (file == null) continue;
                    FileUtils.copyFile((File)file, (File)out);
                    continue;
                }
                FileUtils.copyURLToFile((URL)uri.toURL(), (File)out);
                continue;
            }
            catch (URISyntaxException ex) {
                throw new MojoFailureException("Invalid URI: " + ex.getMessage(), (Throwable)ex);
            }
            catch (IOException ex) {
                throw new MojoFailureException("I/O error copying LICENSE file: " + ex.getMessage(), (Throwable)ex);
            }
        }
        File file = this.findFile("NOTICE.txt");
        if (file != null) {
            File out = new File(nalDir, "NOTICE.txt");
            try {
                this.rewriteNotice(file, out);
            }
            catch (IOException ex) {
                throw new MojoFailureException("I/O error copying NOTICE file: " + ex.getMessage(), (Throwable)ex);
            }
        }
        Resource nalRes = new Resource();
        nalRes.setDirectory(nalDir.getAbsolutePath());
        nalRes.setFiltering(false);
        nalRes.setTargetPath("META-INF");
        this.project.addResource(nalRes);
        this.project.addTestResource(nalRes);
    }

    private File findFile(String resource) {
        for (MavenProject current = this.project; current != null; current = current.getParent()) {
            File basedir = current.getBasedir();
            File file = new File(basedir, resource);
            if (!file.exists()) continue;
            return file;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rewriteNotice(File in, File out) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(in), UTF_8));
        try {
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(out), UTF_8));
            try {
                String line;
                if (this.projectTitle != null) {
                    writer.write(this.projectTitle);
                    writer.write(" ");
                }
                writer.write(this.project.getName());
                writer.write("\r\n");
                writer.write("Copyright ");
                String fromYear = this.project.getInceptionYear();
                if (fromYear != null && fromYear.length() > 0) {
                    writer.write(fromYear);
                    writer.write("-");
                }
                Calendar cal = Calendar.getInstance();
                String toYear = Integer.toString(cal.get(1));
                writer.write(toYear);
                String copyrightHolder = this.copyrightHolder;
                if (copyrightHolder == null && this.project.getOrganization() != null) {
                    copyrightHolder = this.project.getOrganization().getName();
                }
                if (copyrightHolder != null) {
                    writer.write(" ");
                    writer.write(copyrightHolder);
                }
                writer.write("\r\n");
                int count = 0;
                while ((line = reader.readLine()) != null) {
                    if (++count <= 2) continue;
                    writer.write(line);
                    writer.write("\r\n");
                }
                writer.flush();
            }
            finally {
                writer.close();
            }
        }
        finally {
            reader.close();
        }
    }
}

