/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.commons.config.metrics;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.inlong.commons.config.metrics.MetricItem;
import org.apache.inlong.commons.config.metrics.MetricItemSetMBean;
import org.apache.inlong.commons.config.metrics.MetricUtils;

public abstract class MetricItemSet<T extends MetricItem>
implements MetricItemSetMBean {
    protected String name;
    protected Map<String, T> itemMap = new ConcurrentHashMap<String, T>();

    public MetricItemSet(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    protected abstract T createItem();

    public T findMetricItem(Map<String, String> dimensions) {
        String key = MetricUtils.getDimensionsKey(dimensions);
        MetricItem currentItem = (MetricItem)this.itemMap.get(key);
        if (currentItem != null) {
            return (T)currentItem;
        }
        currentItem = this.createItem();
        currentItem.setDimensions(dimensions);
        MetricItem oldItem = this.itemMap.putIfAbsent(key, currentItem);
        MetricItem returnItem = oldItem == null ? currentItem : oldItem;
        return (T)returnItem;
    }

    @Override
    public List<MetricItem> snapshot() {
        Map<String, T> oldItemMap = this.itemMap;
        this.itemMap = new ConcurrentHashMap<String, T>();
        MetricUtils.sleepOneInterval();
        ArrayList<MetricItem> result = new ArrayList<MetricItem>(oldItemMap.size());
        result.addAll(oldItemMap.values());
        return result;
    }
}

