/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.commons.config.metrics;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.apache.inlong.commons.config.metrics.MetricDomain;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricUtils {
    public static final Logger LOGGER = LoggerFactory.getLogger(MetricUtils.class);

    public static String getDomain(Class<?> cls) {
        for (Annotation annotation : cls.getAnnotations()) {
            if (!(annotation instanceof MetricDomain)) continue;
            MetricDomain domain = (MetricDomain)annotation;
            String name = domain.name();
            name = name != null && name.length() > 0 ? name : cls.getName();
            return name;
        }
        return cls.getName();
    }

    public static String getDimensionsKey(Map<String, String> dimensionMap) {
        StringBuilder builder = new StringBuilder();
        if (dimensionMap.size() <= 0) {
            return "";
        }
        Set<String> fieldKeySet = dimensionMap.keySet();
        ArrayList<String> fieldKeyList = new ArrayList<String>(fieldKeySet.size());
        fieldKeyList.addAll(fieldKeySet);
        Collections.sort(fieldKeyList);
        for (String fieldKey : fieldKeyList) {
            String fieldValue = dimensionMap.get(fieldKey);
            fieldValue = fieldValue == null ? "" : fieldValue;
            builder.append(fieldKey).append('=').append(fieldValue).append(',');
        }
        String key = builder.substring(0, builder.length() - 1);
        return key;
    }

    public static void sleepOneInterval() {
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }
}

