/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.commons.metrics;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.DynamicMBean;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import org.apache.inlong.commons.metrics.MetricSnapshot;
import org.apache.inlong.commons.metrics.meta.MetricMeta;
import org.apache.inlong.commons.metrics.meta.MetricsMeta;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataProxyDynamicMBean
implements DynamicMBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataProxyDynamicMBean.class);
    private final ConcurrentHashMap<String, MetricSnapshot<?>> snapshotAttrs = new ConcurrentHashMap();
    private final MBeanInfo mBeanInfo;
    private final List<MBeanAttributeInfo> attrs;
    private final MetricsMeta metricsMeta;
    private final String module;
    private final String aspect;
    private final String desc;

    public DataProxyDynamicMBean(String module, String aspect, String desc, MetricsMeta metricsMeta, Object source) {
        this.module = module;
        this.aspect = aspect;
        this.desc = desc;
        this.metricsMeta = metricsMeta;
        this.attrs = new ArrayList<MBeanAttributeInfo>();
        this.mBeanInfo = this.metricsMetaToInfo();
        this.formatSnapshotList(source);
    }

    private void formatSnapshotList(Object source) {
        for (MetricMeta metricMeta : this.metricsMeta.getMetricMetaList()) {
            try {
                this.snapshotAttrs.put(metricMeta.getName(), (MetricSnapshot)metricMeta.getField().get(source));
            }
            catch (Exception ex) {
                LOGGER.error("exception while adding snapshot list", (Throwable)ex);
            }
        }
    }

    private MBeanInfo metricsMetaToInfo() {
        String name = this.module == null ? this.metricsMeta.getName() : this.module;
        String description = this.desc == null ? this.metricsMeta.getDesc() : this.desc;
        for (MetricMeta fieldMetricMeta : this.metricsMeta.getMetricMetaList()) {
            this.attrs.add(new MBeanAttributeInfo(fieldMetricMeta.getName(), fieldMetricMeta.getType(), fieldMetricMeta.getDesc(), true, false, false));
        }
        return new MBeanInfo(name, description, this.attrs.toArray(new MBeanAttributeInfo[0]), null, null, null);
    }

    @Override
    public Object getAttribute(String attribute) {
        MetricSnapshot<?> snapshot = this.snapshotAttrs.get(attribute);
        return new Attribute(attribute, snapshot.snapshot());
    }

    @Override
    public void setAttribute(Attribute attribute) {
        throw new UnsupportedOperationException("Metrics are read-only.");
    }

    @Override
    public AttributeList getAttributes(String[] attributes) {
        AttributeList attributeList = new AttributeList();
        for (String attrKey : attributes) {
            MetricSnapshot<?> snapshot = this.snapshotAttrs.get(attrKey);
            if (snapshot == null) continue;
            attributeList.add(new Attribute(attrKey, snapshot.snapshot()));
        }
        return attributeList;
    }

    @Override
    public AttributeList setAttributes(AttributeList attributes) {
        throw new UnsupportedOperationException("Metrics are read-only.");
    }

    @Override
    public Object invoke(String actionName, Object[] params, String[] signature) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public MBeanInfo getMBeanInfo() {
        return this.mBeanInfo;
    }

    public String getModule() {
        return this.module;
    }

    public String getAspect() {
        return this.aspect;
    }
}

