/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.commons.metrics;

import java.lang.annotation.Annotation;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.inlong.commons.metrics.DataProxyDynamicMBean;
import org.apache.inlong.commons.metrics.Metric;
import org.apache.inlong.commons.metrics.MetricException;
import org.apache.inlong.commons.metrics.Metrics;
import org.apache.inlong.commons.metrics.Tag;
import org.apache.inlong.commons.metrics.counter.CounterInt;
import org.apache.inlong.commons.metrics.counter.CounterLong;
import org.apache.inlong.commons.metrics.gauge.GaugeInt;
import org.apache.inlong.commons.metrics.gauge.GaugeLong;
import org.apache.inlong.commons.metrics.meta.MetricMeta;
import org.apache.inlong.commons.metrics.meta.MetricsMeta;
import org.apache.inlong.commons.util.MetricUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricsRegister {
    private static final Logger LOGGER = LoggerFactory.getLogger(MetricsRegister.class);
    private static final String DOMAIN_PREFIX = "Agent:";
    private static final String MODULE_PREFIX = "module=";
    private static final String ASPECT_PREFIX = "aspect=";
    private static final String COMMA_SPLITTER = ",";
    private static final ConcurrentHashMap<String, ObjectName> CACHED_NAME = new ConcurrentHashMap();

    private MetricsRegister() {
    }

    private static void innerRegister(DataProxyDynamicMBean agentDynamicMBean) {
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        String nameStr = "Agent:module=" + agentDynamicMBean.getModule() + COMMA_SPLITTER + ASPECT_PREFIX + agentDynamicMBean.getAspect();
        try {
            ObjectName tmpName = new ObjectName(nameStr);
            ObjectName objectName = CACHED_NAME.putIfAbsent(nameStr, tmpName);
            if (objectName == null) {
                mbs.registerMBean(agentDynamicMBean, tmpName);
            }
        }
        catch (Exception ex) {
            LOGGER.error("exception while register mbean", (Throwable)ex);
        }
    }

    public static void register(String module, String aspect, String desc, Object source) {
        List<MetricMeta> metricMetaList = MetricsRegister.handleFieldAnnotation(source);
        MetricsMeta metricsMeta = MetricsRegister.handleClassAnnotation(source, metricMetaList);
        if (metricsMeta != null) {
            MetricsRegister.innerRegister(new DataProxyDynamicMBean(module, aspect, desc, metricsMeta, source));
        } else {
            LOGGER.error("Cannot find Metrics annotation in {}, invalid metric", source);
        }
    }

    private static MetricsMeta handleClassAnnotation(Object source, List<MetricMeta> metricMetaList) {
        for (Annotation annotation : source.getClass().getAnnotations()) {
            if (!(annotation instanceof Metrics)) continue;
            return MetricsMeta.build((Metrics)annotation, metricMetaList);
        }
        return null;
    }

    private static boolean initFieldByType(Object source, Field field) {
        try {
            if (field.getType() == CounterInt.class) {
                field.set(source, new CounterInt());
                return true;
            }
            if (field.getType() == CounterLong.class) {
                field.set(source, new CounterLong());
                return true;
            }
            if (field.getType() == GaugeInt.class) {
                field.set(source, new GaugeInt());
                return true;
            }
            if (field.getType() == GaugeLong.class) {
                field.set(source, new GaugeLong());
                return true;
            }
            if (field.getType() == Tag.class) {
                field.set(source, new Tag());
                return true;
            }
            throw new MetricException("field type error " + field.getType().toString());
        }
        catch (MetricException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new MetricException("Error setting field " + field + " annotated with metric", ex);
        }
    }

    private static List<MetricMeta> handleFieldAnnotation(Object source) {
        ArrayList<MetricMeta> result = new ArrayList<MetricMeta>();
        block0: for (Field field : MetricUtil.getDeclaredFieldsIncludingInherited(source.getClass())) {
            field.setAccessible(true);
            for (Annotation fieldAnnotation : field.getAnnotations()) {
                if (!(fieldAnnotation instanceof Metric)) continue;
                if (!MetricsRegister.initFieldByType(source, field)) continue block0;
                result.add(MetricMeta.build((Metric)fieldAnnotation, field));
                continue block0;
            }
        }
        return result;
    }
}

