/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.commons.metrics;

public class ResourceUsage {
    public double usage;
    public double limit;
    public double usePercentage;

    public ResourceUsage(double usage, double limit, double usePercentage) {
        this.usage = usage;
        this.limit = limit;
        this.usePercentage = usePercentage;
    }

    public ResourceUsage(ResourceUsage that) {
        this.usage = that.usage;
        this.limit = that.limit;
    }

    public ResourceUsage() {
    }

    public void reset() {
        this.usage = -1.0;
        this.limit = -1.0;
    }

    public int compareTo(ResourceUsage o) {
        double required = o.limit - o.usage;
        double available = this.limit - this.usage;
        return Double.compare(available, required);
    }

    public float percentUsage() {
        float proportion = 0.0f;
        if (this.limit > 0.0) {
            proportion = (float)this.usage / (float)this.limit;
        }
        return proportion * 100.0f;
    }
}

