/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.commons.metrics.meta;

import java.lang.reflect.Field;
import org.apache.inlong.commons.metrics.Metric;
import org.apache.inlong.commons.metrics.MutableMetric;
import org.apache.inlong.commons.metrics.counter.CounterInt;
import org.apache.inlong.commons.metrics.counter.CounterLong;
import org.apache.inlong.commons.metrics.gauge.GaugeInt;
import org.apache.inlong.commons.metrics.gauge.GaugeLong;

public class MetricMeta {
    private String name;
    private String type;
    private String desc;
    private Field field;

    public static MetricMeta build(Metric annotation, Field field) {
        MetricMeta metricMeta = new MetricMeta();
        metricMeta.name = MetricMeta.capitalize(field.getName());
        metricMeta.desc = annotation.desc();
        metricMeta.type = Metric.Type.DEFAULT.getValue();
        metricMeta.field = field;
        Class<MutableMetric> clz = field.getType();
        if (clz.isAssignableFrom(CounterLong.class)) {
            metricMeta.type = Metric.Type.COUNTER_LONG.getValue();
        } else if (clz.isAssignableFrom(CounterInt.class)) {
            metricMeta.type = Metric.Type.COUNTER_INT.getValue();
        } else if (clz.isAssignableFrom(GaugeInt.class)) {
            metricMeta.type = Metric.Type.GAUGE_INT.getValue();
        } else if (clz.isAssignableFrom(GaugeLong.class)) {
            metricMeta.type = Metric.Type.GAUGE_LONG.getValue();
        }
        return metricMeta;
    }

    public String getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public String getDesc() {
        return this.desc;
    }

    public Field getField() {
        return this.field;
    }

    public static String capitalize(String str) {
        int strLen;
        return str != null && (strLen = str.length()) != 0 ? new StringBuilder(strLen).append(Character.toTitleCase(str.charAt(0))).append(str.substring(1)).toString() : str;
    }
}

