/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.commons.util;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.inlong.commons.metrics.MetricException;
import org.apache.inlong.commons.metrics.ResourceUsage;
import org.apache.inlong.commons.metrics.Tag;
import org.apache.inlong.commons.metrics.counter.CounterInt;
import org.apache.inlong.commons.metrics.counter.CounterLong;
import org.apache.inlong.commons.metrics.gauge.GaugeInt;
import org.apache.inlong.commons.metrics.gauge.GaugeLong;

public class MetricUtil {
    public static final long MIBI = 0x100000L;
    private static final int HUNDRED_PERCENT = 100;

    public static List<Field> getDeclaredFieldsIncludingInherited(Class<?> clazz) {
        ArrayList<Field> fields = new ArrayList<Field>();
        while (clazz != null) {
            fields.addAll(Arrays.asList(clazz.getDeclaredFields()));
            clazz = clazz.getSuperclass();
        }
        return fields;
    }

    private static boolean initFieldByType(Object source, Field field) {
        try {
            if (field.getType() == CounterInt.class) {
                field.set(source, new CounterInt());
                return true;
            }
            if (field.getType() == CounterLong.class) {
                field.set(source, new CounterLong());
                return true;
            }
            if (field.getType() == GaugeInt.class) {
                field.set(source, new GaugeInt());
                return true;
            }
            if (field.getType() == GaugeLong.class) {
                field.set(source, new GaugeLong());
                return true;
            }
            if (field.getType() == Tag.class) {
                field.set(source, new Tag());
                return true;
            }
            throw new MetricException("field type error " + field.getType().toString());
        }
        catch (MetricException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new MetricException("Error setting field " + field + " annotated with metric", ex);
        }
    }

    public static ResourceUsage getHeapMemLoadInfo() {
        double maxHeapMemoryInMBs = (double)Runtime.getRuntime().maxMemory() / 1048576.0;
        double memoryUsageInMBs = (double)(Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()) / 1048576.0;
        return new ResourceUsage(memoryUsageInMBs, maxHeapMemoryInMBs, memoryUsageInMBs / maxHeapMemoryInMBs * 100.0);
    }

    public static int getUsagePercentage() {
        double maxHeapMemoryInMBs = (double)Runtime.getRuntime().maxMemory() / 1048576.0;
        double memoryUsageInMBs = (double)(Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()) / 1048576.0;
        return (int)(memoryUsageInMBs / maxHeapMemoryInMBs * 100.0);
    }
}

