/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.commons.util;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;

public class NetworkUtils {
    public static String INNER_NETWORK_INTERFACE = "eth1";
    private static String localIp = null;

    public static String getLocalIp() {
        if (localIp == null) {
            String ip = null;
            try {
                Enumeration<NetworkInterface> allInterface = NetworkInterface.getNetworkInterfaces();
                while (allInterface.hasMoreElements()) {
                    NetworkInterface oneInterface = allInterface.nextElement();
                    String interfaceName = oneInterface.getName();
                    if (oneInterface.isLoopback() || !oneInterface.isUp() || !interfaceName.equalsIgnoreCase(INNER_NETWORK_INTERFACE)) continue;
                    Enumeration<InetAddress> allAddress = oneInterface.getInetAddresses();
                    while (allAddress.hasMoreElements()) {
                        InetAddress oneAddress = allAddress.nextElement();
                        ip = oneAddress.getHostAddress();
                        if (ip == null || ip.isEmpty() || ip.equals("127.0.0.1")) continue;
                        return ip;
                    }
                }
            }
            catch (SocketException socketException) {
                // empty catch block
            }
            localIp = ip = "0.0.0.0";
        }
        return localIp;
    }

    static {
        localIp = NetworkUtils.getLocalIp();
    }
}

