/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.common.enums;

import java.util.Objects;

public enum TaskTypeEnum {
    DATABASE_MIGRATION(0),
    SQL(1),
    BINLOG(2),
    FILE(3),
    KAFKA(4);

    private int type;

    private TaskTypeEnum(int type) {
        this.type = type;
    }

    public static TaskTypeEnum getTaskType(int taskType) {
        Objects.requireNonNull(taskType);
        switch (taskType) {
            case 0: {
                return DATABASE_MIGRATION;
            }
            case 1: {
                return SQL;
            }
            case 2: {
                return BINLOG;
            }
            case 3: {
                return FILE;
            }
            case 4: {
                return KAFKA;
            }
        }
        throw new RuntimeException("such task type doesn't exist");
    }

    public int getType() {
        return this.type;
    }
}

