/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.common.msg;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.inlong.common.msg.DataInputBuffer;
import org.apache.inlong.common.msg.DataOutputBuffer;
import org.xerial.snappy.Snappy;

public class InLongMsg {
    private static final int DEFAULT_CAPACITY = 4096;
    private final int capacity;
    private static final int BIN_MSG_NO_ZIP = 0;
    private static final int BIN_MSG_SNAPPY_TYPE = 1;
    private static final int BIN_MSG_TOTALLEN_OFFSET = 0;
    private static final int BIN_MSG_GROUPID_OFFSET = 5;
    private static final int BIN_MSG_STREAMID_OFFSET = 7;
    private static final int BIN_MSG_EXTFIELD_OFFSET = 9;
    private static final int BIN_MSG_COUNT_OFFSET = 15;
    private static final int BIN_MSG_DATATIME_OFFSET = 11;
    private static final int BIN_MSG_TOTALLEN_SIZE = 4;
    private static final int BIN_MSG_MSGTYPE_OFFSET = 4;
    private static final int BIN_MSG_SET_SNAPPY = 32;
    private static final int BIN_MSG_BODYLEN_SIZE = 4;
    private static final int BIN_MSG_BODYLEN_OFFSET = 21;
    private static final int BIN_MSG_BODY_OFFSET = 25;
    private static final int BIN_MSG_ATTRLEN_SIZE = 2;
    private static final int BIN_MSG_FORMAT_SIZE = 29;
    private static final int BIN_MSG_MAGIC_SIZE = 2;
    private static final int BIN_MSG_MAGIC = 60929;
    private static final byte[] MAGIC0 = new byte[]{15, 0};
    private static final byte[] MAGIC1 = new byte[]{15, 1};
    private static final byte[] MAGIC2 = new byte[]{15, 2};
    private static final byte[] MAGIC3 = new byte[]{15, 3};
    private static final byte[] MAGIC4 = new byte[]{15, 4};
    private final boolean addmode;
    private static final Joiner.MapJoiner MAP_JOINER = Joiner.on((String)"&").withKeyValueSeparator("=");
    private static final Splitter.MapSplitter MAP_SPLITTER = Splitter.on((String)"&").trimResults().withKeyValueSeparator("=");
    private LinkedHashMap<String, DataBuffer> attr2MsgBuffer;
    private ByteBuffer binMsgBuffer;
    private int datalen = 0;
    private int msgcnt = 0;
    private boolean compress;
    private boolean isNumGroupId = false;
    private boolean ischeck = true;
    private boolean isSupportLF = false;
    private final Version version;
    private long timeoffset = 0L;
    private int attrcnt = -1;
    private LinkedHashMap<String, DataByteBuffer> attr2Rawdata = null;
    private long createtime = -1L;
    private boolean parsed = false;
    private DataInputBuffer parsedInput;
    private ByteBuffer parsedBinInput;

    public int getVersion() {
        return this.version.intValue();
    }

    public void setTimeoffset(long offset) {
        this.timeoffset = offset;
    }

    public static InLongMsg newInLongMsg() {
        return InLongMsg.newInLongMsg(true);
    }

    public static InLongMsg newInLongMsg(boolean compress) {
        return InLongMsg.newInLongMsg(4096, compress);
    }

    public static InLongMsg newInLongMsg(int v) {
        return InLongMsg.newInLongMsg(4096, true, v);
    }

    public static InLongMsg newInLongMsg(boolean compress, int v) {
        return InLongMsg.newInLongMsg(4096, compress, v);
    }

    public static InLongMsg newInLongMsg(int capacity, boolean compress) {
        return new InLongMsg(capacity, compress, Version.v1);
    }

    public static InLongMsg newInLongMsg(int capacity, boolean compress, int v) {
        return new InLongMsg(capacity, compress, Version.of(v));
    }

    private InLongMsg(int capacity, boolean compress, Version v) {
        this.version = v;
        this.addmode = true;
        this.compress = compress;
        this.capacity = capacity;
        this.attr2MsgBuffer = new LinkedHashMap();
        this.parsedInput = null;
        this.reset();
    }

    public boolean addMsg(String attr, byte[] data, int offset, int len) {
        return this.addMsg(attr, ByteBuffer.wrap(data, offset, len));
    }

    public boolean addMsg(String attr, ByteBuffer data) {
        this.checkMode(true);
        if (this.version.intValue() == Version.v3.intValue() && !this.checkData(data)) {
            return false;
        }
        DataBuffer outputBuffer = this.attr2MsgBuffer.get(attr);
        if (outputBuffer == null) {
            outputBuffer = new DataBuffer();
            this.attr2MsgBuffer.put(attr, outputBuffer);
            this.datalen += attr.length() + 2 + 4 + 1;
        }
        int len = data.remaining();
        try {
            outputBuffer.write(data.array(), data.position(), len);
            this.datalen += len + 4;
            if (this.version.intValue() == Version.v2.intValue()) {
                this.datalen += 4;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        ++this.msgcnt;
        return this.checkLen(attr, len);
    }

    public boolean addMsg(String attr, byte[] data) {
        return this.addMsg(attr, ByteBuffer.wrap(data));
    }

    public boolean addMsg(byte[] data) {
        return this.addMsg(ByteBuffer.wrap(data));
    }

    public boolean addMsg(ByteBuffer data) {
        if (!this.checkBinData(data)) {
            return false;
        }
        if (this.binMsgBuffer != null) {
            return false;
        }
        this.binMsgBuffer = ByteBuffer.allocate(data.remaining());
        this.binMsgBuffer.put(data);
        this.binMsgBuffer.position(0);
        this.msgcnt = this.getBinMsgCnt(this.binMsgBuffer);
        return true;
    }

    private int getBinMsgtype(ByteBuffer data) {
        return data.get(4);
    }

    private int getBinMsgCnt(ByteBuffer data) {
        return data.getShort(15);
    }

    private long getBinCreatetime(ByteBuffer data) {
        return (long)data.getInt(11) * 1000L;
    }

    private boolean getBinNumFlag(ByteBuffer data) {
        return (data.getShort(9) & 4) == 0;
    }

    private boolean getBinisSupportLF(ByteBuffer data) {
        return (data.getShort(9) & 0x20) == 32;
    }

    private boolean checkBinData(ByteBuffer data) {
        int totalLen = data.getInt(0);
        int bodyLen = data.getInt(21);
        short attrLen = data.getShort(25 + bodyLen);
        int msgMagic = data.getShort(25 + bodyLen + 2 + attrLen) & 0xFFFF;
        return totalLen + 4 == bodyLen + attrLen + 29 && msgMagic == 60929;
    }

    public boolean addMsgs(String attr, ByteBuffer data) {
        boolean res = true;
        Iterator<ByteBuffer> it = InLongMsg.getIteratorBuffer(data);
        this.setCheckMode(false);
        while (it.hasNext()) {
            res = this.addMsg(attr, it.next());
        }
        this.setCheckMode(true);
        return res;
    }

    private void setCheckMode(boolean mode) {
        if (this.version.intValue() == Version.v3.intValue()) {
            this.ischeck = mode;
        }
    }

    private boolean checkData(ByteBuffer data) {
        if (this.version.intValue() == Version.v3.intValue() && !this.ischeck) {
            return true;
        }
        data.mark();
        int msgnum = 0;
        while (data.remaining() > 0) {
            int datalen = data.getInt();
            if (datalen > data.remaining()) {
                return false;
            }
            ++msgnum;
            byte[] record = new byte[datalen];
            data.get(record, 0, datalen);
        }
        if ((msgnum /= 2) > 1) {
            this.msgcnt += msgnum - 1;
        }
        data.reset();
        return true;
    }

    private boolean checkLen(String attr, int len) {
        return this.datalen < this.capacity;
    }

    public boolean isfull() {
        this.checkMode(true);
        return this.datalen >= this.capacity;
    }

    private ByteBuffer defaultBuild(long createtime) {
        try {
            this.createtime = createtime;
            DataOutputBuffer out = new DataOutputBuffer(this.capacity);
            this.writeHeader(out);
            out.writeInt(this.attr2MsgBuffer.size());
            if (this.compress) {
                for (String attr : this.attr2MsgBuffer.keySet()) {
                    out.writeUTF(attr);
                    DataBuffer data = this.attr2MsgBuffer.get(attr);
                    if (this.version.intValue() == Version.v2.intValue()) {
                        out.writeInt(data.cnt);
                    }
                    int guessLen = Snappy.maxCompressedLength((int)data.out.getLength());
                    byte[] tmpData = new byte[guessLen];
                    int len = Snappy.compress((byte[])data.out.getData(), (int)0, (int)data.out.getLength(), (byte[])tmpData, (int)0);
                    out.writeInt(len + 1);
                    out.writeBoolean(this.compress);
                    out.write(tmpData, 0, len);
                }
            } else {
                for (String attr : this.attr2MsgBuffer.keySet()) {
                    out.writeUTF(attr);
                    DataBuffer data = this.attr2MsgBuffer.get(attr);
                    if (this.version.intValue() == Version.v2.intValue()) {
                        out.writeInt(data.cnt);
                    }
                    out.writeInt(data.out.getLength() + 1);
                    out.writeBoolean(this.compress);
                    out.write(data.out.getData(), 0, data.out.getLength());
                }
            }
            this.writeMagic(out);
            out.close();
            return ByteBuffer.wrap(out.getData(), 0, out.getLength());
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private ByteBuffer binBuild(long createtime) {
        try {
            this.createtime = createtime;
            DataOutputBuffer out = new DataOutputBuffer(this.capacity);
            this.writeMagic(out);
            int msgType = this.getBinMsgtype(this.binMsgBuffer);
            int compressType = (msgType & 0xE0) >> 5;
            if (compressType == 0 && this.compress) {
                this.binMsgBuffer.position(21);
                int bodyLen = this.binMsgBuffer.getInt();
                byte[] body = new byte[bodyLen];
                this.binMsgBuffer.get(body, 0, bodyLen);
                short attrLen = this.binMsgBuffer.getShort(25 + bodyLen);
                byte[] attr = new byte[2 + attrLen + 2];
                this.binMsgBuffer.get(attr, 0, attr.length);
                int guessLen = Snappy.maxCompressedLength((int)bodyLen);
                byte[] tmpData = new byte[guessLen];
                int realLen = Snappy.compress((byte[])body, (int)0, (int)body.length, (byte[])tmpData, (int)0);
                int totalDataLen = this.binMsgBuffer.getInt(0);
                ByteBuffer dataBuf = ByteBuffer.allocate(totalDataLen + 4 - body.length + realLen);
                dataBuf.put(this.binMsgBuffer.array(), 0, 21);
                dataBuf.put(4, (byte)(msgType | 0x20));
                dataBuf.putInt(0, realLen + attrLen + 29 - 4);
                dataBuf.putInt(21, realLen);
                System.arraycopy(tmpData, 0, dataBuf.array(), 25, realLen);
                System.arraycopy(attr, 0, dataBuf.array(), 25 + realLen, attr.length);
                out.write(dataBuf.array(), 0, dataBuf.capacity());
            } else {
                out.write(this.binMsgBuffer.array(), 0, this.binMsgBuffer.capacity());
            }
            this.writeMagic(out);
            out.close();
            return ByteBuffer.wrap(out.getData(), 0, out.getLength());
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public ByteBuffer build() {
        return this.build(System.currentTimeMillis() + this.timeoffset);
    }

    public ByteBuffer build(long createtime) {
        this.checkMode(true);
        if (this.version.intValue() != Version.v4.intValue()) {
            return this.defaultBuild(createtime);
        }
        return this.binBuild(createtime);
    }

    private void writeHeader(DataOutputBuffer out) throws IOException {
        this.writeMagic(out);
        if (this.version.intValue() == Version.v4.intValue()) {
            return;
        }
        if (this.version.intValue() >= Version.v1.intValue()) {
            out.writeLong(this.createtime);
        }
        if (this.version.intValue() >= Version.v2.intValue()) {
            out.writeInt(this.getMsgCnt());
        }
    }

    private void writeMagic(DataOutputBuffer out) throws IOException {
        if (this.version == Version.v1) {
            out.write(MAGIC1[0]);
            out.write(MAGIC1[1]);
        } else if (this.version == Version.v2) {
            out.write(MAGIC2[0]);
            out.write(MAGIC2[1]);
        } else if (this.version == Version.v3) {
            out.write(MAGIC3[0]);
            out.write(MAGIC3[1]);
        } else if (this.version == Version.v4) {
            out.write(MAGIC4[0]);
            out.write(MAGIC4[1]);
        } else {
            throw new IOException("wrong version : " + this.version.intValue());
        }
    }

    public byte[] buildArray() {
        return this.buildArray(System.currentTimeMillis() + this.timeoffset);
    }

    public byte[] buildArray(long createtime) {
        ByteBuffer buffer = this.build(createtime);
        if (buffer == null) {
            return null;
        }
        byte[] res = new byte[buffer.remaining()];
        System.arraycopy(buffer.array(), buffer.position(), res, 0, res.length);
        return res;
    }

    public void reset() {
        this.checkMode(true);
        this.attr2MsgBuffer.clear();
        this.datalen = this.getHeaderLen();
        this.msgcnt = 0;
    }

    private int getHeaderLen() {
        int len = 4;
        if (this.version.intValue() >= Version.v1.intValue()) {
            len += 8;
        }
        if (this.version.intValue() == Version.v2.intValue()) {
            len += 4;
        }
        return len + 4;
    }

    public int getMsgCnt() {
        return this.msgcnt;
    }

    public int getMsgCnt(String attr) {
        if (this.addmode) {
            return this.attr2MsgBuffer.get((Object)attr).cnt;
        }
        return this.attr2Rawdata.get((Object)attr).cnt;
    }

    private void checkMode(boolean add) {
        if (this.addmode != add) {
            throw new RuntimeException(this.addmode ? "illegal operation in add mode !!!" : "illegal operation in parse mode !!!");
        }
    }

    private InLongMsg(ByteBuffer buffer, Version magic) throws IOException {
        this.version = magic;
        this.addmode = false;
        this.capacity = 0;
        if (this.version.intValue() != Version.v4.intValue()) {
            this.parsedInput = new DataInputBuffer();
            this.parsedInput.reset(buffer.array(), buffer.position() + 2, buffer.remaining());
            if (this.version.intValue() >= Version.v1.intValue()) {
                this.createtime = this.parsedInput.readLong();
            }
            if (this.version.intValue() >= Version.v2.intValue()) {
                this.msgcnt = this.parsedInput.readInt();
            }
            this.attrcnt = this.parsedInput.readInt();
        } else {
            byte[] binMsg = new byte[buffer.remaining() - 2];
            System.arraycopy(buffer.array(), buffer.position() + 2, binMsg, 0, binMsg.length);
            this.parsedBinInput = ByteBuffer.wrap(binMsg);
            this.createtime = this.getBinCreatetime(this.parsedBinInput);
            this.msgcnt = this.getBinMsgCnt(this.parsedBinInput);
            this.isNumGroupId = this.getBinNumFlag(this.parsedBinInput);
            this.isSupportLF = this.getBinisSupportLF(this.parsedBinInput);
        }
    }

    private void parseDefault() throws IOException {
        this.attr2Rawdata = new LinkedHashMap(this.attrcnt * 10 / 7);
        for (int i = 0; i < this.attrcnt; ++i) {
            String attr = this.parsedInput.readUTF();
            int cnt = 0;
            if (this.version.intValue() == Version.v2.intValue()) {
                cnt = this.parsedInput.readInt();
            }
            int len = this.parsedInput.readInt();
            int pos = this.parsedInput.getPosition();
            this.attr2Rawdata.put(attr, new DataByteBuffer(cnt, ByteBuffer.wrap(this.parsedInput.getData(), pos, len)));
            this.parsedInput.skip(len);
        }
    }

    private void parseMixAttr() throws IOException {
        this.attr2Rawdata = new LinkedHashMap(this.msgcnt * 10 / 7);
        for (int i = 0; i < this.attrcnt; ++i) {
            ByteBuffer bodyBuffer;
            String commonAttr = this.parsedInput.readUTF();
            int len = this.parsedInput.readInt();
            byte compress = this.parsedInput.readByte();
            int pos = this.parsedInput.getPosition();
            if (compress == 1) {
                byte[] uncompressdata = new byte[Snappy.uncompressedLength((byte[])this.parsedInput.getData(), (int)pos, (int)(len - 1))];
                int msgLen = Snappy.uncompress((byte[])this.parsedInput.getData(), (int)pos, (int)(len - 1), (byte[])uncompressdata, (int)0);
                bodyBuffer = ByteBuffer.wrap(uncompressdata, 0, msgLen);
            } else {
                bodyBuffer = ByteBuffer.wrap(this.parsedInput.getData(), pos, len - 1);
            }
            this.parsedInput.skip(len - 1);
            while (bodyBuffer.remaining() > 0) {
                int singleTotalLen = bodyBuffer.getInt();
                if (singleTotalLen > bodyBuffer.remaining()) {
                    return;
                }
                while (singleTotalLen > 0) {
                    int msgItemLen = bodyBuffer.getInt();
                    if (msgItemLen <= 0 || msgItemLen > singleTotalLen) {
                        return;
                    }
                    byte[] record = new byte[5 + msgItemLen];
                    record[0] = 0;
                    record[1] = (byte)(msgItemLen >> 24 & 0xFF);
                    record[2] = (byte)(msgItemLen >> 16 & 0xFF);
                    record[3] = (byte)(msgItemLen >> 8 & 0xFF);
                    record[4] = (byte)(msgItemLen & 0xFF);
                    bodyBuffer.get(record, 5, msgItemLen);
                    int singleAttrLen = bodyBuffer.getInt();
                    if (singleAttrLen <= 0 || singleAttrLen > singleTotalLen) {
                        return;
                    }
                    byte[] attrBuf = new byte[singleAttrLen];
                    bodyBuffer.get(attrBuf, 0, singleAttrLen);
                    String finalAttr = commonAttr + "&" + new String(attrBuf);
                    DataByteBuffer inputBuffer = this.attr2Rawdata.get(finalAttr);
                    if (inputBuffer == null) {
                        inputBuffer = new DataByteBuffer(0, new DataOutputBuffer(msgItemLen + 4 + 1));
                        this.attr2Rawdata.put(finalAttr, inputBuffer);
                        inputBuffer.inoutBuffer.write(record, 0, msgItemLen + 4 + 1);
                    } else {
                        inputBuffer.inoutBuffer.write(record, 1, msgItemLen + 4);
                    }
                    singleTotalLen = singleTotalLen - msgItemLen - singleAttrLen - 8;
                }
            }
        }
        for (String attr : this.attr2Rawdata.keySet()) {
            DataByteBuffer data = this.attr2Rawdata.get(attr);
            data.syncByteBuffer();
        }
    }

    private void parseBinMsg() throws IOException {
        boolean isUseNumGroupId;
        ByteBuffer bodyBuffer;
        HashMap<String, String> commonAttrMap = new HashMap<String, String>();
        int totalLen = this.parsedBinInput.getInt(0);
        byte msgtype = this.parsedBinInput.get(4);
        short groupIdNum = this.parsedBinInput.getShort(5);
        short streamIdNum = this.parsedBinInput.getShort(7);
        int bodyLen = this.parsedBinInput.getInt(21);
        long dataTime = this.parsedBinInput.getInt(11);
        short extField = this.parsedBinInput.getShort(9);
        short attrLen = this.parsedBinInput.getShort(25 + bodyLen);
        int msgMagic = this.parsedBinInput.getShort(25 + bodyLen + 2 + attrLen) & 0xFFFF;
        dataTime *= 1000L;
        if (attrLen != 0) {
            byte[] attr = new byte[attrLen];
            this.parsedBinInput.position(25 + bodyLen + 2);
            this.parsedBinInput.get(attr);
            String strAttr = new String(attr);
            commonAttrMap = new HashMap(MAP_SPLITTER.split((CharSequence)strAttr));
        }
        commonAttrMap.put("dt", String.valueOf(dataTime));
        byte[] body = new byte[bodyLen + 1];
        this.parsedBinInput.position(25);
        this.parsedBinInput.get(body, 1, bodyLen);
        int zipType = (msgtype & 0xE0) >> 5;
        switch (zipType) {
            case 1: {
                byte[] uncompressdata = new byte[Snappy.uncompressedLength((byte[])body, (int)1, (int)(body.length - 1)) + 1];
                uncompressdata[0] = 0;
                int msgLen = Snappy.uncompress((byte[])body, (int)1, (int)(body.length - 1), (byte[])uncompressdata, (int)1);
                bodyBuffer = ByteBuffer.wrap(uncompressdata, 0, msgLen + 1);
                break;
            }
            default: {
                body[0] = 0;
                bodyBuffer = ByteBuffer.wrap(body, 0, body.length);
            }
        }
        boolean bl = isUseNumGroupId = (extField & 4) == 0;
        if (isUseNumGroupId) {
            commonAttrMap.put("groupId", String.valueOf(groupIdNum));
            commonAttrMap.put("streamId", String.valueOf(streamIdNum));
        }
        boolean hasOtherAttr = (extField & 1) == 1;
        commonAttrMap.put("cnt", String.valueOf(this.msgcnt));
        if (!hasOtherAttr) {
            this.attr2Rawdata = new LinkedHashMap();
            this.attr2Rawdata.put(MAP_JOINER.join(commonAttrMap), new DataByteBuffer(0, bodyBuffer));
        } else {
            this.attr2Rawdata = new LinkedHashMap(this.msgcnt * 10 / 7);
            HashMap<String, String> finalAttrMap = commonAttrMap;
            bodyBuffer.get();
            int bodyBufLen = bodyBuffer.capacity() - 1;
            while (bodyBufLen > 0) {
                int singleMsgLen = bodyBuffer.getInt();
                if (singleMsgLen <= 0 || singleMsgLen > bodyBufLen) {
                    return;
                }
                byte[] record = new byte[5 + singleMsgLen];
                record[0] = 0;
                record[1] = (byte)(singleMsgLen >> 24 & 0xFF);
                record[2] = (byte)(singleMsgLen >> 16 & 0xFF);
                record[3] = (byte)(singleMsgLen >> 8 & 0xFF);
                record[4] = (byte)(singleMsgLen & 0xFF);
                bodyBuffer.get(record, 5, singleMsgLen);
                int singleAttrLen = bodyBuffer.getInt();
                if (singleAttrLen <= 0 || singleAttrLen > bodyBufLen) {
                    return;
                }
                byte[] attrBuf = new byte[singleAttrLen];
                bodyBuffer.get(attrBuf, 0, singleAttrLen);
                String attrBufStr = new String(attrBuf);
                finalAttrMap = new HashMap(MAP_SPLITTER.split((CharSequence)attrBufStr));
                finalAttrMap.putAll(commonAttrMap);
                DataByteBuffer inputBuffer = this.attr2Rawdata.get(MAP_JOINER.join(finalAttrMap));
                if (inputBuffer == null) {
                    inputBuffer = new DataByteBuffer(0, new DataOutputBuffer(singleMsgLen + 4 + 1));
                    this.attr2Rawdata.put(MAP_JOINER.join(finalAttrMap), inputBuffer);
                    inputBuffer.inoutBuffer.write(record, 0, singleMsgLen + 4 + 1);
                } else {
                    inputBuffer.inoutBuffer.write(record, 1, singleMsgLen + 4);
                }
                bodyBufLen = bodyBufLen - singleMsgLen - singleAttrLen - 8;
            }
            for (String attr : this.attr2Rawdata.keySet()) {
                DataByteBuffer data = this.attr2Rawdata.get(attr);
                data.syncByteBuffer();
            }
        }
    }

    private void parse() throws IOException {
        if (this.parsed) {
            return;
        }
        if (this.version.intValue() < Version.v3.intValue()) {
            this.parseDefault();
        } else if (this.version.intValue() == Version.v3.intValue()) {
            this.parseMixAttr();
        } else {
            this.parseBinMsg();
        }
        this.parsed = true;
    }

    private static Version getMagic(ByteBuffer buffer) {
        byte[] array = buffer.array();
        if (buffer.remaining() < 4) {
            return Version.vn;
        }
        int pos = buffer.position();
        int rem = buffer.remaining();
        if (array[pos] == MAGIC1[0] && array[pos + 1] == MAGIC1[1] && array[pos + rem - 2] == MAGIC1[0] && array[pos + rem - 1] == MAGIC1[1]) {
            return Version.v1;
        }
        if (array[pos] == MAGIC2[0] && array[pos + 1] == MAGIC2[1] && array[pos + rem - 2] == MAGIC2[0] && array[pos + rem - 1] == MAGIC2[1]) {
            return Version.v2;
        }
        if (array[pos] == MAGIC3[0] && array[pos + 1] == MAGIC3[1] && array[pos + rem - 2] == MAGIC3[0] && array[pos + rem - 1] == MAGIC3[1]) {
            return Version.v3;
        }
        if (array[pos] == MAGIC4[0] && array[pos + 1] == MAGIC4[1] && array[pos + rem - 2] == MAGIC4[0] && array[pos + rem - 1] == MAGIC4[1]) {
            return Version.v4;
        }
        if (array[pos] == MAGIC0[0] && array[pos + 1] == MAGIC0[1] && array[pos + rem - 2] == MAGIC0[0] && array[pos + rem - 1] == MAGIC0[1]) {
            return Version.v0;
        }
        return Version.vn;
    }

    public static InLongMsg parseFrom(byte[] data) {
        return InLongMsg.parseFrom(ByteBuffer.wrap(data));
    }

    public static InLongMsg parseFrom(ByteBuffer buffer) {
        Version magic = InLongMsg.getMagic(buffer);
        if (magic == Version.vn) {
            return null;
        }
        try {
            return new InLongMsg(buffer, magic);
        }
        catch (IOException e) {
            return null;
        }
    }

    private void makeSureParsed() {
        if (!this.parsed) {
            try {
                this.parse();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public Set<String> getAttrs() {
        this.checkMode(false);
        this.makeSureParsed();
        return this.attr2Rawdata.keySet();
    }

    public byte[] getRawData(String attr) {
        this.checkMode(false);
        this.makeSureParsed();
        ByteBuffer buffer = this.getRawDataBuffer(attr);
        byte[] data = new byte[buffer.remaining()];
        System.arraycopy(buffer.array(), buffer.position(), data, 0, buffer.remaining());
        return data;
    }

    public ByteBuffer getRawDataBuffer(String attr) {
        this.checkMode(false);
        this.makeSureParsed();
        return this.attr2Rawdata.get((Object)attr).buffer;
    }

    public Iterator<byte[]> getIterator(String attr) {
        this.checkMode(false);
        this.makeSureParsed();
        return InLongMsg.getIterator(this.attr2Rawdata.get((Object)attr).buffer);
    }

    public static Iterator<byte[]> getIterator(byte[] rawdata) {
        return InLongMsg.getIterator(ByteBuffer.wrap(rawdata));
    }

    public static Iterator<byte[]> getIterator(ByteBuffer rawdata) {
        try {
            final DataInputBuffer input = new DataInputBuffer();
            byte[] array = rawdata.array();
            int pos = rawdata.position();
            int rem = rawdata.remaining() - 1;
            byte compress = array[pos];
            if (compress == 1) {
                byte[] uncompressdata = new byte[Snappy.uncompressedLength((byte[])array, (int)(pos + 1), (int)rem)];
                int len = Snappy.uncompress((byte[])array, (int)(pos + 1), (int)rem, (byte[])uncompressdata, (int)0);
                input.reset(uncompressdata, len);
            } else {
                input.reset(array, pos + 1, rem);
            }
            return new Iterator<byte[]>(){

                @Override
                public boolean hasNext() {
                    try {
                        return input.available() > 0;
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        return false;
                    }
                }

                @Override
                public byte[] next() {
                    try {
                        int len = input.readInt();
                        byte[] res = new byte[len];
                        input.read(res);
                        return res;
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        return null;
                    }
                }

                @Override
                public void remove() {
                    this.next();
                }
            };
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Iterator<ByteBuffer> getIteratorBuffer(byte[] rawdata) {
        return InLongMsg.getIteratorBuffer(ByteBuffer.wrap(rawdata));
    }

    public Iterator<ByteBuffer> getIteratorBuffer(String attr) {
        this.checkMode(false);
        this.makeSureParsed();
        return InLongMsg.getIteratorBuffer(this.attr2Rawdata.get((Object)attr).buffer);
    }

    public static Iterator<ByteBuffer> getIteratorBuffer(ByteBuffer rawdata) {
        try {
            byte[] uncompressdata;
            final DataInputBuffer input = new DataInputBuffer();
            byte[] array = rawdata.array();
            int pos = rawdata.position();
            int rem = rawdata.remaining() - 1;
            byte compress = array[pos];
            if (compress == 1) {
                uncompressdata = new byte[Snappy.uncompressedLength((byte[])array, (int)(pos + 1), (int)rem)];
                int len = Snappy.uncompress((byte[])array, (int)(pos + 1), (int)rem, (byte[])uncompressdata, (int)0);
                input.reset(uncompressdata, len);
            } else {
                input.reset(array, pos + 1, rem);
            }
            uncompressdata = input.getData();
            return new Iterator<ByteBuffer>(){

                @Override
                public boolean hasNext() {
                    try {
                        return input.available() > 0;
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        return false;
                    }
                }

                @Override
                public ByteBuffer next() {
                    try {
                        int len = input.readInt();
                        int pos = input.getPosition();
                        input.skip(len);
                        return ByteBuffer.wrap(uncompressdata, pos, len);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        return null;
                    }
                }

                @Override
                public void remove() {
                    this.next();
                }
            };
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public long getCreatetime() {
        return this.createtime;
    }

    public int getAttrCount() {
        this.checkMode(false);
        return this.attrcnt;
    }

    public boolean isNumGroupId() {
        this.checkMode(false);
        return this.isNumGroupId;
    }

    public boolean isSupportLF() {
        return this.isSupportLF;
    }

    static class DataByteBuffer {
        final int cnt;
        ByteBuffer buffer;
        DataOutputBuffer inoutBuffer;

        public DataByteBuffer(int cnt, ByteBuffer buffer) {
            this.cnt = cnt;
            this.buffer = buffer;
        }

        public DataByteBuffer(int cnt, DataOutputBuffer inoutbuffer) {
            this.cnt = cnt;
            this.inoutBuffer = inoutbuffer;
        }

        public void syncByteBuffer() {
            this.buffer = ByteBuffer.wrap(this.inoutBuffer.getData(), 0, this.inoutBuffer.getLength());
        }
    }

    private static enum Version {
        vn(-1),
        v0(0),
        v1(1),
        v2(2),
        v3(3),
        v4(4);

        private static final Map<Integer, Version> INT_TO_TYPE_MAP;
        private final int value;

        private Version(int value) {
            this.value = value;
        }

        public int intValue() {
            return this.value;
        }

        public static Version of(int v) {
            if (!INT_TO_TYPE_MAP.containsKey(v)) {
                return vn;
            }
            return INT_TO_TYPE_MAP.get(v);
        }

        static {
            INT_TO_TYPE_MAP = new HashMap<Integer, Version>();
            for (Version type : Version.values()) {
                INT_TO_TYPE_MAP.put(type.value, type);
            }
        }
    }

    static class DataBuffer {
        DataOutputBuffer out = new DataOutputBuffer();
        int cnt;

        public void write(byte[] array, int position, int len) throws IOException {
            ++this.cnt;
            this.out.writeInt(len);
            this.out.write(array, position, len);
        }
    }
}

