/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.common.enums;

import java.util.Objects;

public enum InlongCompressType {
    NONE(0, "NONE", "The message compressed with nothing"),
    INLONG_GZ(1, "INLONG_GZ", "The message compressed with inlong gz"),
    INLONG_SNAPPY(2, "INLONG_SNAPPY", "The message compressed with inlong snappy"),
    UNKNOWN(99, "UNKNOWN", "Unknown compress type");

    private final int id;
    private final String name;
    private final String desc;

    private InlongCompressType(int id, String name, String desc) {
        this.id = id;
        this.name = name;
        this.desc = desc;
    }

    public static InlongCompressType valueOf(int value) {
        for (InlongCompressType msgCompressType : InlongCompressType.values()) {
            if (msgCompressType.getId() != value) continue;
            return msgCompressType;
        }
        return UNKNOWN;
    }

    public static InlongCompressType forType(String type) {
        for (InlongCompressType msgCompressType : InlongCompressType.values()) {
            if (!Objects.equals(msgCompressType.getName(), type)) continue;
            return msgCompressType;
        }
        return UNKNOWN;
    }

    public int getId() {
        return this.id;
    }

    public String getStrId() {
        return String.valueOf(this.id);
    }

    public String getName() {
        return this.name;
    }

    public String getDesc() {
        return this.desc;
    }
}

