/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.common.enums;

import java.util.Objects;

public enum ManagerOpEnum {
    ADD(0),
    DEL(1),
    RETRY(2),
    BACKTRACK(3),
    FROZEN(4),
    ACTIVE(5),
    CHECK(6),
    REDOMETRIC(7),
    MAKEUP(8);

    private int type;

    private ManagerOpEnum(int type) {
        this.type = type;
    }

    public static ManagerOpEnum getOpType(int opType) {
        Objects.requireNonNull(opType);
        switch (opType) {
            case 0: {
                return ADD;
            }
            case 1: {
                return DEL;
            }
            case 2: {
                return RETRY;
            }
            case 3: {
                return BACKTRACK;
            }
            case 4: {
                return FROZEN;
            }
            case 5: {
                return ACTIVE;
            }
            case 6: {
                return CHECK;
            }
            case 7: {
                return REDOMETRIC;
            }
            case 8: {
                return MAKEUP;
            }
        }
        throw new RuntimeException("such op type doesn't exist");
    }

    public int getType() {
        return this.type;
    }
}

