/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.common.enums;

public enum ComponentTypeEnum {
    Agent("AGENT"),
    DataProxy("DATAPROXY"),
    Cache("CACHE"),
    Sort("SORT"),
    SDK("SDK");

    private final String name;

    private ComponentTypeEnum(String name) {
        this.name = name;
    }

    public static ComponentTypeEnum forName(String name) {
        for (ComponentTypeEnum componentType : ComponentTypeEnum.values()) {
            if (!componentType.getName().equals(name)) continue;
            return componentType;
        }
        throw new IllegalArgumentException(String.format("Unsupport componentName for Inlong:%s", name));
    }

    public String getName() {
        return this.name;
    }
}

