/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.common.enums;

public enum DataProxyErrCode {
    SUCCESS(0, "Ok"),
    SINK_SERVICE_UNREADY(1, "Service not ready"),
    ILLEGAL_VISIT_IP(10, "Illegal visit ip"),
    MISS_REQUIRED_GROUPID_ARGUMENT(100, "Parameter groupId is required"),
    MISS_REQUIRED_STREAMID_ARGUMENT(101, "Parameter streamId is required"),
    MISS_REQUIRED_DT_ARGUMENT(102, "Parameter dt is required"),
    MISS_REQUIRED_BODY_ARGUMENT(103, "Parameter body is required"),
    BODY_EXCEED_MAX_LEN(104, "Body length exceed the maximum length"),
    UNSUPPORTED_MSG_TYPE(110, "Unsupported msgType"),
    EMPTY_MSG(111, "Empty message"),
    UNSUPPORTED_EXTEND_FIELD_VALUE(112, "Unsupported extend field value"),
    UNCONFIGURED_GROUPID_OR_STREAMID(113, "Unconfigured groupId or streamId"),
    PUT_EVENT_TO_CHANNEL_FAILURE(114, "Put event to Channels failure"),
    TOPIC_IS_BLANK(115, "Topic is null"),
    NO_AVAILABLE_PRODUCER(116, "No available producer info"),
    PRODUCER_IS_NULL(117, "Producer is null"),
    SEND_REQUEST_TO_MQ_FAILURE(118, "Send request to MQ failure"),
    MQ_RETURN_ERROR(119, "MQ client return error"),
    DUPLICATED_MESSAGE(120, "Duplicated message"),
    UNKNOWN_ERROR(Integer.MAX_VALUE, "Unknown error");

    private final int errCode;
    private final String errMsg;

    private DataProxyErrCode(int errorCode, String errorMsg) {
        this.errCode = errorCode;
        this.errMsg = errorMsg;
    }

    public static DataProxyErrCode valueOf(int value) {
        for (DataProxyErrCode errCode : DataProxyErrCode.values()) {
            if (errCode.getErrCode() != value) continue;
            return errCode;
        }
        return UNKNOWN_ERROR;
    }

    public int getErrCode() {
        return this.errCode;
    }

    public String getErrCodeStr() {
        return String.valueOf(this.errCode);
    }

    public String getErrMsg() {
        return this.errMsg;
    }
}

