/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.common.enums;

import com.google.common.collect.ImmutableMap;
import java.util.EnumSet;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public enum Env {
    DEV,
    TEST,
    PROD;

    private static final Map<String, Env> NAME_MAP;

    public static Env forName(String name) {
        String nameUpper = StringUtils.upperCase((String)name);
        if (!NAME_MAP.containsKey(nameUpper)) {
            throw new IllegalArgumentException("Env type not support");
        }
        return NAME_MAP.get(nameUpper);
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Env value : EnumSet.allOf(Env.class)) {
            builder.put((Object)value.name(), (Object)value);
        }
        NAME_MAP = builder.build();
    }
}

