/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.common.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.Map;
import org.apache.inlong.manager.common.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;

@Component
public class HttpUtils {
    private static final Logger log = LoggerFactory.getLogger(HttpUtils.class);
    private static final Gson gson = new GsonBuilder().create();
    @Autowired
    private RestTemplate restTemplate;

    public <T> T request(String url, HttpMethod method, String param, HttpHeaders header, Class<T> cls) throws Exception {
        try {
            HttpEntity request = new HttpEntity((Object)param, (MultiValueMap)header);
            log.debug("send http request to {}, param {}", (Object)url, (Object)param);
            ResponseEntity exchange = this.restTemplate.exchange(url, method, request, String.class, new Object[0]);
            String body = (String)exchange.getBody();
            HttpStatus statusCode = exchange.getStatusCode();
            if (!statusCode.is2xxSuccessful()) {
                log.error("request error for {}, status code {}, body {}", new Object[]{url, statusCode, body});
            }
            log.debug("response from {}, status code {}", (Object)url, (Object)statusCode);
            return (T)gson.fromJson((String)exchange.getBody(), cls);
        }
        catch (RestClientException e) {
            log.error(" do request for {} exception {} ", (Object)url, (Object)e.getMessage());
            throw e;
        }
    }

    public <T> T request(String url, HttpMethod httpMethod, Object requestBody, HttpHeaders header, ParameterizedTypeReference<T> typeReference) {
        if (log.isDebugEnabled()) {
            log.debug("call {}, request body {}", (Object)url, (Object)gson.toJson(requestBody));
        }
        HttpEntity requestEntity = new HttpEntity(requestBody, (MultiValueMap)header);
        ResponseEntity response = this.restTemplate.exchange(url, httpMethod, requestEntity, typeReference, new Object[0]);
        if (log.isDebugEnabled()) {
            log.debug("call {}, status code {}", (Object)url, (Object)response.getStatusCode());
        }
        Preconditions.checkTrue(response.getStatusCode().is2xxSuccessful(), "Request failed");
        return (T)response.getBody();
    }

    public <T> T postRequest(String url, Object params, HttpHeaders header, ParameterizedTypeReference<T> typeReference) {
        return this.request(url, HttpMethod.POST, params, header, typeReference);
    }

    public <T> T getRequest(String url, Map<String, Object> params, HttpHeaders header, ParameterizedTypeReference<T> typeReference) {
        return this.request(this.buildUrlWithQueryParam(url, params), HttpMethod.GET, null, header, typeReference);
    }

    private String buildUrlWithQueryParam(String url, Map<String, Object> params) {
        if (params == null) {
            return url;
        }
        UriComponentsBuilder builder = UriComponentsBuilder.fromHttpUrl((String)url);
        params.entrySet().stream().filter(e -> e.getValue() != null).forEach(e -> builder.queryParam((String)e.getKey(), new Object[]{e.getValue()}));
        return builder.build(false).toUriString();
    }
}

