/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.common.pojo.datastorage;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Date;
import org.apache.inlong.manager.common.pojo.datastorage.StorageHiveInfo;

@ApiModel(value="Basic data storage information")
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, visible=true, property="storageType")
@JsonSubTypes(value={@JsonSubTypes.Type(value=StorageHiveInfo.class, name="HIVE")})
public class BaseStorageInfo {
    private Integer id;
    @ApiModelProperty(value="Business Identifier")
    private String businessIdentifier;
    @ApiModelProperty(value="Data stream identifier")
    private String dataStreamIdentifier;
    @ApiModelProperty(value="Storage type, including: HDFS, HIVE, ES, etc.")
    private String storageType;
    @ApiModelProperty(value="Data storage period, unit: day")
    private Integer storagePeriod;
    @ApiModelProperty(value="Status")
    private Integer status;
    @ApiModelProperty(value="Previous State")
    private Integer previousStatus;
    @ApiModelProperty(value="is deleted? 0: deleted, 1: not deleted")
    private Integer isDeleted = 0;
    private String creator;
    private String modifier;
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss")
    private Date createTime;
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss")
    private Date modifyTime;
    @ApiModelProperty(value="Temporary view, string in JSON format")
    private String tempView;

    public Integer getId() {
        return this.id;
    }

    public String getBusinessIdentifier() {
        return this.businessIdentifier;
    }

    public String getDataStreamIdentifier() {
        return this.dataStreamIdentifier;
    }

    public String getStorageType() {
        return this.storageType;
    }

    public Integer getStoragePeriod() {
        return this.storagePeriod;
    }

    public Integer getStatus() {
        return this.status;
    }

    public Integer getPreviousStatus() {
        return this.previousStatus;
    }

    public Integer getIsDeleted() {
        return this.isDeleted;
    }

    public String getCreator() {
        return this.creator;
    }

    public String getModifier() {
        return this.modifier;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public Date getModifyTime() {
        return this.modifyTime;
    }

    public String getTempView() {
        return this.tempView;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public void setBusinessIdentifier(String businessIdentifier) {
        this.businessIdentifier = businessIdentifier;
    }

    public void setDataStreamIdentifier(String dataStreamIdentifier) {
        this.dataStreamIdentifier = dataStreamIdentifier;
    }

    public void setStorageType(String storageType) {
        this.storageType = storageType;
    }

    public void setStoragePeriod(Integer storagePeriod) {
        this.storagePeriod = storagePeriod;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public void setPreviousStatus(Integer previousStatus) {
        this.previousStatus = previousStatus;
    }

    public void setIsDeleted(Integer isDeleted) {
        this.isDeleted = isDeleted;
    }

    public void setCreator(String creator) {
        this.creator = creator;
    }

    public void setModifier(String modifier) {
        this.modifier = modifier;
    }

    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss")
    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss")
    public void setModifyTime(Date modifyTime) {
        this.modifyTime = modifyTime;
    }

    public void setTempView(String tempView) {
        this.tempView = tempView;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BaseStorageInfo)) {
            return false;
        }
        BaseStorageInfo other = (BaseStorageInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$id = this.getId();
        Integer other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Integer this$storagePeriod = this.getStoragePeriod();
        Integer other$storagePeriod = other.getStoragePeriod();
        if (this$storagePeriod == null ? other$storagePeriod != null : !((Object)this$storagePeriod).equals(other$storagePeriod)) {
            return false;
        }
        Integer this$status = this.getStatus();
        Integer other$status = other.getStatus();
        if (this$status == null ? other$status != null : !((Object)this$status).equals(other$status)) {
            return false;
        }
        Integer this$previousStatus = this.getPreviousStatus();
        Integer other$previousStatus = other.getPreviousStatus();
        if (this$previousStatus == null ? other$previousStatus != null : !((Object)this$previousStatus).equals(other$previousStatus)) {
            return false;
        }
        Integer this$isDeleted = this.getIsDeleted();
        Integer other$isDeleted = other.getIsDeleted();
        if (this$isDeleted == null ? other$isDeleted != null : !((Object)this$isDeleted).equals(other$isDeleted)) {
            return false;
        }
        String this$businessIdentifier = this.getBusinessIdentifier();
        String other$businessIdentifier = other.getBusinessIdentifier();
        if (this$businessIdentifier == null ? other$businessIdentifier != null : !this$businessIdentifier.equals(other$businessIdentifier)) {
            return false;
        }
        String this$dataStreamIdentifier = this.getDataStreamIdentifier();
        String other$dataStreamIdentifier = other.getDataStreamIdentifier();
        if (this$dataStreamIdentifier == null ? other$dataStreamIdentifier != null : !this$dataStreamIdentifier.equals(other$dataStreamIdentifier)) {
            return false;
        }
        String this$storageType = this.getStorageType();
        String other$storageType = other.getStorageType();
        if (this$storageType == null ? other$storageType != null : !this$storageType.equals(other$storageType)) {
            return false;
        }
        String this$creator = this.getCreator();
        String other$creator = other.getCreator();
        if (this$creator == null ? other$creator != null : !this$creator.equals(other$creator)) {
            return false;
        }
        String this$modifier = this.getModifier();
        String other$modifier = other.getModifier();
        if (this$modifier == null ? other$modifier != null : !this$modifier.equals(other$modifier)) {
            return false;
        }
        Date this$createTime = this.getCreateTime();
        Date other$createTime = other.getCreateTime();
        if (this$createTime == null ? other$createTime != null : !((Object)this$createTime).equals(other$createTime)) {
            return false;
        }
        Date this$modifyTime = this.getModifyTime();
        Date other$modifyTime = other.getModifyTime();
        if (this$modifyTime == null ? other$modifyTime != null : !((Object)this$modifyTime).equals(other$modifyTime)) {
            return false;
        }
        String this$tempView = this.getTempView();
        String other$tempView = other.getTempView();
        return !(this$tempView == null ? other$tempView != null : !this$tempView.equals(other$tempView));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BaseStorageInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Integer $storagePeriod = this.getStoragePeriod();
        result = result * 59 + ($storagePeriod == null ? 43 : ((Object)$storagePeriod).hashCode());
        Integer $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : ((Object)$status).hashCode());
        Integer $previousStatus = this.getPreviousStatus();
        result = result * 59 + ($previousStatus == null ? 43 : ((Object)$previousStatus).hashCode());
        Integer $isDeleted = this.getIsDeleted();
        result = result * 59 + ($isDeleted == null ? 43 : ((Object)$isDeleted).hashCode());
        String $businessIdentifier = this.getBusinessIdentifier();
        result = result * 59 + ($businessIdentifier == null ? 43 : $businessIdentifier.hashCode());
        String $dataStreamIdentifier = this.getDataStreamIdentifier();
        result = result * 59 + ($dataStreamIdentifier == null ? 43 : $dataStreamIdentifier.hashCode());
        String $storageType = this.getStorageType();
        result = result * 59 + ($storageType == null ? 43 : $storageType.hashCode());
        String $creator = this.getCreator();
        result = result * 59 + ($creator == null ? 43 : $creator.hashCode());
        String $modifier = this.getModifier();
        result = result * 59 + ($modifier == null ? 43 : $modifier.hashCode());
        Date $createTime = this.getCreateTime();
        result = result * 59 + ($createTime == null ? 43 : ((Object)$createTime).hashCode());
        Date $modifyTime = this.getModifyTime();
        result = result * 59 + ($modifyTime == null ? 43 : ((Object)$modifyTime).hashCode());
        String $tempView = this.getTempView();
        result = result * 59 + ($tempView == null ? 43 : $tempView.hashCode());
        return result;
    }

    public String toString() {
        return "BaseStorageInfo(id=" + this.getId() + ", businessIdentifier=" + this.getBusinessIdentifier() + ", dataStreamIdentifier=" + this.getDataStreamIdentifier() + ", storageType=" + this.getStorageType() + ", storagePeriod=" + this.getStoragePeriod() + ", status=" + this.getStatus() + ", previousStatus=" + this.getPreviousStatus() + ", isDeleted=" + this.getIsDeleted() + ", creator=" + this.getCreator() + ", modifier=" + this.getModifier() + ", createTime=" + this.getCreateTime() + ", modifyTime=" + this.getModifyTime() + ", tempView=" + this.getTempView() + ")";
    }
}

