/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.common.enums;

import com.google.common.collect.Lists;
import java.util.Map;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.manager.common.util.InLongCollectionUtils;

public enum Env {
    DEV,
    TEST,
    PROD;

    private static final Map<String, Env> NAME_MAP;

    public static Env forName(String name) {
        String nameUpper = StringUtils.upperCase((String)name);
        if (!NAME_MAP.containsKey(nameUpper)) {
            throw new IllegalArgumentException("Env type not support");
        }
        return NAME_MAP.get(nameUpper);
    }

    static {
        NAME_MAP = InLongCollectionUtils.transformToImmutableMap(Lists.newArrayList((Object[])Env.values()), Enum::name, Function.identity());
    }
}

