/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.common.enums;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.swagger.annotations.ApiModel;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.inlong.manager.common.util.Preconditions;

@ApiModel(value="Data consumption status")
public enum ConsumptionStatus {
    WAITING_ASSIGN(10),
    WAITING_APPROVE(11),
    REJECTED(20),
    APPROVED(21),
    CANCELED(22);

    public static final Set<ConsumptionStatus> ALLOW_SAVE_UPDATE_STATUS;
    public static final Set<ConsumptionStatus> ALLOW_START_WORKFLOW_STATUS;
    private static final Map<Integer, ConsumptionStatus> STATUS_MAP;
    private final int status;

    private ConsumptionStatus(int status) {
        this.status = status;
    }

    public static ConsumptionStatus fromStatus(int status) {
        ConsumptionStatus consumptionStatus = STATUS_MAP.get(status);
        Preconditions.checkNotNull((Object)consumptionStatus, "status is unavailable :" + status);
        return consumptionStatus;
    }

    public int getStatus() {
        return this.status;
    }

    static {
        ALLOW_SAVE_UPDATE_STATUS = ImmutableSet.of((Object)((Object)WAITING_ASSIGN), (Object)((Object)REJECTED), (Object)((Object)CANCELED));
        ALLOW_START_WORKFLOW_STATUS = ImmutableSet.of((Object)((Object)WAITING_ASSIGN));
        ImmutableMap.Builder builder = ImmutableMap.builder();
        Stream.of(ConsumptionStatus.values()).forEach(status -> builder.put((Object)status.status, (Object)status));
        STATUS_MAP = builder.build();
    }
}

