/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.common.enums;

import java.util.Arrays;
import java.util.List;

public enum EntityStatus {
    UN_DELETED(0, "not deleted"),
    IS_DELETED(1, "already deleted"),
    DRAFT(0, "draft"),
    NORMAL(10, "normal"),
    FAILURE(20, "failure"),
    CANCELED(30, "canceled"),
    DELETED(40, "deleted"),
    BIZ_WAIT_SUBMIT(100, "waiting for submit"),
    BIZ_WAIT_APPROVAL(101, "waiting for approval"),
    BIZ_APPROVE_REJECTED(102, "approval rejected"),
    BIZ_APPROVE_PASSED(103, "approval passed"),
    BIZ_CONFIG_ING(110, "in configure"),
    BIZ_CONFIG_FAILED(120, "configuration failed"),
    BIZ_CONFIG_SUCCESSFUL(130, "configuration successful"),
    DATA_STREAM_NEW(100, "new"),
    DATA_STREAM_CONFIG_ING(110, "in configure"),
    DATA_STREAM_CONFIG_FAILED(120, "configuration failed"),
    DATA_STREAM_CONFIG_SUCCESSFUL(130, "configuration successful"),
    DATA_STORAGE_NEW(100, "new"),
    DATA_STORAGE_CONFIG_ING(110, "in configure"),
    DATA_STORAGE_CONFIG_FAILED(120, "configuration failed"),
    DATA_STORAGE_CONFIG_SUCCESSFUL(130, "configuration successful"),
    DATA_RESOURCE_NEW(200, "new"),
    DATA_RESOURCE_DELETE(201, "deleted"),
    AGENT_WAIT_CREATE(200, "wait create"),
    AGENT_WAIT_STOP(201, "wait stop"),
    AGENT_WAIT_START(203, "wait start"),
    AGENT_WAIT_DELETE(204, "wait delete"),
    AGENT_WAIT_UPDATE(205, "wait update");

    public static final List<Integer> ALLOW_START_WORKFLOW_STATUS;
    public static final List<Integer> ALLOW_UPDATE_BIZ_STATUS;
    public static final List<Integer> ALLOW_DELETE_BIZ_STATUS;
    public static final List<Integer> ALLOW_DELETE_BIZ_CASCADE_STATUS;
    public static final List<Integer> BIZ_APPROVE_PASS_STATUS;
    public static final List<Integer> BIZ_TEMP_STATUS;
    private final Integer code;
    private final String description;

    private EntityStatus(Integer code, String description) {
        this.code = code;
        this.description = description;
    }

    public Integer getCode() {
        return this.code;
    }

    public String getDescription() {
        return this.description;
    }

    static {
        ALLOW_START_WORKFLOW_STATUS = Arrays.asList(BIZ_WAIT_SUBMIT.getCode(), BIZ_APPROVE_REJECTED.getCode(), BIZ_CONFIG_FAILED.getCode(), BIZ_CONFIG_SUCCESSFUL.getCode());
        ALLOW_UPDATE_BIZ_STATUS = Arrays.asList(DRAFT.getCode(), BIZ_WAIT_SUBMIT.getCode(), BIZ_APPROVE_REJECTED.getCode(), BIZ_CONFIG_FAILED.getCode(), BIZ_CONFIG_SUCCESSFUL.getCode());
        ALLOW_DELETE_BIZ_STATUS = Arrays.asList(DRAFT.getCode(), BIZ_WAIT_SUBMIT.getCode(), BIZ_APPROVE_REJECTED.getCode(), BIZ_CONFIG_ING.getCode(), BIZ_CONFIG_FAILED.getCode(), BIZ_CONFIG_SUCCESSFUL.getCode());
        ALLOW_DELETE_BIZ_CASCADE_STATUS = Arrays.asList(DRAFT.getCode(), BIZ_WAIT_SUBMIT.getCode());
        BIZ_APPROVE_PASS_STATUS = Arrays.asList(BIZ_CONFIG_FAILED.getCode(), BIZ_CONFIG_SUCCESSFUL.getCode());
        BIZ_TEMP_STATUS = Arrays.asList(BIZ_WAIT_APPROVAL.getCode(), BIZ_CONFIG_ING.getCode());
    }
}

