/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.common.pojo.dataconsumption;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Date;
import javax.validation.constraints.AssertTrue;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.StringUtils;

@ApiModel(value="Data consumption info")
public class ConsumptionInfo {
    @ApiModelProperty(value="key id")
    private Integer id;
    @ApiModelProperty(value="consumer group id")
    @NotBlank(message="consumerGroupId can't be null")
    private @NotBlank(message="consumerGroupId can't be null") String consumerGroupId;
    @ApiModelProperty(value="consumer group name: only support [a-zA-Z0-9_]")
    @NotBlank(message="consumerGroupName can't be null")
    private @NotBlank(message="consumerGroupName can't be null") String consumerGroupName;
    @ApiModelProperty(value="consumption in charge")
    @NotNull(message="inCharges can't be null")
    private @NotNull(message="inCharges can't be null") String inCharges;
    @ApiModelProperty(value="consumption target business identifier")
    @NotBlank(message="businessIdentifier can't be null")
    private @NotBlank(message="businessIdentifier can't be null") String businessIdentifier;
    @ApiModelProperty(value="middleware type for data storage, support Tube, which has high throughput")
    @NotBlank(message="middlewareType can't be null")
    private @NotBlank(message="middlewareType can't be null") String middlewareType;
    @ApiModelProperty(value="consumption target topic")
    private String topic;
    @ApiModelProperty(value="middleware cluster url")
    private String masterUrl;
    @ApiModelProperty(value="whether to filter consumption, 0: not filter, 1: filter")
    private Integer filterEnabled = 0;
    @ApiModelProperty(value="consumption target data stream identifier")
    private String dataStreamIdentifier;
    @ApiModelProperty(value="status, 10: pending assigned, 11: pending approval, 20: approval rejected, 20: approved")
    private Integer status;
    private String creator;
    private String modifier;
    private Date createTime;
    private Date modifyTime;

    @JsonIgnore
    @AssertTrue(message="when filter enabled, dataStreamIdentifier can't be null")
    public @AssertTrue(message="when filter enabled, dataStreamIdentifier can't be null") boolean isValidateFilter() {
        if (this.filterEnabled == 0) {
            return true;
        }
        return StringUtils.isNotBlank((CharSequence)this.dataStreamIdentifier);
    }

    public static ConsumptionInfoBuilder builder() {
        return new ConsumptionInfoBuilder();
    }

    public Integer getId() {
        return this.id;
    }

    public String getConsumerGroupId() {
        return this.consumerGroupId;
    }

    public String getConsumerGroupName() {
        return this.consumerGroupName;
    }

    public String getInCharges() {
        return this.inCharges;
    }

    public String getBusinessIdentifier() {
        return this.businessIdentifier;
    }

    public String getMiddlewareType() {
        return this.middlewareType;
    }

    public String getTopic() {
        return this.topic;
    }

    public String getMasterUrl() {
        return this.masterUrl;
    }

    public Integer getFilterEnabled() {
        return this.filterEnabled;
    }

    public String getDataStreamIdentifier() {
        return this.dataStreamIdentifier;
    }

    public Integer getStatus() {
        return this.status;
    }

    public String getCreator() {
        return this.creator;
    }

    public String getModifier() {
        return this.modifier;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public Date getModifyTime() {
        return this.modifyTime;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public void setConsumerGroupId(String consumerGroupId) {
        this.consumerGroupId = consumerGroupId;
    }

    public void setConsumerGroupName(String consumerGroupName) {
        this.consumerGroupName = consumerGroupName;
    }

    public void setInCharges(String inCharges) {
        this.inCharges = inCharges;
    }

    public void setBusinessIdentifier(String businessIdentifier) {
        this.businessIdentifier = businessIdentifier;
    }

    public void setMiddlewareType(String middlewareType) {
        this.middlewareType = middlewareType;
    }

    public void setTopic(String topic) {
        this.topic = topic;
    }

    public void setMasterUrl(String masterUrl) {
        this.masterUrl = masterUrl;
    }

    public void setFilterEnabled(Integer filterEnabled) {
        this.filterEnabled = filterEnabled;
    }

    public void setDataStreamIdentifier(String dataStreamIdentifier) {
        this.dataStreamIdentifier = dataStreamIdentifier;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public void setCreator(String creator) {
        this.creator = creator;
    }

    public void setModifier(String modifier) {
        this.modifier = modifier;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public void setModifyTime(Date modifyTime) {
        this.modifyTime = modifyTime;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ConsumptionInfo)) {
            return false;
        }
        ConsumptionInfo other = (ConsumptionInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$id = this.getId();
        Integer other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Integer this$filterEnabled = this.getFilterEnabled();
        Integer other$filterEnabled = other.getFilterEnabled();
        if (this$filterEnabled == null ? other$filterEnabled != null : !((Object)this$filterEnabled).equals(other$filterEnabled)) {
            return false;
        }
        Integer this$status = this.getStatus();
        Integer other$status = other.getStatus();
        if (this$status == null ? other$status != null : !((Object)this$status).equals(other$status)) {
            return false;
        }
        String this$consumerGroupId = this.getConsumerGroupId();
        String other$consumerGroupId = other.getConsumerGroupId();
        if (this$consumerGroupId == null ? other$consumerGroupId != null : !this$consumerGroupId.equals(other$consumerGroupId)) {
            return false;
        }
        String this$consumerGroupName = this.getConsumerGroupName();
        String other$consumerGroupName = other.getConsumerGroupName();
        if (this$consumerGroupName == null ? other$consumerGroupName != null : !this$consumerGroupName.equals(other$consumerGroupName)) {
            return false;
        }
        String this$inCharges = this.getInCharges();
        String other$inCharges = other.getInCharges();
        if (this$inCharges == null ? other$inCharges != null : !this$inCharges.equals(other$inCharges)) {
            return false;
        }
        String this$businessIdentifier = this.getBusinessIdentifier();
        String other$businessIdentifier = other.getBusinessIdentifier();
        if (this$businessIdentifier == null ? other$businessIdentifier != null : !this$businessIdentifier.equals(other$businessIdentifier)) {
            return false;
        }
        String this$middlewareType = this.getMiddlewareType();
        String other$middlewareType = other.getMiddlewareType();
        if (this$middlewareType == null ? other$middlewareType != null : !this$middlewareType.equals(other$middlewareType)) {
            return false;
        }
        String this$topic = this.getTopic();
        String other$topic = other.getTopic();
        if (this$topic == null ? other$topic != null : !this$topic.equals(other$topic)) {
            return false;
        }
        String this$masterUrl = this.getMasterUrl();
        String other$masterUrl = other.getMasterUrl();
        if (this$masterUrl == null ? other$masterUrl != null : !this$masterUrl.equals(other$masterUrl)) {
            return false;
        }
        String this$dataStreamIdentifier = this.getDataStreamIdentifier();
        String other$dataStreamIdentifier = other.getDataStreamIdentifier();
        if (this$dataStreamIdentifier == null ? other$dataStreamIdentifier != null : !this$dataStreamIdentifier.equals(other$dataStreamIdentifier)) {
            return false;
        }
        String this$creator = this.getCreator();
        String other$creator = other.getCreator();
        if (this$creator == null ? other$creator != null : !this$creator.equals(other$creator)) {
            return false;
        }
        String this$modifier = this.getModifier();
        String other$modifier = other.getModifier();
        if (this$modifier == null ? other$modifier != null : !this$modifier.equals(other$modifier)) {
            return false;
        }
        Date this$createTime = this.getCreateTime();
        Date other$createTime = other.getCreateTime();
        if (this$createTime == null ? other$createTime != null : !((Object)this$createTime).equals(other$createTime)) {
            return false;
        }
        Date this$modifyTime = this.getModifyTime();
        Date other$modifyTime = other.getModifyTime();
        return !(this$modifyTime == null ? other$modifyTime != null : !((Object)this$modifyTime).equals(other$modifyTime));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ConsumptionInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Integer $filterEnabled = this.getFilterEnabled();
        result = result * 59 + ($filterEnabled == null ? 43 : ((Object)$filterEnabled).hashCode());
        Integer $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : ((Object)$status).hashCode());
        String $consumerGroupId = this.getConsumerGroupId();
        result = result * 59 + ($consumerGroupId == null ? 43 : $consumerGroupId.hashCode());
        String $consumerGroupName = this.getConsumerGroupName();
        result = result * 59 + ($consumerGroupName == null ? 43 : $consumerGroupName.hashCode());
        String $inCharges = this.getInCharges();
        result = result * 59 + ($inCharges == null ? 43 : $inCharges.hashCode());
        String $businessIdentifier = this.getBusinessIdentifier();
        result = result * 59 + ($businessIdentifier == null ? 43 : $businessIdentifier.hashCode());
        String $middlewareType = this.getMiddlewareType();
        result = result * 59 + ($middlewareType == null ? 43 : $middlewareType.hashCode());
        String $topic = this.getTopic();
        result = result * 59 + ($topic == null ? 43 : $topic.hashCode());
        String $masterUrl = this.getMasterUrl();
        result = result * 59 + ($masterUrl == null ? 43 : $masterUrl.hashCode());
        String $dataStreamIdentifier = this.getDataStreamIdentifier();
        result = result * 59 + ($dataStreamIdentifier == null ? 43 : $dataStreamIdentifier.hashCode());
        String $creator = this.getCreator();
        result = result * 59 + ($creator == null ? 43 : $creator.hashCode());
        String $modifier = this.getModifier();
        result = result * 59 + ($modifier == null ? 43 : $modifier.hashCode());
        Date $createTime = this.getCreateTime();
        result = result * 59 + ($createTime == null ? 43 : ((Object)$createTime).hashCode());
        Date $modifyTime = this.getModifyTime();
        result = result * 59 + ($modifyTime == null ? 43 : ((Object)$modifyTime).hashCode());
        return result;
    }

    public String toString() {
        return "ConsumptionInfo(id=" + this.getId() + ", consumerGroupId=" + this.getConsumerGroupId() + ", consumerGroupName=" + this.getConsumerGroupName() + ", inCharges=" + this.getInCharges() + ", businessIdentifier=" + this.getBusinessIdentifier() + ", middlewareType=" + this.getMiddlewareType() + ", topic=" + this.getTopic() + ", masterUrl=" + this.getMasterUrl() + ", filterEnabled=" + this.getFilterEnabled() + ", dataStreamIdentifier=" + this.getDataStreamIdentifier() + ", status=" + this.getStatus() + ", creator=" + this.getCreator() + ", modifier=" + this.getModifier() + ", createTime=" + this.getCreateTime() + ", modifyTime=" + this.getModifyTime() + ")";
    }

    public ConsumptionInfo() {
    }

    public ConsumptionInfo(Integer id, String consumerGroupId, String consumerGroupName, String inCharges, String businessIdentifier, String middlewareType, String topic, String masterUrl, Integer filterEnabled, String dataStreamIdentifier, Integer status, String creator, String modifier, Date createTime, Date modifyTime) {
        this.id = id;
        this.consumerGroupId = consumerGroupId;
        this.consumerGroupName = consumerGroupName;
        this.inCharges = inCharges;
        this.businessIdentifier = businessIdentifier;
        this.middlewareType = middlewareType;
        this.topic = topic;
        this.masterUrl = masterUrl;
        this.filterEnabled = filterEnabled;
        this.dataStreamIdentifier = dataStreamIdentifier;
        this.status = status;
        this.creator = creator;
        this.modifier = modifier;
        this.createTime = createTime;
        this.modifyTime = modifyTime;
    }

    public static class ConsumptionInfoBuilder {
        private Integer id;
        private String consumerGroupId;
        private String consumerGroupName;
        private String inCharges;
        private String businessIdentifier;
        private String middlewareType;
        private String topic;
        private String masterUrl;
        private Integer filterEnabled;
        private String dataStreamIdentifier;
        private Integer status;
        private String creator;
        private String modifier;
        private Date createTime;
        private Date modifyTime;

        ConsumptionInfoBuilder() {
        }

        public ConsumptionInfoBuilder id(Integer id) {
            this.id = id;
            return this;
        }

        public ConsumptionInfoBuilder consumerGroupId(String consumerGroupId) {
            this.consumerGroupId = consumerGroupId;
            return this;
        }

        public ConsumptionInfoBuilder consumerGroupName(String consumerGroupName) {
            this.consumerGroupName = consumerGroupName;
            return this;
        }

        public ConsumptionInfoBuilder inCharges(String inCharges) {
            this.inCharges = inCharges;
            return this;
        }

        public ConsumptionInfoBuilder businessIdentifier(String businessIdentifier) {
            this.businessIdentifier = businessIdentifier;
            return this;
        }

        public ConsumptionInfoBuilder middlewareType(String middlewareType) {
            this.middlewareType = middlewareType;
            return this;
        }

        public ConsumptionInfoBuilder topic(String topic) {
            this.topic = topic;
            return this;
        }

        public ConsumptionInfoBuilder masterUrl(String masterUrl) {
            this.masterUrl = masterUrl;
            return this;
        }

        public ConsumptionInfoBuilder filterEnabled(Integer filterEnabled) {
            this.filterEnabled = filterEnabled;
            return this;
        }

        public ConsumptionInfoBuilder dataStreamIdentifier(String dataStreamIdentifier) {
            this.dataStreamIdentifier = dataStreamIdentifier;
            return this;
        }

        public ConsumptionInfoBuilder status(Integer status) {
            this.status = status;
            return this;
        }

        public ConsumptionInfoBuilder creator(String creator) {
            this.creator = creator;
            return this;
        }

        public ConsumptionInfoBuilder modifier(String modifier) {
            this.modifier = modifier;
            return this;
        }

        public ConsumptionInfoBuilder createTime(Date createTime) {
            this.createTime = createTime;
            return this;
        }

        public ConsumptionInfoBuilder modifyTime(Date modifyTime) {
            this.modifyTime = modifyTime;
            return this;
        }

        public ConsumptionInfo build() {
            return new ConsumptionInfo(this.id, this.consumerGroupId, this.consumerGroupName, this.inCharges, this.businessIdentifier, this.middlewareType, this.topic, this.masterUrl, this.filterEnabled, this.dataStreamIdentifier, this.status, this.creator, this.modifier, this.createTime, this.modifyTime);
        }

        public String toString() {
            return "ConsumptionInfo.ConsumptionInfoBuilder(id=" + this.id + ", consumerGroupId=" + this.consumerGroupId + ", consumerGroupName=" + this.consumerGroupName + ", inCharges=" + this.inCharges + ", businessIdentifier=" + this.businessIdentifier + ", middlewareType=" + this.middlewareType + ", topic=" + this.topic + ", masterUrl=" + this.masterUrl + ", filterEnabled=" + this.filterEnabled + ", dataStreamIdentifier=" + this.dataStreamIdentifier + ", status=" + this.status + ", creator=" + this.creator + ", modifier=" + this.modifier + ", createTime=" + this.createTime + ", modifyTime=" + this.modifyTime + ")";
        }
    }
}

