/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.common.event.process;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.inlong.manager.common.dao.EventLogStorage;
import org.apache.inlong.manager.common.event.EventListenerManager;
import org.apache.inlong.manager.common.event.process.LogableProcessEventListener;
import org.apache.inlong.manager.common.event.process.ProcessEvent;
import org.apache.inlong.manager.common.event.process.ProcessEventListener;
import org.apache.inlong.manager.common.exceptions.WorkflowListenerException;
import org.apache.inlong.manager.common.workflow.WorkflowDataAccessor;

public class ProcessEventListenerManager
implements EventListenerManager<ProcessEvent, ProcessEventListener> {
    private static final List<ProcessEventListener> EMPTY = Lists.newArrayList();
    private Map<ProcessEvent, List<ProcessEventListener>> syncProcessEventListeners = Maps.newHashMap();
    private Map<ProcessEvent, List<ProcessEventListener>> asyncProcessEventListeners = Maps.newHashMap();
    private Map<String, ProcessEventListener> processEventListeners = Maps.newHashMap();
    private WorkflowDataAccessor workflowDataAccessor;

    public ProcessEventListenerManager(WorkflowDataAccessor workflowDataAccessor) {
        this.workflowDataAccessor = workflowDataAccessor;
    }

    @Override
    public void register(ProcessEventListener listener) {
        if (this.processEventListeners.containsKey(listener.name())) {
            throw new WorkflowListenerException("duplicate listener:" + listener.name());
        }
        this.processEventListeners.put(listener.name(), listener);
        if (listener.async()) {
            this.asyncProcessEventListeners.computeIfAbsent((ProcessEvent)listener.event(), (Function<ProcessEvent, List<ProcessEventListener>>)((Function<ProcessEvent, List>)a -> Lists.newArrayList())).add(this.enhanceListener(listener));
            return;
        }
        this.syncProcessEventListeners.computeIfAbsent((ProcessEvent)listener.event(), (Function<ProcessEvent, List<ProcessEventListener>>)((Function<ProcessEvent, List>)a -> Lists.newArrayList())).add(this.enhanceListener(listener));
    }

    private ProcessEventListener enhanceListener(ProcessEventListener processEventListener) {
        EventLogStorage eventLogStorage = this.workflowDataAccessor.eventLogStorage();
        if (eventLogStorage == null) {
            return processEventListener;
        }
        return new LogableProcessEventListener(processEventListener, eventLogStorage);
    }

    @Override
    public List<ProcessEventListener> asyncListeners(ProcessEvent event) {
        return this.asyncProcessEventListeners.getOrDefault(event, EMPTY);
    }

    @Override
    public List<ProcessEventListener> syncListeners(ProcessEvent event) {
        return this.syncProcessEventListeners.getOrDefault(event, EMPTY);
    }

    @Override
    public ProcessEventListener listener(String listenerName) {
        return this.processEventListeners.get(listenerName);
    }

    @Override
    public EventLogStorage eventLogStorage() {
        return this.workflowDataAccessor.eventLogStorage();
    }
}

