/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.common.event.task;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.inlong.manager.common.dao.EventLogStorage;
import org.apache.inlong.manager.common.event.EventListenerManager;
import org.apache.inlong.manager.common.event.task.LogableTaskEventListener;
import org.apache.inlong.manager.common.event.task.TaskEvent;
import org.apache.inlong.manager.common.event.task.TaskEventListener;
import org.apache.inlong.manager.common.exceptions.WorkflowListenerException;
import org.apache.inlong.manager.common.workflow.WorkflowDataAccessor;

public class TaskEventListenerManager
implements EventListenerManager<TaskEvent, TaskEventListener> {
    private Map<TaskEvent, List<TaskEventListener>> syncTaskEventListeners = Maps.newHashMap();
    private Map<TaskEvent, List<TaskEventListener>> asyncTaskEventListeners = Maps.newHashMap();
    private Map<String, TaskEventListener> taskEventListeners = Maps.newHashMap();
    private WorkflowDataAccessor workflowDataAccessor;

    public TaskEventListenerManager(WorkflowDataAccessor workflowDataAccessor) {
        this.workflowDataAccessor = workflowDataAccessor;
    }

    @Override
    public void register(TaskEventListener listener) {
        if (this.taskEventListeners.containsKey(listener.name())) {
            throw new WorkflowListenerException("duplicate listener:" + listener.name());
        }
        this.taskEventListeners.put(listener.name(), listener);
        if (listener.async()) {
            this.asyncTaskEventListeners.computeIfAbsent((TaskEvent)listener.event(), (Function<TaskEvent, List<TaskEventListener>>)((Function<TaskEvent, List>)a -> Lists.newArrayList())).add(this.enhanceListener(listener));
            return;
        }
        this.syncTaskEventListeners.computeIfAbsent((TaskEvent)listener.event(), (Function<TaskEvent, List<TaskEventListener>>)((Function<TaskEvent, List>)a -> Lists.newArrayList())).add(this.enhanceListener(listener));
    }

    private TaskEventListener enhanceListener(TaskEventListener taskEventListener) {
        EventLogStorage eventLogStorage = this.workflowDataAccessor.eventLogStorage();
        if (eventLogStorage == null) {
            return taskEventListener;
        }
        return new LogableTaskEventListener(taskEventListener, eventLogStorage);
    }

    @Override
    public List<TaskEventListener> asyncListeners(TaskEvent event) {
        return this.asyncTaskEventListeners.getOrDefault(event, TaskEventListener.EMPTY_LIST);
    }

    @Override
    public List<TaskEventListener> syncListeners(TaskEvent event) {
        return this.syncTaskEventListeners.getOrDefault(event, TaskEventListener.EMPTY_LIST);
    }

    @Override
    public TaskEventListener listener(String listenerName) {
        return this.taskEventListeners.get(listenerName);
    }

    @Override
    public EventLogStorage eventLogStorage() {
        return this.workflowDataAccessor.eventLogStorage();
    }
}

