/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.common.model;

import org.apache.inlong.manager.common.event.task.TaskEvent;
import org.apache.inlong.manager.common.exceptions.WorkflowException;

public enum Action {
    START("initiation process"),
    APPROVE("agree"),
    REJECT("reject"),
    CANCEL("withdrawal"),
    TRANSFER("Turn to do"),
    TERMINATE("abandoned"),
    COMPLETE("automatic completion");

    private final String displayName;

    private Action(String displayName) {
        this.displayName = displayName;
    }

    public static Action fromTaskEvent(TaskEvent taskEvent) {
        switch (taskEvent) {
            case CREATE: {
                return null;
            }
            case APPROVE: {
                return APPROVE;
            }
            case REJECT: {
                return REJECT;
            }
            case TRANSFER: {
                return TRANSFER;
            }
            case CANCEL: {
                return CANCEL;
            }
            case COMPLETE: 
            case FAIL: {
                return COMPLETE;
            }
            case TERMINATE: {
                return TERMINATE;
            }
        }
        throw new WorkflowException("unknown taskEvent " + taskEvent);
    }

    public String getDisplayName() {
        return this.displayName;
    }
}

