/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.common.model.definition;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.inlong.manager.common.model.Action;
import org.apache.inlong.manager.common.model.WorkflowContext;
import org.apache.inlong.manager.common.model.definition.ConditionNextElement;
import org.apache.inlong.manager.common.model.definition.Element;
import org.apache.inlong.manager.common.util.Preconditions;

public abstract class NextableElement
extends Element {
    public static final List<ConditionNextElement> EMPTY_NEXT = Lists.newArrayList();
    private Map<Action, List<ConditionNextElement>> actionToNextElementMap = Maps.newHashMap();

    public NextableElement addNext(Element element) {
        return this.addNext(this.defaultNextAction(), ConditionNextElement.TRUE, element);
    }

    public NextableElement addNext(Action action, Element element) {
        return this.addNext(action, ConditionNextElement.TRUE, element);
    }

    public NextableElement addNext(Predicate<WorkflowContext> condition, Element element) {
        return this.addNext(this.defaultNextAction(), condition, element);
    }

    public NextableElement addNext(Action action, Predicate<WorkflowContext> condition, Element next) {
        Preconditions.checkTrue(this.supportedActions().contains((Object)action), () -> "not support action " + (Object)((Object)action) + " ,action should in one of " + this.supportedActions());
        this.actionToNextElementMap.computeIfAbsent(action, ac -> Lists.newArrayList()).add(new ConditionNextElement().setCondition(condition).setElement(next));
        return this;
    }

    public List<Element> getNextList(WorkflowContext context) {
        return this.getNextList(this.defaultNextAction(), context);
    }

    public List<Element> getNextList(Action action, WorkflowContext context) {
        Preconditions.checkTrue(this.supportedActions().contains((Object)action), () -> "not support action " + (Object)((Object)action) + " ,action should in one of " + this.supportedActions());
        return this.actionToNextElementMap.getOrDefault((Object)action, EMPTY_NEXT).stream().filter(conditionNextElement -> conditionNextElement.getCondition().test(context)).map(ConditionNextElement::getElement).collect(Collectors.toList());
    }

    public abstract Action defaultNextAction();

    protected abstract Set<Action> supportedActions();

    @Override
    public void validate() {
        Preconditions.checkNotEmpty(this.actionToNextElementMap, () -> "next elements cannot be null " + this.getClass().getName());
    }

    public Map<Action, List<ConditionNextElement>> getActionToNextElementMap() {
        return this.actionToNextElementMap;
    }

    public NextableElement setActionToNextElementMap(Map<Action, List<ConditionNextElement>> actionToNextElementMap) {
        this.actionToNextElementMap = actionToNextElementMap;
        return this;
    }

    @Override
    public NextableElement clone() throws CloneNotSupportedException {
        NextableElement nextAbleElement = (NextableElement)super.clone();
        HashMap cloneActionToNextElementMap = Maps.newHashMap();
        this.actionToNextElementMap.forEach((k, v) -> cloneActionToNextElementMap.put(k, v.stream().map(ele -> {
            try {
                return (ConditionNextElement)ele.clone();
            }
            catch (CloneNotSupportedException e) {
                e.printStackTrace();
                return null;
            }
        }).collect(Collectors.toList())));
        nextAbleElement.setActionToNextElementMap(cloneActionToNextElementMap);
        return nextAbleElement;
    }
}

