/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.common.model.definition;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.inlong.manager.common.event.process.ProcessEvent;
import org.apache.inlong.manager.common.event.process.ProcessEventListener;
import org.apache.inlong.manager.common.exceptions.WorkflowException;
import org.apache.inlong.manager.common.exceptions.WorkflowListenerException;
import org.apache.inlong.manager.common.model.definition.Element;
import org.apache.inlong.manager.common.model.definition.EndEvent;
import org.apache.inlong.manager.common.model.definition.NextableElement;
import org.apache.inlong.manager.common.model.definition.ProcessDetailHandler;
import org.apache.inlong.manager.common.model.definition.ProcessForm;
import org.apache.inlong.manager.common.model.definition.StartEvent;
import org.apache.inlong.manager.common.model.definition.Task;
import org.apache.inlong.manager.common.util.Preconditions;

public class Process
extends Element {
    private String type;
    private StartEvent startEvent;
    private EndEvent endEvent;
    private Map<String, Task> nameToTaskMap = Maps.newHashMap();
    private Class<? extends ProcessForm> formClass;
    private ProcessDetailHandler processDetailHandler;
    private Boolean hidden = false;
    private Map<ProcessEvent, List<ProcessEventListener>> syncListeners = Maps.newHashMap();
    private Map<ProcessEvent, List<ProcessEventListener>> asyncListeners = Maps.newHashMap();
    private Map<String, ProcessEventListener> name2EventListenerMap = Maps.newHashMap();
    private int version;

    public Process addListener(ProcessEventListener listener) {
        if (this.name2EventListenerMap.containsKey(listener.name())) {
            throw new WorkflowListenerException("duplicate listener:" + listener.name());
        }
        this.name2EventListenerMap.put(listener.name(), listener);
        if (listener.async()) {
            this.asyncListeners.computeIfAbsent((ProcessEvent)listener.event(), (Function<ProcessEvent, List<ProcessEventListener>>)((Function<ProcessEvent, List>)a -> Lists.newArrayList())).add(listener);
        } else {
            this.syncListeners.computeIfAbsent((ProcessEvent)listener.event(), (Function<ProcessEvent, List<ProcessEventListener>>)((Function<ProcessEvent, List>)a -> Lists.newArrayList())).add(listener);
        }
        return this;
    }

    public List<ProcessEventListener> asyncListeners(ProcessEvent processEvent) {
        return this.asyncListeners.getOrDefault(processEvent, ProcessEventListener.EMPTY_LIST);
    }

    public List<ProcessEventListener> syncListeners(ProcessEvent processEvent) {
        return this.syncListeners.getOrDefault(processEvent, ProcessEventListener.EMPTY_LIST);
    }

    public ProcessEventListener listener(String listenerName) {
        return this.name2EventListenerMap.get(listenerName);
    }

    public Process addTask(Task task) {
        if (this.nameToTaskMap.containsKey(task.getName())) {
            throw new WorkflowException("task name cannot duplicate " + task.getName());
        }
        this.nameToTaskMap.put(task.getName(), task);
        return this;
    }

    public Task getTaskByName(String name) {
        if (!this.nameToTaskMap.containsKey(name)) {
            throw new WorkflowException("cannot find task with the name " + name);
        }
        return this.nameToTaskMap.get(name);
    }

    @Override
    public void validate() {
        super.validate();
        Preconditions.checkNotEmpty(this.type, "process type cannot be empty");
        Preconditions.checkNotNull((Object)this.startEvent, "start event cannot be null");
        Preconditions.checkNotNull((Object)this.endEvent, "end event cannot be null");
        this.startEvent.validate();
        this.endEvent.validate();
        this.nameToTaskMap.values().forEach(NextableElement::validate);
    }

    @Override
    public Process clone() throws CloneNotSupportedException {
        Process cloneProcess = (Process)super.clone();
        cloneProcess.setStartEvent((StartEvent)this.startEvent.clone());
        cloneProcess.setEndEvent((EndEvent)this.endEvent.clone());
        HashMap<String, Task> cloneMap = new HashMap<String, Task>();
        this.nameToTaskMap.forEach((k, v) -> {
            try {
                cloneMap.put((String)k, v.clone());
            }
            catch (CloneNotSupportedException e) {
                e.printStackTrace();
            }
        });
        cloneProcess.setNameToTaskMap(cloneMap);
        HashMap cloneSyncListener = Maps.newHashMap();
        HashMap cloneAsyncListeners = Maps.newHashMap();
        cloneSyncListener.putAll(this.syncListeners);
        cloneAsyncListeners.putAll(this.asyncListeners);
        return cloneProcess;
    }

    public String getType() {
        return this.type;
    }

    public StartEvent getStartEvent() {
        return this.startEvent;
    }

    public EndEvent getEndEvent() {
        return this.endEvent;
    }

    public Class<? extends ProcessForm> getFormClass() {
        return this.formClass;
    }

    public ProcessDetailHandler getProcessDetailHandler() {
        return this.processDetailHandler;
    }

    public Boolean getHidden() {
        return this.hidden;
    }

    public Map<ProcessEvent, List<ProcessEventListener>> getSyncListeners() {
        return this.syncListeners;
    }

    public Map<ProcessEvent, List<ProcessEventListener>> getAsyncListeners() {
        return this.asyncListeners;
    }

    public Map<String, ProcessEventListener> getName2EventListenerMap() {
        return this.name2EventListenerMap;
    }

    public int getVersion() {
        return this.version;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setStartEvent(StartEvent startEvent) {
        this.startEvent = startEvent;
    }

    public void setEndEvent(EndEvent endEvent) {
        this.endEvent = endEvent;
    }

    public void setNameToTaskMap(Map<String, Task> nameToTaskMap) {
        this.nameToTaskMap = nameToTaskMap;
    }

    public void setFormClass(Class<? extends ProcessForm> formClass) {
        this.formClass = formClass;
    }

    public void setProcessDetailHandler(ProcessDetailHandler processDetailHandler) {
        this.processDetailHandler = processDetailHandler;
    }

    public void setHidden(Boolean hidden) {
        this.hidden = hidden;
    }

    public void setSyncListeners(Map<ProcessEvent, List<ProcessEventListener>> syncListeners) {
        this.syncListeners = syncListeners;
    }

    public void setAsyncListeners(Map<ProcessEvent, List<ProcessEventListener>> asyncListeners) {
        this.asyncListeners = asyncListeners;
    }

    public void setName2EventListenerMap(Map<String, ProcessEventListener> name2EventListenerMap) {
        this.name2EventListenerMap = name2EventListenerMap;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Process)) {
            return false;
        }
        Process other = (Process)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getVersion() != other.getVersion()) {
            return false;
        }
        Boolean this$hidden = this.getHidden();
        Boolean other$hidden = other.getHidden();
        if (this$hidden == null ? other$hidden != null : !((Object)this$hidden).equals(other$hidden)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        StartEvent this$startEvent = this.getStartEvent();
        StartEvent other$startEvent = other.getStartEvent();
        if (this$startEvent == null ? other$startEvent != null : !((Object)this$startEvent).equals(other$startEvent)) {
            return false;
        }
        EndEvent this$endEvent = this.getEndEvent();
        EndEvent other$endEvent = other.getEndEvent();
        if (this$endEvent == null ? other$endEvent != null : !((Object)this$endEvent).equals(other$endEvent)) {
            return false;
        }
        Map<String, Task> this$nameToTaskMap = this.getNameToTaskMap();
        Map<String, Task> other$nameToTaskMap = other.getNameToTaskMap();
        if (this$nameToTaskMap == null ? other$nameToTaskMap != null : !((Object)this$nameToTaskMap).equals(other$nameToTaskMap)) {
            return false;
        }
        Class<? extends ProcessForm> this$formClass = this.getFormClass();
        Class<? extends ProcessForm> other$formClass = other.getFormClass();
        if (this$formClass == null ? other$formClass != null : !this$formClass.equals(other$formClass)) {
            return false;
        }
        ProcessDetailHandler this$processDetailHandler = this.getProcessDetailHandler();
        ProcessDetailHandler other$processDetailHandler = other.getProcessDetailHandler();
        if (this$processDetailHandler == null ? other$processDetailHandler != null : !this$processDetailHandler.equals(other$processDetailHandler)) {
            return false;
        }
        Map<ProcessEvent, List<ProcessEventListener>> this$syncListeners = this.getSyncListeners();
        Map<ProcessEvent, List<ProcessEventListener>> other$syncListeners = other.getSyncListeners();
        if (this$syncListeners == null ? other$syncListeners != null : !((Object)this$syncListeners).equals(other$syncListeners)) {
            return false;
        }
        Map<ProcessEvent, List<ProcessEventListener>> this$asyncListeners = this.getAsyncListeners();
        Map<ProcessEvent, List<ProcessEventListener>> other$asyncListeners = other.getAsyncListeners();
        if (this$asyncListeners == null ? other$asyncListeners != null : !((Object)this$asyncListeners).equals(other$asyncListeners)) {
            return false;
        }
        Map<String, ProcessEventListener> this$name2EventListenerMap = this.getName2EventListenerMap();
        Map<String, ProcessEventListener> other$name2EventListenerMap = other.getName2EventListenerMap();
        return !(this$name2EventListenerMap == null ? other$name2EventListenerMap != null : !((Object)this$name2EventListenerMap).equals(other$name2EventListenerMap));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof Process;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getVersion();
        Boolean $hidden = this.getHidden();
        result = result * 59 + ($hidden == null ? 43 : ((Object)$hidden).hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        StartEvent $startEvent = this.getStartEvent();
        result = result * 59 + ($startEvent == null ? 43 : ((Object)$startEvent).hashCode());
        EndEvent $endEvent = this.getEndEvent();
        result = result * 59 + ($endEvent == null ? 43 : ((Object)$endEvent).hashCode());
        Map<String, Task> $nameToTaskMap = this.getNameToTaskMap();
        result = result * 59 + ($nameToTaskMap == null ? 43 : ((Object)$nameToTaskMap).hashCode());
        Class<? extends ProcessForm> $formClass = this.getFormClass();
        result = result * 59 + ($formClass == null ? 43 : $formClass.hashCode());
        ProcessDetailHandler $processDetailHandler = this.getProcessDetailHandler();
        result = result * 59 + ($processDetailHandler == null ? 43 : $processDetailHandler.hashCode());
        Map<ProcessEvent, List<ProcessEventListener>> $syncListeners = this.getSyncListeners();
        result = result * 59 + ($syncListeners == null ? 43 : ((Object)$syncListeners).hashCode());
        Map<ProcessEvent, List<ProcessEventListener>> $asyncListeners = this.getAsyncListeners();
        result = result * 59 + ($asyncListeners == null ? 43 : ((Object)$asyncListeners).hashCode());
        Map<String, ProcessEventListener> $name2EventListenerMap = this.getName2EventListenerMap();
        result = result * 59 + ($name2EventListenerMap == null ? 43 : ((Object)$name2EventListenerMap).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "Process(type=" + this.getType() + ", startEvent=" + this.getStartEvent() + ", endEvent=" + this.getEndEvent() + ", nameToTaskMap=" + this.getNameToTaskMap() + ", formClass=" + this.getFormClass() + ", processDetailHandler=" + this.getProcessDetailHandler() + ", hidden=" + this.getHidden() + ", syncListeners=" + this.getSyncListeners() + ", asyncListeners=" + this.getAsyncListeners() + ", name2EventListenerMap=" + this.getName2EventListenerMap() + ", version=" + this.getVersion() + ")";
    }

    public Map<String, Task> getNameToTaskMap() {
        return this.nameToTaskMap;
    }
}

