/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.common.model.definition;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.inlong.manager.common.event.task.TaskEventListener;
import org.apache.inlong.manager.common.exceptions.WorkflowException;
import org.apache.inlong.manager.common.model.Action;
import org.apache.inlong.manager.common.model.WorkflowContext;
import org.apache.inlong.manager.common.model.definition.Element;
import org.apache.inlong.manager.common.model.definition.ServiceTaskListenerProvider;
import org.apache.inlong.manager.common.model.definition.ServiceTaskType;
import org.apache.inlong.manager.common.model.definition.Task;
import org.apache.inlong.manager.common.util.Preconditions;
import org.springframework.util.CollectionUtils;

public class ServiceTask
extends Task {
    private static final Set<Action> SUPPORTED_ACTIONS = ImmutableSet.of((Object)((Object)Action.COMPLETE), (Object)((Object)Action.CANCEL), (Object)((Object)Action.TERMINATE));
    private ServiceTaskListenerProvider listenerProvider;
    private ServiceTaskType serviceTaskType;

    @Override
    public Action defaultNextAction() {
        return Action.COMPLETE;
    }

    @Override
    protected Set<Action> supportedActions() {
        return SUPPORTED_ACTIONS;
    }

    @Override
    public List<Element> getNextList(Action action, WorkflowContext context) {
        Preconditions.checkTrue(this.supportedActions().contains((Object)action), () -> "not support action " + (Object)((Object)action) + " ,action should in one of " + this.supportedActions());
        switch (action) {
            case COMPLETE: {
                return super.getNextList(action, context);
            }
            case CANCEL: 
            case TERMINATE: {
                return Collections.singletonList(context.getProcess().getEndEvent());
            }
        }
        throw new WorkflowException("unknown action " + (Object)((Object)action));
    }

    public Task addListeners(List<TaskEventListener> listeners) {
        if (CollectionUtils.isEmpty(listeners)) {
            return this;
        }
        for (TaskEventListener listener : listeners) {
            if (listener == null) continue;
            this.addListener(listener);
        }
        return this;
    }

    public Task addListenerProvider(ServiceTaskListenerProvider provider) {
        this.listenerProvider = provider;
        return this;
    }

    public Task addServiceTaskType(ServiceTaskType type) {
        this.serviceTaskType = type;
        return this;
    }

    public void initListeners(WorkflowContext workflowContext) {
        if (this.listenerProvider == null || this.serviceTaskType == null) {
            return;
        }
        Iterable listeners = this.listenerProvider.get(workflowContext, this.serviceTaskType);
        this.addListeners(Lists.newArrayList(listeners));
    }
}

