/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.common.model.definition;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.apache.inlong.manager.common.event.task.TaskEvent;
import org.apache.inlong.manager.common.event.task.TaskEventListener;
import org.apache.inlong.manager.common.exceptions.WorkflowListenerException;
import org.apache.inlong.manager.common.model.WorkflowContext;
import org.apache.inlong.manager.common.model.definition.NextableElement;
import org.apache.inlong.manager.common.model.definition.SkipResolver;
import org.apache.inlong.manager.common.model.definition.SkippableElement;

public abstract class Task
extends NextableElement
implements SkippableElement {
    private boolean needAllApprove = false;
    private SkipResolver skipResolver = SkipResolver.DEFAULT_NOT_SKIP;
    private Map<TaskEvent, List<TaskEventListener>> syncListeners = Maps.newHashMap();
    private Map<TaskEvent, List<TaskEventListener>> asyncListeners = Maps.newHashMap();
    private Map<String, TaskEventListener> name2EventListenerMap = Maps.newHashMap();

    public Task addListener(TaskEventListener listener) {
        if (this.name2EventListenerMap.containsKey(listener.name())) {
            throw new WorkflowListenerException("duplicate listener:" + listener.name());
        }
        this.name2EventListenerMap.put(listener.name(), listener);
        if (listener.async()) {
            this.asyncListeners.computeIfAbsent((TaskEvent)listener.event(), (Function<TaskEvent, List<TaskEventListener>>)((Function<TaskEvent, List>)a -> Lists.newArrayList())).add(listener);
        } else {
            this.syncListeners.computeIfAbsent((TaskEvent)listener.event(), (Function<TaskEvent, List<TaskEventListener>>)((Function<TaskEvent, List>)a -> Lists.newArrayList())).add(listener);
        }
        return this;
    }

    public List<TaskEventListener> asyncListeners(TaskEvent taskEvent) {
        return this.asyncListeners.getOrDefault(taskEvent, TaskEventListener.EMPTY_LIST);
    }

    public List<TaskEventListener> syncListeners(TaskEvent taskEvent) {
        return this.syncListeners.getOrDefault(taskEvent, TaskEventListener.EMPTY_LIST);
    }

    public TaskEventListener listener(String listenerName) {
        return this.name2EventListenerMap.get(listenerName);
    }

    @Override
    public Task clone() throws CloneNotSupportedException {
        Task cloneTask = (Task)super.clone();
        cloneTask.setSyncListeners(new HashMap<TaskEvent, List<TaskEventListener>>(this.syncListeners));
        cloneTask.setAsyncListeners(new HashMap<TaskEvent, List<TaskEventListener>>(this.asyncListeners));
        return cloneTask;
    }

    @Override
    public boolean isSkip(WorkflowContext workflowContext) {
        return Optional.ofNullable(this.skipResolver).map(skipResolver -> skipResolver.isSkip(workflowContext)).orElse(false);
    }

    public boolean isNeedAllApprove() {
        return this.needAllApprove;
    }

    public SkipResolver getSkipResolver() {
        return this.skipResolver;
    }

    public Map<TaskEvent, List<TaskEventListener>> getSyncListeners() {
        return this.syncListeners;
    }

    public Map<TaskEvent, List<TaskEventListener>> getAsyncListeners() {
        return this.asyncListeners;
    }

    public Map<String, TaskEventListener> getName2EventListenerMap() {
        return this.name2EventListenerMap;
    }

    public void setNeedAllApprove(boolean needAllApprove) {
        this.needAllApprove = needAllApprove;
    }

    public void setSkipResolver(SkipResolver skipResolver) {
        this.skipResolver = skipResolver;
    }

    public void setSyncListeners(Map<TaskEvent, List<TaskEventListener>> syncListeners) {
        this.syncListeners = syncListeners;
    }

    public void setAsyncListeners(Map<TaskEvent, List<TaskEventListener>> asyncListeners) {
        this.asyncListeners = asyncListeners;
    }

    public void setName2EventListenerMap(Map<String, TaskEventListener> name2EventListenerMap) {
        this.name2EventListenerMap = name2EventListenerMap;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Task)) {
            return false;
        }
        Task other = (Task)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isNeedAllApprove() != other.isNeedAllApprove()) {
            return false;
        }
        SkipResolver this$skipResolver = this.getSkipResolver();
        SkipResolver other$skipResolver = other.getSkipResolver();
        if (this$skipResolver == null ? other$skipResolver != null : !this$skipResolver.equals(other$skipResolver)) {
            return false;
        }
        Map<TaskEvent, List<TaskEventListener>> this$syncListeners = this.getSyncListeners();
        Map<TaskEvent, List<TaskEventListener>> other$syncListeners = other.getSyncListeners();
        if (this$syncListeners == null ? other$syncListeners != null : !((Object)this$syncListeners).equals(other$syncListeners)) {
            return false;
        }
        Map<TaskEvent, List<TaskEventListener>> this$asyncListeners = this.getAsyncListeners();
        Map<TaskEvent, List<TaskEventListener>> other$asyncListeners = other.getAsyncListeners();
        if (this$asyncListeners == null ? other$asyncListeners != null : !((Object)this$asyncListeners).equals(other$asyncListeners)) {
            return false;
        }
        Map<String, TaskEventListener> this$name2EventListenerMap = this.getName2EventListenerMap();
        Map<String, TaskEventListener> other$name2EventListenerMap = other.getName2EventListenerMap();
        return !(this$name2EventListenerMap == null ? other$name2EventListenerMap != null : !((Object)this$name2EventListenerMap).equals(other$name2EventListenerMap));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof Task;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isNeedAllApprove() ? 79 : 97);
        SkipResolver $skipResolver = this.getSkipResolver();
        result = result * 59 + ($skipResolver == null ? 43 : $skipResolver.hashCode());
        Map<TaskEvent, List<TaskEventListener>> $syncListeners = this.getSyncListeners();
        result = result * 59 + ($syncListeners == null ? 43 : ((Object)$syncListeners).hashCode());
        Map<TaskEvent, List<TaskEventListener>> $asyncListeners = this.getAsyncListeners();
        result = result * 59 + ($asyncListeners == null ? 43 : ((Object)$asyncListeners).hashCode());
        Map<String, TaskEventListener> $name2EventListenerMap = this.getName2EventListenerMap();
        result = result * 59 + ($name2EventListenerMap == null ? 43 : ((Object)$name2EventListenerMap).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "Task(needAllApprove=" + this.isNeedAllApprove() + ", skipResolver=" + this.getSkipResolver() + ", syncListeners=" + this.getSyncListeners() + ", asyncListeners=" + this.getAsyncListeners() + ", name2EventListenerMap=" + this.getName2EventListenerMap() + ")";
    }
}

