/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.common.model.definition;

import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.inlong.manager.common.exceptions.WorkflowException;
import org.apache.inlong.manager.common.model.Action;
import org.apache.inlong.manager.common.model.WorkflowContext;
import org.apache.inlong.manager.common.model.definition.ApproverAssign;
import org.apache.inlong.manager.common.model.definition.Element;
import org.apache.inlong.manager.common.model.definition.Task;
import org.apache.inlong.manager.common.model.definition.TaskForm;
import org.apache.inlong.manager.common.util.Preconditions;

public class UserTask
extends Task {
    private static final Set<Action> SUPPORTED_ACTIONS = ImmutableSet.of((Object)((Object)Action.APPROVE), (Object)((Object)Action.REJECT), (Object)((Object)Action.TRANSFER), (Object)((Object)Action.TERMINATE), (Object)((Object)Action.CANCEL));
    private ApproverAssign approverAssign;
    private Class<? extends TaskForm> formClass;

    @Override
    public Action defaultNextAction() {
        return Action.APPROVE;
    }

    @Override
    protected Set<Action> supportedActions() {
        return SUPPORTED_ACTIONS;
    }

    @Override
    public List<Element> getNextList(Action action, WorkflowContext context) {
        Preconditions.checkTrue(this.supportedActions().contains((Object)action), () -> "not support action " + (Object)((Object)action) + " ,action should in one of " + this.supportedActions());
        switch (action) {
            case APPROVE: {
                return super.getNextList(action, context);
            }
            case REJECT: 
            case CANCEL: 
            case TERMINATE: {
                return Collections.singletonList(context.getProcess().getEndEvent());
            }
            case TRANSFER: {
                List<String> transferToUsers = context.getActionContext().getTransferToUsers();
                this.setApproverAssign(c -> transferToUsers);
                return Collections.singletonList(this);
            }
        }
        throw new WorkflowException("unknown action " + (Object)((Object)action));
    }

    public ApproverAssign getApproverAssign() {
        return this.approverAssign;
    }

    public Class<? extends TaskForm> getFormClass() {
        return this.formClass;
    }

    public void setApproverAssign(ApproverAssign approverAssign) {
        this.approverAssign = approverAssign;
    }

    public void setFormClass(Class<? extends TaskForm> formClass) {
        this.formClass = formClass;
    }

    @Override
    public String toString() {
        return "UserTask(approverAssign=" + this.getApproverAssign() + ", formClass=" + this.getFormClass() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UserTask)) {
            return false;
        }
        UserTask other = (UserTask)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ApproverAssign this$approverAssign = this.getApproverAssign();
        ApproverAssign other$approverAssign = other.getApproverAssign();
        if (this$approverAssign == null ? other$approverAssign != null : !this$approverAssign.equals(other$approverAssign)) {
            return false;
        }
        Class<? extends TaskForm> this$formClass = this.getFormClass();
        Class<? extends TaskForm> other$formClass = other.getFormClass();
        return !(this$formClass == null ? other$formClass != null : !this$formClass.equals(other$formClass));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof UserTask;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        ApproverAssign $approverAssign = this.getApproverAssign();
        result = result * 59 + ($approverAssign == null ? 43 : $approverAssign.hashCode());
        Class<? extends TaskForm> $formClass = this.getFormClass();
        result = result * 59 + ($formClass == null ? 43 : $formClass.hashCode());
        return result;
    }
}

