/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.common.pojo.business;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Date;
import java.util.List;
import javax.validation.constraints.NotNull;
import org.apache.inlong.manager.common.pojo.business.BusinessExtInfo;
import org.apache.inlong.manager.common.pojo.business.BusinessMqExtBase;

@ApiModel(value="Business access info")
public class BusinessInfo {
    @ApiModelProperty(value="Primary key")
    private Integer id;
    @ApiModelProperty(value="Business group id", required=true)
    private String inlongGroupId;
    @ApiModelProperty(value="Business name", required=true)
    private String name;
    @ApiModelProperty(value="Chinese display name")
    private String cnName;
    @ApiModelProperty(value="Business description")
    private String description;
    @NotNull(message="middlewareType cannot be null")
    @ApiModelProperty(value="Middleware type, high throughput: TUBE, high consistency: PULSAR")
    private @NotNull(message="middlewareType cannot be null") String middlewareType;
    @ApiModelProperty(value="Queue model of Pulsar, parallel: multiple partitions, high throughput, out-of-order messages; serial: single partition, low throughput, and orderly messages")
    private String queueModule = "parallel";
    @ApiModelProperty(value="The number of partitions of Pulsar Topic, 1-20")
    private Integer topicPartitionNum = 3;
    @ApiModelProperty(value="MQ resource object, in business", notes="Tube corresponds to Topic, Pulsar corresponds to Namespace")
    private String mqResourceObj;
    @ApiModelProperty(value="Tube master URL")
    private String tubeMaster;
    @ApiModelProperty(value="Pulsar admin URL")
    private String pulsarAdminUrl;
    @ApiModelProperty(value="Pulsar service URL")
    private String pulsarServiceUrl;
    @ApiModelProperty(value="Data type name")
    private String schemaName;
    @ApiModelProperty(value="Number of access items per day, unit: 10,000 items per day")
    private Integer dailyRecords;
    @ApiModelProperty(value="Access size per day, unit: GB per day")
    private Integer dailyStorage;
    @ApiModelProperty(value="peak access per second, unit: bars per second")
    private Integer peakRecords;
    @ApiModelProperty(value="The maximum length of a single piece of data, unit: Byte")
    private Integer maxLength;
    @ApiModelProperty(value="Name of responsible person, separated by commas")
    private String inCharges;
    @ApiModelProperty(value="A list of names of business followers, separated by commas")
    private String followers;
    private Integer status;
    @ApiModelProperty(value="is deleted? 0: deleted, 1: not deleted")
    private Integer isDeleted = 0;
    private String creator;
    private String modifier;
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss")
    private Date createTime;
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss")
    private Date modifyTime;
    @ApiModelProperty(value="Temporary view, string in JSON format")
    private String tempView;
    @ApiModelProperty(value="Business Extension Properties")
    private List<BusinessExtInfo> extList;
    @ApiModelProperty(value="The extension info for MQ")
    private BusinessMqExtBase mqExtInfo;

    public static BusinessInfoBuilder builder() {
        return new BusinessInfoBuilder();
    }

    public Integer getId() {
        return this.id;
    }

    public String getInlongGroupId() {
        return this.inlongGroupId;
    }

    public String getName() {
        return this.name;
    }

    public String getCnName() {
        return this.cnName;
    }

    public String getDescription() {
        return this.description;
    }

    public String getMiddlewareType() {
        return this.middlewareType;
    }

    public String getQueueModule() {
        return this.queueModule;
    }

    public Integer getTopicPartitionNum() {
        return this.topicPartitionNum;
    }

    public String getMqResourceObj() {
        return this.mqResourceObj;
    }

    public String getTubeMaster() {
        return this.tubeMaster;
    }

    public String getPulsarAdminUrl() {
        return this.pulsarAdminUrl;
    }

    public String getPulsarServiceUrl() {
        return this.pulsarServiceUrl;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public Integer getDailyRecords() {
        return this.dailyRecords;
    }

    public Integer getDailyStorage() {
        return this.dailyStorage;
    }

    public Integer getPeakRecords() {
        return this.peakRecords;
    }

    public Integer getMaxLength() {
        return this.maxLength;
    }

    public String getInCharges() {
        return this.inCharges;
    }

    public String getFollowers() {
        return this.followers;
    }

    public Integer getStatus() {
        return this.status;
    }

    public Integer getIsDeleted() {
        return this.isDeleted;
    }

    public String getCreator() {
        return this.creator;
    }

    public String getModifier() {
        return this.modifier;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public Date getModifyTime() {
        return this.modifyTime;
    }

    public String getTempView() {
        return this.tempView;
    }

    public List<BusinessExtInfo> getExtList() {
        return this.extList;
    }

    public BusinessMqExtBase getMqExtInfo() {
        return this.mqExtInfo;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public void setInlongGroupId(String inlongGroupId) {
        this.inlongGroupId = inlongGroupId;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setCnName(String cnName) {
        this.cnName = cnName;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setMiddlewareType(String middlewareType) {
        this.middlewareType = middlewareType;
    }

    public void setQueueModule(String queueModule) {
        this.queueModule = queueModule;
    }

    public void setTopicPartitionNum(Integer topicPartitionNum) {
        this.topicPartitionNum = topicPartitionNum;
    }

    public void setMqResourceObj(String mqResourceObj) {
        this.mqResourceObj = mqResourceObj;
    }

    public void setTubeMaster(String tubeMaster) {
        this.tubeMaster = tubeMaster;
    }

    public void setPulsarAdminUrl(String pulsarAdminUrl) {
        this.pulsarAdminUrl = pulsarAdminUrl;
    }

    public void setPulsarServiceUrl(String pulsarServiceUrl) {
        this.pulsarServiceUrl = pulsarServiceUrl;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    public void setDailyRecords(Integer dailyRecords) {
        this.dailyRecords = dailyRecords;
    }

    public void setDailyStorage(Integer dailyStorage) {
        this.dailyStorage = dailyStorage;
    }

    public void setPeakRecords(Integer peakRecords) {
        this.peakRecords = peakRecords;
    }

    public void setMaxLength(Integer maxLength) {
        this.maxLength = maxLength;
    }

    public void setInCharges(String inCharges) {
        this.inCharges = inCharges;
    }

    public void setFollowers(String followers) {
        this.followers = followers;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public void setIsDeleted(Integer isDeleted) {
        this.isDeleted = isDeleted;
    }

    public void setCreator(String creator) {
        this.creator = creator;
    }

    public void setModifier(String modifier) {
        this.modifier = modifier;
    }

    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss")
    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss")
    public void setModifyTime(Date modifyTime) {
        this.modifyTime = modifyTime;
    }

    public void setTempView(String tempView) {
        this.tempView = tempView;
    }

    public void setExtList(List<BusinessExtInfo> extList) {
        this.extList = extList;
    }

    public void setMqExtInfo(BusinessMqExtBase mqExtInfo) {
        this.mqExtInfo = mqExtInfo;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BusinessInfo)) {
            return false;
        }
        BusinessInfo other = (BusinessInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$id = this.getId();
        Integer other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Integer this$topicPartitionNum = this.getTopicPartitionNum();
        Integer other$topicPartitionNum = other.getTopicPartitionNum();
        if (this$topicPartitionNum == null ? other$topicPartitionNum != null : !((Object)this$topicPartitionNum).equals(other$topicPartitionNum)) {
            return false;
        }
        Integer this$dailyRecords = this.getDailyRecords();
        Integer other$dailyRecords = other.getDailyRecords();
        if (this$dailyRecords == null ? other$dailyRecords != null : !((Object)this$dailyRecords).equals(other$dailyRecords)) {
            return false;
        }
        Integer this$dailyStorage = this.getDailyStorage();
        Integer other$dailyStorage = other.getDailyStorage();
        if (this$dailyStorage == null ? other$dailyStorage != null : !((Object)this$dailyStorage).equals(other$dailyStorage)) {
            return false;
        }
        Integer this$peakRecords = this.getPeakRecords();
        Integer other$peakRecords = other.getPeakRecords();
        if (this$peakRecords == null ? other$peakRecords != null : !((Object)this$peakRecords).equals(other$peakRecords)) {
            return false;
        }
        Integer this$maxLength = this.getMaxLength();
        Integer other$maxLength = other.getMaxLength();
        if (this$maxLength == null ? other$maxLength != null : !((Object)this$maxLength).equals(other$maxLength)) {
            return false;
        }
        Integer this$status = this.getStatus();
        Integer other$status = other.getStatus();
        if (this$status == null ? other$status != null : !((Object)this$status).equals(other$status)) {
            return false;
        }
        Integer this$isDeleted = this.getIsDeleted();
        Integer other$isDeleted = other.getIsDeleted();
        if (this$isDeleted == null ? other$isDeleted != null : !((Object)this$isDeleted).equals(other$isDeleted)) {
            return false;
        }
        String this$inlongGroupId = this.getInlongGroupId();
        String other$inlongGroupId = other.getInlongGroupId();
        if (this$inlongGroupId == null ? other$inlongGroupId != null : !this$inlongGroupId.equals(other$inlongGroupId)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$cnName = this.getCnName();
        String other$cnName = other.getCnName();
        if (this$cnName == null ? other$cnName != null : !this$cnName.equals(other$cnName)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$middlewareType = this.getMiddlewareType();
        String other$middlewareType = other.getMiddlewareType();
        if (this$middlewareType == null ? other$middlewareType != null : !this$middlewareType.equals(other$middlewareType)) {
            return false;
        }
        String this$queueModule = this.getQueueModule();
        String other$queueModule = other.getQueueModule();
        if (this$queueModule == null ? other$queueModule != null : !this$queueModule.equals(other$queueModule)) {
            return false;
        }
        String this$mqResourceObj = this.getMqResourceObj();
        String other$mqResourceObj = other.getMqResourceObj();
        if (this$mqResourceObj == null ? other$mqResourceObj != null : !this$mqResourceObj.equals(other$mqResourceObj)) {
            return false;
        }
        String this$tubeMaster = this.getTubeMaster();
        String other$tubeMaster = other.getTubeMaster();
        if (this$tubeMaster == null ? other$tubeMaster != null : !this$tubeMaster.equals(other$tubeMaster)) {
            return false;
        }
        String this$pulsarAdminUrl = this.getPulsarAdminUrl();
        String other$pulsarAdminUrl = other.getPulsarAdminUrl();
        if (this$pulsarAdminUrl == null ? other$pulsarAdminUrl != null : !this$pulsarAdminUrl.equals(other$pulsarAdminUrl)) {
            return false;
        }
        String this$pulsarServiceUrl = this.getPulsarServiceUrl();
        String other$pulsarServiceUrl = other.getPulsarServiceUrl();
        if (this$pulsarServiceUrl == null ? other$pulsarServiceUrl != null : !this$pulsarServiceUrl.equals(other$pulsarServiceUrl)) {
            return false;
        }
        String this$schemaName = this.getSchemaName();
        String other$schemaName = other.getSchemaName();
        if (this$schemaName == null ? other$schemaName != null : !this$schemaName.equals(other$schemaName)) {
            return false;
        }
        String this$inCharges = this.getInCharges();
        String other$inCharges = other.getInCharges();
        if (this$inCharges == null ? other$inCharges != null : !this$inCharges.equals(other$inCharges)) {
            return false;
        }
        String this$followers = this.getFollowers();
        String other$followers = other.getFollowers();
        if (this$followers == null ? other$followers != null : !this$followers.equals(other$followers)) {
            return false;
        }
        String this$creator = this.getCreator();
        String other$creator = other.getCreator();
        if (this$creator == null ? other$creator != null : !this$creator.equals(other$creator)) {
            return false;
        }
        String this$modifier = this.getModifier();
        String other$modifier = other.getModifier();
        if (this$modifier == null ? other$modifier != null : !this$modifier.equals(other$modifier)) {
            return false;
        }
        Date this$createTime = this.getCreateTime();
        Date other$createTime = other.getCreateTime();
        if (this$createTime == null ? other$createTime != null : !((Object)this$createTime).equals(other$createTime)) {
            return false;
        }
        Date this$modifyTime = this.getModifyTime();
        Date other$modifyTime = other.getModifyTime();
        if (this$modifyTime == null ? other$modifyTime != null : !((Object)this$modifyTime).equals(other$modifyTime)) {
            return false;
        }
        String this$tempView = this.getTempView();
        String other$tempView = other.getTempView();
        if (this$tempView == null ? other$tempView != null : !this$tempView.equals(other$tempView)) {
            return false;
        }
        List<BusinessExtInfo> this$extList = this.getExtList();
        List<BusinessExtInfo> other$extList = other.getExtList();
        if (this$extList == null ? other$extList != null : !((Object)this$extList).equals(other$extList)) {
            return false;
        }
        BusinessMqExtBase this$mqExtInfo = this.getMqExtInfo();
        BusinessMqExtBase other$mqExtInfo = other.getMqExtInfo();
        return !(this$mqExtInfo == null ? other$mqExtInfo != null : !((Object)this$mqExtInfo).equals(other$mqExtInfo));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BusinessInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Integer $topicPartitionNum = this.getTopicPartitionNum();
        result = result * 59 + ($topicPartitionNum == null ? 43 : ((Object)$topicPartitionNum).hashCode());
        Integer $dailyRecords = this.getDailyRecords();
        result = result * 59 + ($dailyRecords == null ? 43 : ((Object)$dailyRecords).hashCode());
        Integer $dailyStorage = this.getDailyStorage();
        result = result * 59 + ($dailyStorage == null ? 43 : ((Object)$dailyStorage).hashCode());
        Integer $peakRecords = this.getPeakRecords();
        result = result * 59 + ($peakRecords == null ? 43 : ((Object)$peakRecords).hashCode());
        Integer $maxLength = this.getMaxLength();
        result = result * 59 + ($maxLength == null ? 43 : ((Object)$maxLength).hashCode());
        Integer $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : ((Object)$status).hashCode());
        Integer $isDeleted = this.getIsDeleted();
        result = result * 59 + ($isDeleted == null ? 43 : ((Object)$isDeleted).hashCode());
        String $inlongGroupId = this.getInlongGroupId();
        result = result * 59 + ($inlongGroupId == null ? 43 : $inlongGroupId.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $cnName = this.getCnName();
        result = result * 59 + ($cnName == null ? 43 : $cnName.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $middlewareType = this.getMiddlewareType();
        result = result * 59 + ($middlewareType == null ? 43 : $middlewareType.hashCode());
        String $queueModule = this.getQueueModule();
        result = result * 59 + ($queueModule == null ? 43 : $queueModule.hashCode());
        String $mqResourceObj = this.getMqResourceObj();
        result = result * 59 + ($mqResourceObj == null ? 43 : $mqResourceObj.hashCode());
        String $tubeMaster = this.getTubeMaster();
        result = result * 59 + ($tubeMaster == null ? 43 : $tubeMaster.hashCode());
        String $pulsarAdminUrl = this.getPulsarAdminUrl();
        result = result * 59 + ($pulsarAdminUrl == null ? 43 : $pulsarAdminUrl.hashCode());
        String $pulsarServiceUrl = this.getPulsarServiceUrl();
        result = result * 59 + ($pulsarServiceUrl == null ? 43 : $pulsarServiceUrl.hashCode());
        String $schemaName = this.getSchemaName();
        result = result * 59 + ($schemaName == null ? 43 : $schemaName.hashCode());
        String $inCharges = this.getInCharges();
        result = result * 59 + ($inCharges == null ? 43 : $inCharges.hashCode());
        String $followers = this.getFollowers();
        result = result * 59 + ($followers == null ? 43 : $followers.hashCode());
        String $creator = this.getCreator();
        result = result * 59 + ($creator == null ? 43 : $creator.hashCode());
        String $modifier = this.getModifier();
        result = result * 59 + ($modifier == null ? 43 : $modifier.hashCode());
        Date $createTime = this.getCreateTime();
        result = result * 59 + ($createTime == null ? 43 : ((Object)$createTime).hashCode());
        Date $modifyTime = this.getModifyTime();
        result = result * 59 + ($modifyTime == null ? 43 : ((Object)$modifyTime).hashCode());
        String $tempView = this.getTempView();
        result = result * 59 + ($tempView == null ? 43 : $tempView.hashCode());
        List<BusinessExtInfo> $extList = this.getExtList();
        result = result * 59 + ($extList == null ? 43 : ((Object)$extList).hashCode());
        BusinessMqExtBase $mqExtInfo = this.getMqExtInfo();
        result = result * 59 + ($mqExtInfo == null ? 43 : ((Object)$mqExtInfo).hashCode());
        return result;
    }

    public String toString() {
        return "BusinessInfo(id=" + this.getId() + ", inlongGroupId=" + this.getInlongGroupId() + ", name=" + this.getName() + ", cnName=" + this.getCnName() + ", description=" + this.getDescription() + ", middlewareType=" + this.getMiddlewareType() + ", queueModule=" + this.getQueueModule() + ", topicPartitionNum=" + this.getTopicPartitionNum() + ", mqResourceObj=" + this.getMqResourceObj() + ", tubeMaster=" + this.getTubeMaster() + ", pulsarAdminUrl=" + this.getPulsarAdminUrl() + ", pulsarServiceUrl=" + this.getPulsarServiceUrl() + ", schemaName=" + this.getSchemaName() + ", dailyRecords=" + this.getDailyRecords() + ", dailyStorage=" + this.getDailyStorage() + ", peakRecords=" + this.getPeakRecords() + ", maxLength=" + this.getMaxLength() + ", inCharges=" + this.getInCharges() + ", followers=" + this.getFollowers() + ", status=" + this.getStatus() + ", isDeleted=" + this.getIsDeleted() + ", creator=" + this.getCreator() + ", modifier=" + this.getModifier() + ", createTime=" + this.getCreateTime() + ", modifyTime=" + this.getModifyTime() + ", tempView=" + this.getTempView() + ", extList=" + this.getExtList() + ", mqExtInfo=" + this.getMqExtInfo() + ")";
    }

    public BusinessInfo() {
    }

    public BusinessInfo(Integer id, String inlongGroupId, String name, String cnName, String description, String middlewareType, String queueModule, Integer topicPartitionNum, String mqResourceObj, String tubeMaster, String pulsarAdminUrl, String pulsarServiceUrl, String schemaName, Integer dailyRecords, Integer dailyStorage, Integer peakRecords, Integer maxLength, String inCharges, String followers, Integer status, Integer isDeleted, String creator, String modifier, Date createTime, Date modifyTime, String tempView, List<BusinessExtInfo> extList, BusinessMqExtBase mqExtInfo) {
        this.id = id;
        this.inlongGroupId = inlongGroupId;
        this.name = name;
        this.cnName = cnName;
        this.description = description;
        this.middlewareType = middlewareType;
        this.queueModule = queueModule;
        this.topicPartitionNum = topicPartitionNum;
        this.mqResourceObj = mqResourceObj;
        this.tubeMaster = tubeMaster;
        this.pulsarAdminUrl = pulsarAdminUrl;
        this.pulsarServiceUrl = pulsarServiceUrl;
        this.schemaName = schemaName;
        this.dailyRecords = dailyRecords;
        this.dailyStorage = dailyStorage;
        this.peakRecords = peakRecords;
        this.maxLength = maxLength;
        this.inCharges = inCharges;
        this.followers = followers;
        this.status = status;
        this.isDeleted = isDeleted;
        this.creator = creator;
        this.modifier = modifier;
        this.createTime = createTime;
        this.modifyTime = modifyTime;
        this.tempView = tempView;
        this.extList = extList;
        this.mqExtInfo = mqExtInfo;
    }

    public static class BusinessInfoBuilder {
        private Integer id;
        private String inlongGroupId;
        private String name;
        private String cnName;
        private String description;
        private String middlewareType;
        private String queueModule;
        private Integer topicPartitionNum;
        private String mqResourceObj;
        private String tubeMaster;
        private String pulsarAdminUrl;
        private String pulsarServiceUrl;
        private String schemaName;
        private Integer dailyRecords;
        private Integer dailyStorage;
        private Integer peakRecords;
        private Integer maxLength;
        private String inCharges;
        private String followers;
        private Integer status;
        private Integer isDeleted;
        private String creator;
        private String modifier;
        private Date createTime;
        private Date modifyTime;
        private String tempView;
        private List<BusinessExtInfo> extList;
        private BusinessMqExtBase mqExtInfo;

        BusinessInfoBuilder() {
        }

        public BusinessInfoBuilder id(Integer id) {
            this.id = id;
            return this;
        }

        public BusinessInfoBuilder inlongGroupId(String inlongGroupId) {
            this.inlongGroupId = inlongGroupId;
            return this;
        }

        public BusinessInfoBuilder name(String name) {
            this.name = name;
            return this;
        }

        public BusinessInfoBuilder cnName(String cnName) {
            this.cnName = cnName;
            return this;
        }

        public BusinessInfoBuilder description(String description) {
            this.description = description;
            return this;
        }

        public BusinessInfoBuilder middlewareType(String middlewareType) {
            this.middlewareType = middlewareType;
            return this;
        }

        public BusinessInfoBuilder queueModule(String queueModule) {
            this.queueModule = queueModule;
            return this;
        }

        public BusinessInfoBuilder topicPartitionNum(Integer topicPartitionNum) {
            this.topicPartitionNum = topicPartitionNum;
            return this;
        }

        public BusinessInfoBuilder mqResourceObj(String mqResourceObj) {
            this.mqResourceObj = mqResourceObj;
            return this;
        }

        public BusinessInfoBuilder tubeMaster(String tubeMaster) {
            this.tubeMaster = tubeMaster;
            return this;
        }

        public BusinessInfoBuilder pulsarAdminUrl(String pulsarAdminUrl) {
            this.pulsarAdminUrl = pulsarAdminUrl;
            return this;
        }

        public BusinessInfoBuilder pulsarServiceUrl(String pulsarServiceUrl) {
            this.pulsarServiceUrl = pulsarServiceUrl;
            return this;
        }

        public BusinessInfoBuilder schemaName(String schemaName) {
            this.schemaName = schemaName;
            return this;
        }

        public BusinessInfoBuilder dailyRecords(Integer dailyRecords) {
            this.dailyRecords = dailyRecords;
            return this;
        }

        public BusinessInfoBuilder dailyStorage(Integer dailyStorage) {
            this.dailyStorage = dailyStorage;
            return this;
        }

        public BusinessInfoBuilder peakRecords(Integer peakRecords) {
            this.peakRecords = peakRecords;
            return this;
        }

        public BusinessInfoBuilder maxLength(Integer maxLength) {
            this.maxLength = maxLength;
            return this;
        }

        public BusinessInfoBuilder inCharges(String inCharges) {
            this.inCharges = inCharges;
            return this;
        }

        public BusinessInfoBuilder followers(String followers) {
            this.followers = followers;
            return this;
        }

        public BusinessInfoBuilder status(Integer status) {
            this.status = status;
            return this;
        }

        public BusinessInfoBuilder isDeleted(Integer isDeleted) {
            this.isDeleted = isDeleted;
            return this;
        }

        public BusinessInfoBuilder creator(String creator) {
            this.creator = creator;
            return this;
        }

        public BusinessInfoBuilder modifier(String modifier) {
            this.modifier = modifier;
            return this;
        }

        @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss")
        public BusinessInfoBuilder createTime(Date createTime) {
            this.createTime = createTime;
            return this;
        }

        @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss")
        public BusinessInfoBuilder modifyTime(Date modifyTime) {
            this.modifyTime = modifyTime;
            return this;
        }

        public BusinessInfoBuilder tempView(String tempView) {
            this.tempView = tempView;
            return this;
        }

        public BusinessInfoBuilder extList(List<BusinessExtInfo> extList) {
            this.extList = extList;
            return this;
        }

        public BusinessInfoBuilder mqExtInfo(BusinessMqExtBase mqExtInfo) {
            this.mqExtInfo = mqExtInfo;
            return this;
        }

        public BusinessInfo build() {
            return new BusinessInfo(this.id, this.inlongGroupId, this.name, this.cnName, this.description, this.middlewareType, this.queueModule, this.topicPartitionNum, this.mqResourceObj, this.tubeMaster, this.pulsarAdminUrl, this.pulsarServiceUrl, this.schemaName, this.dailyRecords, this.dailyStorage, this.peakRecords, this.maxLength, this.inCharges, this.followers, this.status, this.isDeleted, this.creator, this.modifier, this.createTime, this.modifyTime, this.tempView, this.extList, this.mqExtInfo);
        }

        public String toString() {
            return "BusinessInfo.BusinessInfoBuilder(id=" + this.id + ", inlongGroupId=" + this.inlongGroupId + ", name=" + this.name + ", cnName=" + this.cnName + ", description=" + this.description + ", middlewareType=" + this.middlewareType + ", queueModule=" + this.queueModule + ", topicPartitionNum=" + this.topicPartitionNum + ", mqResourceObj=" + this.mqResourceObj + ", tubeMaster=" + this.tubeMaster + ", pulsarAdminUrl=" + this.pulsarAdminUrl + ", pulsarServiceUrl=" + this.pulsarServiceUrl + ", schemaName=" + this.schemaName + ", dailyRecords=" + this.dailyRecords + ", dailyStorage=" + this.dailyStorage + ", peakRecords=" + this.peakRecords + ", maxLength=" + this.maxLength + ", inCharges=" + this.inCharges + ", followers=" + this.followers + ", status=" + this.status + ", isDeleted=" + this.isDeleted + ", creator=" + this.creator + ", modifier=" + this.modifier + ", createTime=" + this.createTime + ", modifyTime=" + this.modifyTime + ", tempView=" + this.tempView + ", extList=" + this.extList + ", mqExtInfo=" + this.mqExtInfo + ")";
        }
    }
}

