/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.common.enums;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import io.swagger.annotations.ApiModel;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.apache.inlong.manager.common.util.InLongCollectionUtils;
import org.apache.inlong.manager.common.util.Preconditions;

@ApiModel(value="Data consumption status")
public enum ConsumptionStatus {
    WAIT_ASSIGN(10),
    WAIT_APPROVE(11),
    REJECTED(20),
    APPROVED(21),
    CANCELED(22);

    public static final Set<ConsumptionStatus> ALLOW_SAVE_UPDATE_STATUS;
    public static final Set<ConsumptionStatus> ALLOW_START_WORKFLOW_STATUS;
    private static final Map<Integer, ConsumptionStatus> STATUS_MAP;
    private final int status;

    private ConsumptionStatus(int status) {
        this.status = status;
    }

    public static ConsumptionStatus fromStatus(int status) {
        ConsumptionStatus consumptionStatus = STATUS_MAP.get(status);
        Preconditions.checkNotNull((Object)consumptionStatus, "status is unavailable :" + status);
        return consumptionStatus;
    }

    public int getStatus() {
        return this.status;
    }

    static {
        ALLOW_SAVE_UPDATE_STATUS = ImmutableSet.of((Object)((Object)WAIT_ASSIGN), (Object)((Object)REJECTED), (Object)((Object)CANCELED));
        ALLOW_START_WORKFLOW_STATUS = ImmutableSet.of((Object)((Object)WAIT_ASSIGN));
        STATUS_MAP = InLongCollectionUtils.transformToImmutableMap(Lists.newArrayList((Object[])ConsumptionStatus.values()), ConsumptionStatus::getStatus, Function.identity());
    }
}

