/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.common.enums;

import java.util.Locale;
import org.apache.inlong.manager.common.util.Preconditions;

public enum FieldType {
    INT,
    TINYINT,
    SMALLINT,
    BIGINT,
    SHORT,
    LONG,
    DOUBLE,
    FLOAT,
    DECIMAL,
    STRING,
    FIXED,
    BYTE,
    BINARY,
    BOOLEAN,
    DATE,
    TIME,
    TIMESTAMP;


    public String toString() {
        return this.name().toLowerCase(Locale.ROOT);
    }

    public static FieldType forName(String name) {
        Preconditions.checkNotNull((Object)name, "FieldType should not be null");
        for (FieldType value : FieldType.values()) {
            if (!value.toString().equals(name) && !value.toString().equals(name.toUpperCase(Locale.ROOT))) continue;
            return value;
        }
        throw new IllegalArgumentException(String.format("Unsupported FieldType : %s", name));
    }
}

