/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.common.enums;

import java.util.Locale;

public enum SinkType {
    HIVE,
    KAFKA,
    ICEBERG,
    CLICKHOUSE;

    public static final String SINK_HIVE = "HIVE";
    public static final String SINK_KAFKA = "KAFKA";
    public static final String SINK_ICEBERG = "ICEBERG";
    public static final String SINK_CLICKHOUSE = "CLICKHOUSE";
    public static final String SINK_TYPE_IS_EMPTY = "Sink type is empty";
    public static final String SINK_TYPE_NOT_SAME = "Expected sink type is %s, but found %s";

    public static SinkType forType(String sinkType) {
        for (SinkType type : SinkType.values()) {
            if (!type.name().equals(sinkType)) continue;
            return type;
        }
        throw new IllegalArgumentException(String.format("Illegal sink type for %s", sinkType));
    }

    public String toString() {
        return this.name().toUpperCase(Locale.ROOT);
    }
}

