/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.common.enums;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public enum SourceState {
    SOURCE_DISABLE(99, "disable"),
    SOURCE_NORMAL(101, "normal"),
    SOURCE_FAILED(102, "failed"),
    SOURCE_FROZEN(104, "frozen"),
    SOURCE_NEW(110, "new created"),
    TO_BE_ISSUED_ADD(200, "waiting to be issued add"),
    TO_BE_ISSUED_DELETE(201, "waiting to be issued delete"),
    TO_BE_ISSUED_RETRY(202, "waiting to be issued retry"),
    TO_BE_ISSUED_BACKTRACK(203, "waiting to be issued backtrack"),
    TO_BE_ISSUED_FROZEN(204, "waiting to be issued frozen"),
    TO_BE_ISSUED_ACTIVE(205, "waiting to be issued active"),
    TO_BE_ISSUED_CHECK(206, "waiting to be issued check"),
    TO_BE_ISSUED_REDO_METRIC(207, "waiting to be issued redo metric"),
    TO_BE_ISSUED_MAKEUP(208, "waiting to be issued makeup"),
    BEEN_ISSUED_ADD(300, "been issued add"),
    BEEN_ISSUED_DELETE(301, "been issued delete"),
    BEEN_ISSUED_RETRY(302, "been issued retry"),
    BEEN_ISSUED_BACKTRACK(303, "been issued backtrack"),
    BEEN_ISSUED_FROZEN(304, "been issued frozen"),
    BEEN_ISSUED_ACTIVE(305, "been issued active"),
    BEEN_ISSUED_CHECK(306, "been issued check"),
    BEEN_ISSUED_REDO_METRIC(307, "been issued redo metric"),
    BEEN_ISSUED_MAKEUP(308, "been issued makeup");

    public static final Set<Integer> TEMP_TO_NORMAL;
    public static final Set<Integer> ALLOWED_UPDATE;
    public static final Set<SourceState> TOBE_ISSUED_SET;
    private static final Map<SourceState, Set<SourceState>> SOURCE_STATE_AUTOMATON;
    private final Integer code;
    private final String description;

    private SourceState(Integer code, String description) {
        this.code = code;
        this.description = description;
    }

    public static SourceState forCode(int code) {
        for (SourceState state : SourceState.values()) {
            if (state.getCode() != code) continue;
            return state;
        }
        throw new IllegalStateException(String.format("Illegal code=%s for SourceState", code));
    }

    public static boolean isAllowedTransition(SourceState current, SourceState next) {
        Set<SourceState> nextStates = SOURCE_STATE_AUTOMATON.get((Object)current);
        return nextStates != null && nextStates.contains((Object)next);
    }

    public Integer getCode() {
        return this.code;
    }

    public String getDescription() {
        return this.description;
    }

    static {
        TEMP_TO_NORMAL = Sets.newHashSet((Object[])new Integer[]{BEEN_ISSUED_ADD.getCode(), BEEN_ISSUED_RETRY.getCode(), BEEN_ISSUED_BACKTRACK.getCode(), BEEN_ISSUED_ACTIVE.getCode(), BEEN_ISSUED_CHECK.getCode(), BEEN_ISSUED_REDO_METRIC.getCode(), BEEN_ISSUED_MAKEUP.getCode()});
        ALLOWED_UPDATE = Sets.newHashSet((Object[])new Integer[]{SOURCE_NEW.getCode(), SOURCE_FAILED.getCode(), SOURCE_FROZEN.getCode(), TO_BE_ISSUED_ADD.getCode(), TO_BE_ISSUED_DELETE.getCode(), TO_BE_ISSUED_RETRY.getCode(), TO_BE_ISSUED_BACKTRACK.getCode(), TO_BE_ISSUED_FROZEN.getCode(), TO_BE_ISSUED_ACTIVE.getCode(), TO_BE_ISSUED_CHECK.getCode(), TO_BE_ISSUED_REDO_METRIC.getCode(), TO_BE_ISSUED_MAKEUP.getCode()});
        TOBE_ISSUED_SET = Sets.newHashSet((Object[])new SourceState[]{TO_BE_ISSUED_ADD, TO_BE_ISSUED_DELETE, TO_BE_ISSUED_RETRY, TO_BE_ISSUED_BACKTRACK, TO_BE_ISSUED_FROZEN, TO_BE_ISSUED_ACTIVE, TO_BE_ISSUED_CHECK, TO_BE_ISSUED_REDO_METRIC, TO_BE_ISSUED_MAKEUP});
        SOURCE_STATE_AUTOMATON = Maps.newHashMap();
        SOURCE_STATE_AUTOMATON.put(SOURCE_NEW, Sets.newHashSet((Object[])new SourceState[]{SOURCE_DISABLE, SOURCE_NEW, TO_BE_ISSUED_ADD}));
        SOURCE_STATE_AUTOMATON.put(SOURCE_NORMAL, Sets.newHashSet((Object[])new SourceState[]{SOURCE_DISABLE, SOURCE_NORMAL, SOURCE_FAILED, TO_BE_ISSUED_DELETE, TO_BE_ISSUED_RETRY, TO_BE_ISSUED_BACKTRACK, TO_BE_ISSUED_FROZEN, TO_BE_ISSUED_ACTIVE, TO_BE_ISSUED_CHECK, TO_BE_ISSUED_REDO_METRIC, TO_BE_ISSUED_MAKEUP}));
        SOURCE_STATE_AUTOMATON.put(SOURCE_FAILED, Sets.newHashSet((Object[])new SourceState[]{SOURCE_DISABLE, SOURCE_FAILED, TO_BE_ISSUED_RETRY}));
        SOURCE_STATE_AUTOMATON.put(SOURCE_FROZEN, Sets.newHashSet((Object[])new SourceState[]{SOURCE_DISABLE, SOURCE_FROZEN, TO_BE_ISSUED_ACTIVE}));
        HashSet tobeAdd = Sets.newHashSet((Object[])new SourceState[]{BEEN_ISSUED_ADD});
        tobeAdd.addAll(TOBE_ISSUED_SET);
        SOURCE_STATE_AUTOMATON.put(TO_BE_ISSUED_ADD, tobeAdd);
        HashSet tobeDelete = Sets.newHashSet((Object[])new SourceState[]{BEEN_ISSUED_DELETE});
        tobeDelete.addAll(TOBE_ISSUED_SET);
        SOURCE_STATE_AUTOMATON.put(TO_BE_ISSUED_DELETE, Sets.newHashSet((Iterable)tobeDelete));
        HashSet tobeRetry = Sets.newHashSet((Object[])new SourceState[]{BEEN_ISSUED_RETRY});
        tobeRetry.addAll(TOBE_ISSUED_SET);
        SOURCE_STATE_AUTOMATON.put(TO_BE_ISSUED_RETRY, Sets.newHashSet((Iterable)tobeRetry));
        HashSet tobeBacktrack = Sets.newHashSet((Object[])new SourceState[]{BEEN_ISSUED_BACKTRACK});
        tobeBacktrack.addAll(TOBE_ISSUED_SET);
        SOURCE_STATE_AUTOMATON.put(TO_BE_ISSUED_BACKTRACK, Sets.newHashSet((Iterable)tobeBacktrack));
        HashSet tobeFrozen = Sets.newHashSet((Object[])new SourceState[]{BEEN_ISSUED_FROZEN});
        tobeFrozen.addAll(TOBE_ISSUED_SET);
        SOURCE_STATE_AUTOMATON.put(TO_BE_ISSUED_FROZEN, Sets.newHashSet((Iterable)tobeFrozen));
        HashSet tobeActive = Sets.newHashSet((Object[])new SourceState[]{BEEN_ISSUED_ACTIVE});
        tobeActive.addAll(TOBE_ISSUED_SET);
        SOURCE_STATE_AUTOMATON.put(TO_BE_ISSUED_ACTIVE, Sets.newHashSet((Iterable)tobeActive));
        HashSet tobeCheck = Sets.newHashSet((Object[])new SourceState[]{BEEN_ISSUED_CHECK});
        tobeCheck.addAll(TOBE_ISSUED_SET);
        SOURCE_STATE_AUTOMATON.put(TO_BE_ISSUED_CHECK, Sets.newHashSet((Iterable)tobeCheck));
        HashSet tobeRedoMetric = Sets.newHashSet((Object[])new SourceState[]{BEEN_ISSUED_REDO_METRIC});
        tobeRedoMetric.addAll(TOBE_ISSUED_SET);
        SOURCE_STATE_AUTOMATON.put(TO_BE_ISSUED_REDO_METRIC, Sets.newHashSet((Iterable)tobeRedoMetric));
        HashSet tobeMakeup = Sets.newHashSet((Object[])new SourceState[]{BEEN_ISSUED_MAKEUP});
        tobeMakeup.addAll(TOBE_ISSUED_SET);
        SOURCE_STATE_AUTOMATON.put(TO_BE_ISSUED_MAKEUP, Sets.newHashSet((Iterable)tobeMakeup));
        SOURCE_STATE_AUTOMATON.put(BEEN_ISSUED_ADD, Sets.newHashSet((Object[])new SourceState[]{SOURCE_NORMAL, SOURCE_FAILED}));
        SOURCE_STATE_AUTOMATON.put(BEEN_ISSUED_DELETE, Sets.newHashSet((Object[])new SourceState[]{SOURCE_NORMAL, SOURCE_FAILED}));
        SOURCE_STATE_AUTOMATON.put(BEEN_ISSUED_RETRY, Sets.newHashSet((Object[])new SourceState[]{SOURCE_NORMAL, SOURCE_FAILED}));
        SOURCE_STATE_AUTOMATON.put(BEEN_ISSUED_BACKTRACK, Sets.newHashSet((Object[])new SourceState[]{SOURCE_NORMAL, SOURCE_FAILED}));
        SOURCE_STATE_AUTOMATON.put(BEEN_ISSUED_FROZEN, Sets.newHashSet((Object[])new SourceState[]{SOURCE_NORMAL, SOURCE_FAILED}));
        SOURCE_STATE_AUTOMATON.put(BEEN_ISSUED_ACTIVE, Sets.newHashSet((Object[])new SourceState[]{SOURCE_NORMAL, SOURCE_FAILED}));
        SOURCE_STATE_AUTOMATON.put(BEEN_ISSUED_CHECK, Sets.newHashSet((Object[])new SourceState[]{SOURCE_NORMAL, SOURCE_FAILED}));
        SOURCE_STATE_AUTOMATON.put(BEEN_ISSUED_REDO_METRIC, Sets.newHashSet((Object[])new SourceState[]{SOURCE_NORMAL, SOURCE_FAILED}));
        SOURCE_STATE_AUTOMATON.put(BEEN_ISSUED_MAKEUP, Sets.newHashSet((Object[])new SourceState[]{SOURCE_NORMAL, SOURCE_FAILED}));
    }
}

