/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.common.pojo.sink;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.google.common.collect.Maps;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.List;
import java.util.Map;
import javax.validation.constraints.NotNull;
import org.apache.inlong.manager.common.pojo.sink.SinkFieldRequest;

@ApiModel(value="Request of sink")
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, visible=true, property="sinkType")
public class SinkRequest {
    private Integer id;
    @ApiModelProperty(value="Inlong group id")
    @NotNull
    private String inlongGroupId;
    @ApiModelProperty(value="Inlong stream id")
    @NotNull
    private String inlongStreamId;
    @ApiModelProperty(value="Sink type, including: HIVE, ES, etc.")
    @NotNull
    private String sinkType;
    @ApiModelProperty(value="Sink name, unique in one stream.")
    @NotNull
    private String sinkName;
    @ApiModelProperty(value="Sink description")
    private String description;
    @ApiModelProperty(value="Whether to enable create sink resource? 0: disable, 1: enable. default is 1")
    private Integer enableCreateResource = 1;
    @ApiModelProperty(value="Sink field list")
    private List<SinkFieldRequest> fieldList;
    @ApiModelProperty(value="Properties for sink")
    private Map<String, Object> properties = Maps.newHashMap();

    public Integer getId() {
        return this.id;
    }

    public String getInlongGroupId() {
        return this.inlongGroupId;
    }

    public String getInlongStreamId() {
        return this.inlongStreamId;
    }

    public String getSinkType() {
        return this.sinkType;
    }

    public String getSinkName() {
        return this.sinkName;
    }

    public String getDescription() {
        return this.description;
    }

    public Integer getEnableCreateResource() {
        return this.enableCreateResource;
    }

    public List<SinkFieldRequest> getFieldList() {
        return this.fieldList;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public void setInlongGroupId(String inlongGroupId) {
        this.inlongGroupId = inlongGroupId;
    }

    public void setInlongStreamId(String inlongStreamId) {
        this.inlongStreamId = inlongStreamId;
    }

    public void setSinkType(String sinkType) {
        this.sinkType = sinkType;
    }

    public void setSinkName(String sinkName) {
        this.sinkName = sinkName;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setEnableCreateResource(Integer enableCreateResource) {
        this.enableCreateResource = enableCreateResource;
    }

    public void setFieldList(List<SinkFieldRequest> fieldList) {
        this.fieldList = fieldList;
    }

    public void setProperties(Map<String, Object> properties) {
        this.properties = properties;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SinkRequest)) {
            return false;
        }
        SinkRequest other = (SinkRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$id = this.getId();
        Integer other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Integer this$enableCreateResource = this.getEnableCreateResource();
        Integer other$enableCreateResource = other.getEnableCreateResource();
        if (this$enableCreateResource == null ? other$enableCreateResource != null : !((Object)this$enableCreateResource).equals(other$enableCreateResource)) {
            return false;
        }
        String this$inlongGroupId = this.getInlongGroupId();
        String other$inlongGroupId = other.getInlongGroupId();
        if (this$inlongGroupId == null ? other$inlongGroupId != null : !this$inlongGroupId.equals(other$inlongGroupId)) {
            return false;
        }
        String this$inlongStreamId = this.getInlongStreamId();
        String other$inlongStreamId = other.getInlongStreamId();
        if (this$inlongStreamId == null ? other$inlongStreamId != null : !this$inlongStreamId.equals(other$inlongStreamId)) {
            return false;
        }
        String this$sinkType = this.getSinkType();
        String other$sinkType = other.getSinkType();
        if (this$sinkType == null ? other$sinkType != null : !this$sinkType.equals(other$sinkType)) {
            return false;
        }
        String this$sinkName = this.getSinkName();
        String other$sinkName = other.getSinkName();
        if (this$sinkName == null ? other$sinkName != null : !this$sinkName.equals(other$sinkName)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        List<SinkFieldRequest> this$fieldList = this.getFieldList();
        List<SinkFieldRequest> other$fieldList = other.getFieldList();
        if (this$fieldList == null ? other$fieldList != null : !((Object)this$fieldList).equals(other$fieldList)) {
            return false;
        }
        Map<String, Object> this$properties = this.getProperties();
        Map<String, Object> other$properties = other.getProperties();
        return !(this$properties == null ? other$properties != null : !((Object)this$properties).equals(other$properties));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SinkRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Integer $enableCreateResource = this.getEnableCreateResource();
        result = result * 59 + ($enableCreateResource == null ? 43 : ((Object)$enableCreateResource).hashCode());
        String $inlongGroupId = this.getInlongGroupId();
        result = result * 59 + ($inlongGroupId == null ? 43 : $inlongGroupId.hashCode());
        String $inlongStreamId = this.getInlongStreamId();
        result = result * 59 + ($inlongStreamId == null ? 43 : $inlongStreamId.hashCode());
        String $sinkType = this.getSinkType();
        result = result * 59 + ($sinkType == null ? 43 : $sinkType.hashCode());
        String $sinkName = this.getSinkName();
        result = result * 59 + ($sinkName == null ? 43 : $sinkName.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        List<SinkFieldRequest> $fieldList = this.getFieldList();
        result = result * 59 + ($fieldList == null ? 43 : ((Object)$fieldList).hashCode());
        Map<String, Object> $properties = this.getProperties();
        result = result * 59 + ($properties == null ? 43 : ((Object)$properties).hashCode());
        return result;
    }

    public String toString() {
        return "SinkRequest(id=" + this.getId() + ", inlongGroupId=" + this.getInlongGroupId() + ", inlongStreamId=" + this.getInlongStreamId() + ", sinkType=" + this.getSinkType() + ", sinkName=" + this.getSinkName() + ", description=" + this.getDescription() + ", enableCreateResource=" + this.getEnableCreateResource() + ", fieldList=" + this.getFieldList() + ", properties=" + this.getProperties() + ")";
    }
}

