/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.common.pojo.sink.ck;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.swagger.annotations.ApiModelProperty;
import java.util.Map;
import javax.validation.constraints.NotNull;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.common.pojo.sink.ck.ClickHouseSinkRequest;

public class ClickHouseSinkDTO {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    @ApiModelProperty(value="ClickHouse JDBC URL")
    private String jdbcUrl;
    @ApiModelProperty(value="Username for JDBC URL")
    private String username;
    @ApiModelProperty(value="User password")
    private String password;
    @ApiModelProperty(value="Target database name")
    private String dbName;
    @ApiModelProperty(value="Target table name")
    private String tableName;
    @ApiModelProperty(value="Flush interval, unit: second, default is 1s")
    private Integer flushInterval;
    @ApiModelProperty(value="Flush when record number reaches flushRecord")
    private Integer flushRecord;
    @ApiModelProperty(value="Write max retry times, default is 3")
    private Integer retryTimes;
    @ApiModelProperty(value="Whether distributed table? 0: no, 1: yes")
    private Integer isDistributed;
    @ApiModelProperty(value="Partition strategy, support: BALANCE, RANDOM, HASH")
    private String partitionStrategy;
    @ApiModelProperty(value="Partition files, separate with commas", notes="Necessary when partitionStrategy is HASH, must be one of the field list")
    private String partitionFields;
    @ApiModelProperty(value="Key field names, separate with commas")
    private String keyFieldNames;
    @ApiModelProperty(value="Properties for clickhouse")
    private Map<String, Object> properties;

    public static ClickHouseSinkDTO getFromRequest(ClickHouseSinkRequest request) {
        return ClickHouseSinkDTO.builder().jdbcUrl(request.getJdbcUrl()).username(request.getUsername()).password(request.getPassword()).dbName(request.getDbName()).tableName(request.getTableName()).flushInterval(request.getFlushInterval()).flushRecord(request.getFlushRecord()).retryTimes(request.getRetryTimes()).isDistributed(request.getIsDistributed()).partitionStrategy(request.getPartitionStrategy()).partitionFields(request.getPartitionFields()).keyFieldNames(request.getKeyFieldNames()).properties(request.getProperties()).build();
    }

    public static ClickHouseSinkDTO getFromJson(@NotNull String extParams) {
        try {
            OBJECT_MAPPER.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            return (ClickHouseSinkDTO)OBJECT_MAPPER.readValue(extParams, ClickHouseSinkDTO.class);
        }
        catch (Exception e) {
            throw new BusinessException(ErrorCodeEnum.SINK_INFO_INCORRECT.getMessage());
        }
    }

    public static ClickHouseSinkDTOBuilder builder() {
        return new ClickHouseSinkDTOBuilder();
    }

    public String getJdbcUrl() {
        return this.jdbcUrl;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getDbName() {
        return this.dbName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public Integer getFlushInterval() {
        return this.flushInterval;
    }

    public Integer getFlushRecord() {
        return this.flushRecord;
    }

    public Integer getRetryTimes() {
        return this.retryTimes;
    }

    public Integer getIsDistributed() {
        return this.isDistributed;
    }

    public String getPartitionStrategy() {
        return this.partitionStrategy;
    }

    public String getPartitionFields() {
        return this.partitionFields;
    }

    public String getKeyFieldNames() {
        return this.keyFieldNames;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public void setJdbcUrl(String jdbcUrl) {
        this.jdbcUrl = jdbcUrl;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setDbName(String dbName) {
        this.dbName = dbName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public void setFlushInterval(Integer flushInterval) {
        this.flushInterval = flushInterval;
    }

    public void setFlushRecord(Integer flushRecord) {
        this.flushRecord = flushRecord;
    }

    public void setRetryTimes(Integer retryTimes) {
        this.retryTimes = retryTimes;
    }

    public void setIsDistributed(Integer isDistributed) {
        this.isDistributed = isDistributed;
    }

    public void setPartitionStrategy(String partitionStrategy) {
        this.partitionStrategy = partitionStrategy;
    }

    public void setPartitionFields(String partitionFields) {
        this.partitionFields = partitionFields;
    }

    public void setKeyFieldNames(String keyFieldNames) {
        this.keyFieldNames = keyFieldNames;
    }

    public void setProperties(Map<String, Object> properties) {
        this.properties = properties;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClickHouseSinkDTO)) {
            return false;
        }
        ClickHouseSinkDTO other = (ClickHouseSinkDTO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$flushInterval = this.getFlushInterval();
        Integer other$flushInterval = other.getFlushInterval();
        if (this$flushInterval == null ? other$flushInterval != null : !((Object)this$flushInterval).equals(other$flushInterval)) {
            return false;
        }
        Integer this$flushRecord = this.getFlushRecord();
        Integer other$flushRecord = other.getFlushRecord();
        if (this$flushRecord == null ? other$flushRecord != null : !((Object)this$flushRecord).equals(other$flushRecord)) {
            return false;
        }
        Integer this$retryTimes = this.getRetryTimes();
        Integer other$retryTimes = other.getRetryTimes();
        if (this$retryTimes == null ? other$retryTimes != null : !((Object)this$retryTimes).equals(other$retryTimes)) {
            return false;
        }
        Integer this$isDistributed = this.getIsDistributed();
        Integer other$isDistributed = other.getIsDistributed();
        if (this$isDistributed == null ? other$isDistributed != null : !((Object)this$isDistributed).equals(other$isDistributed)) {
            return false;
        }
        String this$jdbcUrl = this.getJdbcUrl();
        String other$jdbcUrl = other.getJdbcUrl();
        if (this$jdbcUrl == null ? other$jdbcUrl != null : !this$jdbcUrl.equals(other$jdbcUrl)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        String this$dbName = this.getDbName();
        String other$dbName = other.getDbName();
        if (this$dbName == null ? other$dbName != null : !this$dbName.equals(other$dbName)) {
            return false;
        }
        String this$tableName = this.getTableName();
        String other$tableName = other.getTableName();
        if (this$tableName == null ? other$tableName != null : !this$tableName.equals(other$tableName)) {
            return false;
        }
        String this$partitionStrategy = this.getPartitionStrategy();
        String other$partitionStrategy = other.getPartitionStrategy();
        if (this$partitionStrategy == null ? other$partitionStrategy != null : !this$partitionStrategy.equals(other$partitionStrategy)) {
            return false;
        }
        String this$partitionFields = this.getPartitionFields();
        String other$partitionFields = other.getPartitionFields();
        if (this$partitionFields == null ? other$partitionFields != null : !this$partitionFields.equals(other$partitionFields)) {
            return false;
        }
        String this$keyFieldNames = this.getKeyFieldNames();
        String other$keyFieldNames = other.getKeyFieldNames();
        if (this$keyFieldNames == null ? other$keyFieldNames != null : !this$keyFieldNames.equals(other$keyFieldNames)) {
            return false;
        }
        Map<String, Object> this$properties = this.getProperties();
        Map<String, Object> other$properties = other.getProperties();
        return !(this$properties == null ? other$properties != null : !((Object)this$properties).equals(other$properties));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ClickHouseSinkDTO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $flushInterval = this.getFlushInterval();
        result = result * 59 + ($flushInterval == null ? 43 : ((Object)$flushInterval).hashCode());
        Integer $flushRecord = this.getFlushRecord();
        result = result * 59 + ($flushRecord == null ? 43 : ((Object)$flushRecord).hashCode());
        Integer $retryTimes = this.getRetryTimes();
        result = result * 59 + ($retryTimes == null ? 43 : ((Object)$retryTimes).hashCode());
        Integer $isDistributed = this.getIsDistributed();
        result = result * 59 + ($isDistributed == null ? 43 : ((Object)$isDistributed).hashCode());
        String $jdbcUrl = this.getJdbcUrl();
        result = result * 59 + ($jdbcUrl == null ? 43 : $jdbcUrl.hashCode());
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        String $dbName = this.getDbName();
        result = result * 59 + ($dbName == null ? 43 : $dbName.hashCode());
        String $tableName = this.getTableName();
        result = result * 59 + ($tableName == null ? 43 : $tableName.hashCode());
        String $partitionStrategy = this.getPartitionStrategy();
        result = result * 59 + ($partitionStrategy == null ? 43 : $partitionStrategy.hashCode());
        String $partitionFields = this.getPartitionFields();
        result = result * 59 + ($partitionFields == null ? 43 : $partitionFields.hashCode());
        String $keyFieldNames = this.getKeyFieldNames();
        result = result * 59 + ($keyFieldNames == null ? 43 : $keyFieldNames.hashCode());
        Map<String, Object> $properties = this.getProperties();
        result = result * 59 + ($properties == null ? 43 : ((Object)$properties).hashCode());
        return result;
    }

    public String toString() {
        return "ClickHouseSinkDTO(jdbcUrl=" + this.getJdbcUrl() + ", username=" + this.getUsername() + ", password=" + this.getPassword() + ", dbName=" + this.getDbName() + ", tableName=" + this.getTableName() + ", flushInterval=" + this.getFlushInterval() + ", flushRecord=" + this.getFlushRecord() + ", retryTimes=" + this.getRetryTimes() + ", isDistributed=" + this.getIsDistributed() + ", partitionStrategy=" + this.getPartitionStrategy() + ", partitionFields=" + this.getPartitionFields() + ", keyFieldNames=" + this.getKeyFieldNames() + ", properties=" + this.getProperties() + ")";
    }

    public ClickHouseSinkDTO() {
    }

    public ClickHouseSinkDTO(String jdbcUrl, String username, String password, String dbName, String tableName, Integer flushInterval, Integer flushRecord, Integer retryTimes, Integer isDistributed, String partitionStrategy, String partitionFields, String keyFieldNames, Map<String, Object> properties) {
        this.jdbcUrl = jdbcUrl;
        this.username = username;
        this.password = password;
        this.dbName = dbName;
        this.tableName = tableName;
        this.flushInterval = flushInterval;
        this.flushRecord = flushRecord;
        this.retryTimes = retryTimes;
        this.isDistributed = isDistributed;
        this.partitionStrategy = partitionStrategy;
        this.partitionFields = partitionFields;
        this.keyFieldNames = keyFieldNames;
        this.properties = properties;
    }

    public static class ClickHouseSinkDTOBuilder {
        private String jdbcUrl;
        private String username;
        private String password;
        private String dbName;
        private String tableName;
        private Integer flushInterval;
        private Integer flushRecord;
        private Integer retryTimes;
        private Integer isDistributed;
        private String partitionStrategy;
        private String partitionFields;
        private String keyFieldNames;
        private Map<String, Object> properties;

        ClickHouseSinkDTOBuilder() {
        }

        public ClickHouseSinkDTOBuilder jdbcUrl(String jdbcUrl) {
            this.jdbcUrl = jdbcUrl;
            return this;
        }

        public ClickHouseSinkDTOBuilder username(String username) {
            this.username = username;
            return this;
        }

        public ClickHouseSinkDTOBuilder password(String password) {
            this.password = password;
            return this;
        }

        public ClickHouseSinkDTOBuilder dbName(String dbName) {
            this.dbName = dbName;
            return this;
        }

        public ClickHouseSinkDTOBuilder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public ClickHouseSinkDTOBuilder flushInterval(Integer flushInterval) {
            this.flushInterval = flushInterval;
            return this;
        }

        public ClickHouseSinkDTOBuilder flushRecord(Integer flushRecord) {
            this.flushRecord = flushRecord;
            return this;
        }

        public ClickHouseSinkDTOBuilder retryTimes(Integer retryTimes) {
            this.retryTimes = retryTimes;
            return this;
        }

        public ClickHouseSinkDTOBuilder isDistributed(Integer isDistributed) {
            this.isDistributed = isDistributed;
            return this;
        }

        public ClickHouseSinkDTOBuilder partitionStrategy(String partitionStrategy) {
            this.partitionStrategy = partitionStrategy;
            return this;
        }

        public ClickHouseSinkDTOBuilder partitionFields(String partitionFields) {
            this.partitionFields = partitionFields;
            return this;
        }

        public ClickHouseSinkDTOBuilder keyFieldNames(String keyFieldNames) {
            this.keyFieldNames = keyFieldNames;
            return this;
        }

        public ClickHouseSinkDTOBuilder properties(Map<String, Object> properties) {
            this.properties = properties;
            return this;
        }

        public ClickHouseSinkDTO build() {
            return new ClickHouseSinkDTO(this.jdbcUrl, this.username, this.password, this.dbName, this.tableName, this.flushInterval, this.flushRecord, this.retryTimes, this.isDistributed, this.partitionStrategy, this.partitionFields, this.keyFieldNames, this.properties);
        }

        public String toString() {
            return "ClickHouseSinkDTO.ClickHouseSinkDTOBuilder(jdbcUrl=" + this.jdbcUrl + ", username=" + this.username + ", password=" + this.password + ", dbName=" + this.dbName + ", tableName=" + this.tableName + ", flushInterval=" + this.flushInterval + ", flushRecord=" + this.flushRecord + ", retryTimes=" + this.retryTimes + ", isDistributed=" + this.isDistributed + ", partitionStrategy=" + this.partitionStrategy + ", partitionFields=" + this.partitionFields + ", keyFieldNames=" + this.keyFieldNames + ", properties=" + this.properties + ")";
        }
    }
}

