/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.common.pojo.sink.iceberg;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.swagger.annotations.ApiModelProperty;
import java.util.Map;
import javax.validation.constraints.NotNull;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.common.pojo.sink.iceberg.IcebergSinkRequest;

public class IcebergSinkDTO {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    @ApiModelProperty(value="Hive JDBC URL")
    private String jdbcUrl;
    @ApiModelProperty(value="Username for JDBC URL")
    private String username;
    @ApiModelProperty(value="User password")
    private String password;
    @ApiModelProperty(value="Target database name")
    private String dbName;
    @ApiModelProperty(value="Target table name")
    private String tableName;
    @ApiModelProperty(value="Data path, such as: hdfs://ip:port/user/hive/warehouse/test.db")
    private String dataPath;
    @ApiModelProperty(value="File format, support: Parquet, Orc, Avro")
    private String fileFormat;
    @ApiModelProperty(value="Data encoding type")
    private String dataEncoding;
    @ApiModelProperty(value="Data field separator")
    private String dataSeparator;
    @ApiModelProperty(value="Data consistency strategy, support: EXACTLY_ONCE(default), AT_LEAST_ONCE")
    private String dataConsistency;
    @ApiModelProperty(value="Properties for iceberg")
    private Map<String, Object> properties;

    public static IcebergSinkDTO getFromRequest(IcebergSinkRequest request) {
        return IcebergSinkDTO.builder().jdbcUrl(request.getJdbcUrl()).username(request.getUsername()).password(request.getPassword()).dbName(request.getDbName()).tableName(request.getTableName()).dataPath(request.getDataPath()).fileFormat(request.getFileFormat()).dataEncoding(request.getDataEncoding()).dataSeparator(request.getDataSeparator()).dataConsistency(request.getDataConsistency()).properties(request.getProperties()).build();
    }

    public static IcebergSinkDTO getFromJson(@NotNull String extParams) {
        try {
            OBJECT_MAPPER.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            return (IcebergSinkDTO)OBJECT_MAPPER.readValue(extParams, IcebergSinkDTO.class);
        }
        catch (Exception e) {
            throw new BusinessException(ErrorCodeEnum.SINK_INFO_INCORRECT.getMessage());
        }
    }

    public static IcebergSinkDTOBuilder builder() {
        return new IcebergSinkDTOBuilder();
    }

    public String getJdbcUrl() {
        return this.jdbcUrl;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getDbName() {
        return this.dbName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getDataPath() {
        return this.dataPath;
    }

    public String getFileFormat() {
        return this.fileFormat;
    }

    public String getDataEncoding() {
        return this.dataEncoding;
    }

    public String getDataSeparator() {
        return this.dataSeparator;
    }

    public String getDataConsistency() {
        return this.dataConsistency;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public void setJdbcUrl(String jdbcUrl) {
        this.jdbcUrl = jdbcUrl;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setDbName(String dbName) {
        this.dbName = dbName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public void setDataPath(String dataPath) {
        this.dataPath = dataPath;
    }

    public void setFileFormat(String fileFormat) {
        this.fileFormat = fileFormat;
    }

    public void setDataEncoding(String dataEncoding) {
        this.dataEncoding = dataEncoding;
    }

    public void setDataSeparator(String dataSeparator) {
        this.dataSeparator = dataSeparator;
    }

    public void setDataConsistency(String dataConsistency) {
        this.dataConsistency = dataConsistency;
    }

    public void setProperties(Map<String, Object> properties) {
        this.properties = properties;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IcebergSinkDTO)) {
            return false;
        }
        IcebergSinkDTO other = (IcebergSinkDTO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$jdbcUrl = this.getJdbcUrl();
        String other$jdbcUrl = other.getJdbcUrl();
        if (this$jdbcUrl == null ? other$jdbcUrl != null : !this$jdbcUrl.equals(other$jdbcUrl)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        String this$dbName = this.getDbName();
        String other$dbName = other.getDbName();
        if (this$dbName == null ? other$dbName != null : !this$dbName.equals(other$dbName)) {
            return false;
        }
        String this$tableName = this.getTableName();
        String other$tableName = other.getTableName();
        if (this$tableName == null ? other$tableName != null : !this$tableName.equals(other$tableName)) {
            return false;
        }
        String this$dataPath = this.getDataPath();
        String other$dataPath = other.getDataPath();
        if (this$dataPath == null ? other$dataPath != null : !this$dataPath.equals(other$dataPath)) {
            return false;
        }
        String this$fileFormat = this.getFileFormat();
        String other$fileFormat = other.getFileFormat();
        if (this$fileFormat == null ? other$fileFormat != null : !this$fileFormat.equals(other$fileFormat)) {
            return false;
        }
        String this$dataEncoding = this.getDataEncoding();
        String other$dataEncoding = other.getDataEncoding();
        if (this$dataEncoding == null ? other$dataEncoding != null : !this$dataEncoding.equals(other$dataEncoding)) {
            return false;
        }
        String this$dataSeparator = this.getDataSeparator();
        String other$dataSeparator = other.getDataSeparator();
        if (this$dataSeparator == null ? other$dataSeparator != null : !this$dataSeparator.equals(other$dataSeparator)) {
            return false;
        }
        String this$dataConsistency = this.getDataConsistency();
        String other$dataConsistency = other.getDataConsistency();
        if (this$dataConsistency == null ? other$dataConsistency != null : !this$dataConsistency.equals(other$dataConsistency)) {
            return false;
        }
        Map<String, Object> this$properties = this.getProperties();
        Map<String, Object> other$properties = other.getProperties();
        return !(this$properties == null ? other$properties != null : !((Object)this$properties).equals(other$properties));
    }

    protected boolean canEqual(Object other) {
        return other instanceof IcebergSinkDTO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $jdbcUrl = this.getJdbcUrl();
        result = result * 59 + ($jdbcUrl == null ? 43 : $jdbcUrl.hashCode());
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        String $dbName = this.getDbName();
        result = result * 59 + ($dbName == null ? 43 : $dbName.hashCode());
        String $tableName = this.getTableName();
        result = result * 59 + ($tableName == null ? 43 : $tableName.hashCode());
        String $dataPath = this.getDataPath();
        result = result * 59 + ($dataPath == null ? 43 : $dataPath.hashCode());
        String $fileFormat = this.getFileFormat();
        result = result * 59 + ($fileFormat == null ? 43 : $fileFormat.hashCode());
        String $dataEncoding = this.getDataEncoding();
        result = result * 59 + ($dataEncoding == null ? 43 : $dataEncoding.hashCode());
        String $dataSeparator = this.getDataSeparator();
        result = result * 59 + ($dataSeparator == null ? 43 : $dataSeparator.hashCode());
        String $dataConsistency = this.getDataConsistency();
        result = result * 59 + ($dataConsistency == null ? 43 : $dataConsistency.hashCode());
        Map<String, Object> $properties = this.getProperties();
        result = result * 59 + ($properties == null ? 43 : ((Object)$properties).hashCode());
        return result;
    }

    public String toString() {
        return "IcebergSinkDTO(jdbcUrl=" + this.getJdbcUrl() + ", username=" + this.getUsername() + ", password=" + this.getPassword() + ", dbName=" + this.getDbName() + ", tableName=" + this.getTableName() + ", dataPath=" + this.getDataPath() + ", fileFormat=" + this.getFileFormat() + ", dataEncoding=" + this.getDataEncoding() + ", dataSeparator=" + this.getDataSeparator() + ", dataConsistency=" + this.getDataConsistency() + ", properties=" + this.getProperties() + ")";
    }

    public IcebergSinkDTO() {
    }

    public IcebergSinkDTO(String jdbcUrl, String username, String password, String dbName, String tableName, String dataPath, String fileFormat, String dataEncoding, String dataSeparator, String dataConsistency, Map<String, Object> properties) {
        this.jdbcUrl = jdbcUrl;
        this.username = username;
        this.password = password;
        this.dbName = dbName;
        this.tableName = tableName;
        this.dataPath = dataPath;
        this.fileFormat = fileFormat;
        this.dataEncoding = dataEncoding;
        this.dataSeparator = dataSeparator;
        this.dataConsistency = dataConsistency;
        this.properties = properties;
    }

    public static class IcebergSinkDTOBuilder {
        private String jdbcUrl;
        private String username;
        private String password;
        private String dbName;
        private String tableName;
        private String dataPath;
        private String fileFormat;
        private String dataEncoding;
        private String dataSeparator;
        private String dataConsistency;
        private Map<String, Object> properties;

        IcebergSinkDTOBuilder() {
        }

        public IcebergSinkDTOBuilder jdbcUrl(String jdbcUrl) {
            this.jdbcUrl = jdbcUrl;
            return this;
        }

        public IcebergSinkDTOBuilder username(String username) {
            this.username = username;
            return this;
        }

        public IcebergSinkDTOBuilder password(String password) {
            this.password = password;
            return this;
        }

        public IcebergSinkDTOBuilder dbName(String dbName) {
            this.dbName = dbName;
            return this;
        }

        public IcebergSinkDTOBuilder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public IcebergSinkDTOBuilder dataPath(String dataPath) {
            this.dataPath = dataPath;
            return this;
        }

        public IcebergSinkDTOBuilder fileFormat(String fileFormat) {
            this.fileFormat = fileFormat;
            return this;
        }

        public IcebergSinkDTOBuilder dataEncoding(String dataEncoding) {
            this.dataEncoding = dataEncoding;
            return this;
        }

        public IcebergSinkDTOBuilder dataSeparator(String dataSeparator) {
            this.dataSeparator = dataSeparator;
            return this;
        }

        public IcebergSinkDTOBuilder dataConsistency(String dataConsistency) {
            this.dataConsistency = dataConsistency;
            return this;
        }

        public IcebergSinkDTOBuilder properties(Map<String, Object> properties) {
            this.properties = properties;
            return this;
        }

        public IcebergSinkDTO build() {
            return new IcebergSinkDTO(this.jdbcUrl, this.username, this.password, this.dbName, this.tableName, this.dataPath, this.fileFormat, this.dataEncoding, this.dataSeparator, this.dataConsistency, this.properties);
        }

        public String toString() {
            return "IcebergSinkDTO.IcebergSinkDTOBuilder(jdbcUrl=" + this.jdbcUrl + ", username=" + this.username + ", password=" + this.password + ", dbName=" + this.dbName + ", tableName=" + this.tableName + ", dataPath=" + this.dataPath + ", fileFormat=" + this.fileFormat + ", dataEncoding=" + this.dataEncoding + ", dataSeparator=" + this.dataSeparator + ", dataConsistency=" + this.dataConsistency + ", properties=" + this.properties + ")";
        }
    }
}

