/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.common.pojo.source.binlog;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.swagger.annotations.ApiModelProperty;
import javax.validation.constraints.NotNull;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.common.pojo.source.binlog.BinlogSourceRequest;

public class BinlogSourceDTO {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    @ApiModelProperty(value="Username of the DB server")
    private String user;
    @ApiModelProperty(value="Password of the DB server")
    private String password;
    @ApiModelProperty(value="Hostname of the DB server")
    private String hostname;
    @ApiModelProperty(value="Exposed port of the DB server")
    private int port;
    @ApiModelProperty(value="Whether include schema, default is 'false'")
    private String includeSchema;
    @ApiModelProperty(value="List of DBs to be collected, supporting regular expressions, separate them with commas, for example: db1,test_db*", notes="DBs not in this list are excluded. If not set, all DBs are monitored")
    private String databaseWhiteList;
    @ApiModelProperty(value="List of tables to be collected, supporting regular expressions, separate them with commas, for example: tb1,user*", notes="Tables not in this list are excluded. By default, all tables are monitored")
    private String tableWhiteList;
    @ApiModelProperty(value="Database time zone, Default is UTC")
    private String serverTimezone;
    @ApiModelProperty(value="The interval for recording an offset")
    private String intervalMs;
    @ApiModelProperty(value="Snapshot mode, supports: initial, when_needed, never, schema_only, schema_only_recovery")
    private String snapshotMode;
    @ApiModelProperty(value="The file path to store offset info")
    private String offsetFilename;
    @ApiModelProperty(value="The file path to store history info")
    private String historyFilename;
    @ApiModelProperty(value="Whether to monitor the DDL, default is 'false'")
    private String monitoredDdl;
    @ApiModelProperty(value="Timestamp standard for binlog: SQL, ISO_8601")
    private String timestampFormatStandard = "SQL";
    @ApiModelProperty(value="Whether to migrate all databases")
    private boolean allMigration;

    public static BinlogSourceDTO getFromRequest(BinlogSourceRequest request) {
        return BinlogSourceDTO.builder().user(request.getUser()).password(request.getPassword()).hostname(request.getHostname()).port(request.getPort()).includeSchema(request.getIncludeSchema()).databaseWhiteList(request.getDatabaseWhiteList()).tableWhiteList(request.getTableWhiteList()).serverTimezone(request.getServerTimezone()).intervalMs(request.getIntervalMs()).snapshotMode(request.getSnapshotMode()).offsetFilename(request.getOffsetFilename()).historyFilename(request.getHistoryFilename()).monitoredDdl(request.getMonitoredDdl()).allMigration(request.isAllMigration()).build();
    }

    public static BinlogSourceDTO getFromJson(@NotNull String extParams) {
        try {
            OBJECT_MAPPER.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            return (BinlogSourceDTO)OBJECT_MAPPER.readValue(extParams, BinlogSourceDTO.class);
        }
        catch (Exception e) {
            throw new BusinessException(ErrorCodeEnum.SOURCE_INFO_INCORRECT.getMessage());
        }
    }

    public static BinlogSourceDTOBuilder builder() {
        return new BinlogSourceDTOBuilder();
    }

    public String getUser() {
        return this.user;
    }

    public String getPassword() {
        return this.password;
    }

    public String getHostname() {
        return this.hostname;
    }

    public int getPort() {
        return this.port;
    }

    public String getIncludeSchema() {
        return this.includeSchema;
    }

    public String getDatabaseWhiteList() {
        return this.databaseWhiteList;
    }

    public String getTableWhiteList() {
        return this.tableWhiteList;
    }

    public String getServerTimezone() {
        return this.serverTimezone;
    }

    public String getIntervalMs() {
        return this.intervalMs;
    }

    public String getSnapshotMode() {
        return this.snapshotMode;
    }

    public String getOffsetFilename() {
        return this.offsetFilename;
    }

    public String getHistoryFilename() {
        return this.historyFilename;
    }

    public String getMonitoredDdl() {
        return this.monitoredDdl;
    }

    public String getTimestampFormatStandard() {
        return this.timestampFormatStandard;
    }

    public boolean isAllMigration() {
        return this.allMigration;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setIncludeSchema(String includeSchema) {
        this.includeSchema = includeSchema;
    }

    public void setDatabaseWhiteList(String databaseWhiteList) {
        this.databaseWhiteList = databaseWhiteList;
    }

    public void setTableWhiteList(String tableWhiteList) {
        this.tableWhiteList = tableWhiteList;
    }

    public void setServerTimezone(String serverTimezone) {
        this.serverTimezone = serverTimezone;
    }

    public void setIntervalMs(String intervalMs) {
        this.intervalMs = intervalMs;
    }

    public void setSnapshotMode(String snapshotMode) {
        this.snapshotMode = snapshotMode;
    }

    public void setOffsetFilename(String offsetFilename) {
        this.offsetFilename = offsetFilename;
    }

    public void setHistoryFilename(String historyFilename) {
        this.historyFilename = historyFilename;
    }

    public void setMonitoredDdl(String monitoredDdl) {
        this.monitoredDdl = monitoredDdl;
    }

    public void setTimestampFormatStandard(String timestampFormatStandard) {
        this.timestampFormatStandard = timestampFormatStandard;
    }

    public void setAllMigration(boolean allMigration) {
        this.allMigration = allMigration;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BinlogSourceDTO)) {
            return false;
        }
        BinlogSourceDTO other = (BinlogSourceDTO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getPort() != other.getPort()) {
            return false;
        }
        if (this.isAllMigration() != other.isAllMigration()) {
            return false;
        }
        String this$user = this.getUser();
        String other$user = other.getUser();
        if (this$user == null ? other$user != null : !this$user.equals(other$user)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        String this$hostname = this.getHostname();
        String other$hostname = other.getHostname();
        if (this$hostname == null ? other$hostname != null : !this$hostname.equals(other$hostname)) {
            return false;
        }
        String this$includeSchema = this.getIncludeSchema();
        String other$includeSchema = other.getIncludeSchema();
        if (this$includeSchema == null ? other$includeSchema != null : !this$includeSchema.equals(other$includeSchema)) {
            return false;
        }
        String this$databaseWhiteList = this.getDatabaseWhiteList();
        String other$databaseWhiteList = other.getDatabaseWhiteList();
        if (this$databaseWhiteList == null ? other$databaseWhiteList != null : !this$databaseWhiteList.equals(other$databaseWhiteList)) {
            return false;
        }
        String this$tableWhiteList = this.getTableWhiteList();
        String other$tableWhiteList = other.getTableWhiteList();
        if (this$tableWhiteList == null ? other$tableWhiteList != null : !this$tableWhiteList.equals(other$tableWhiteList)) {
            return false;
        }
        String this$serverTimezone = this.getServerTimezone();
        String other$serverTimezone = other.getServerTimezone();
        if (this$serverTimezone == null ? other$serverTimezone != null : !this$serverTimezone.equals(other$serverTimezone)) {
            return false;
        }
        String this$intervalMs = this.getIntervalMs();
        String other$intervalMs = other.getIntervalMs();
        if (this$intervalMs == null ? other$intervalMs != null : !this$intervalMs.equals(other$intervalMs)) {
            return false;
        }
        String this$snapshotMode = this.getSnapshotMode();
        String other$snapshotMode = other.getSnapshotMode();
        if (this$snapshotMode == null ? other$snapshotMode != null : !this$snapshotMode.equals(other$snapshotMode)) {
            return false;
        }
        String this$offsetFilename = this.getOffsetFilename();
        String other$offsetFilename = other.getOffsetFilename();
        if (this$offsetFilename == null ? other$offsetFilename != null : !this$offsetFilename.equals(other$offsetFilename)) {
            return false;
        }
        String this$historyFilename = this.getHistoryFilename();
        String other$historyFilename = other.getHistoryFilename();
        if (this$historyFilename == null ? other$historyFilename != null : !this$historyFilename.equals(other$historyFilename)) {
            return false;
        }
        String this$monitoredDdl = this.getMonitoredDdl();
        String other$monitoredDdl = other.getMonitoredDdl();
        if (this$monitoredDdl == null ? other$monitoredDdl != null : !this$monitoredDdl.equals(other$monitoredDdl)) {
            return false;
        }
        String this$timestampFormatStandard = this.getTimestampFormatStandard();
        String other$timestampFormatStandard = other.getTimestampFormatStandard();
        return !(this$timestampFormatStandard == null ? other$timestampFormatStandard != null : !this$timestampFormatStandard.equals(other$timestampFormatStandard));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BinlogSourceDTO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getPort();
        result = result * 59 + (this.isAllMigration() ? 79 : 97);
        String $user = this.getUser();
        result = result * 59 + ($user == null ? 43 : $user.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        String $hostname = this.getHostname();
        result = result * 59 + ($hostname == null ? 43 : $hostname.hashCode());
        String $includeSchema = this.getIncludeSchema();
        result = result * 59 + ($includeSchema == null ? 43 : $includeSchema.hashCode());
        String $databaseWhiteList = this.getDatabaseWhiteList();
        result = result * 59 + ($databaseWhiteList == null ? 43 : $databaseWhiteList.hashCode());
        String $tableWhiteList = this.getTableWhiteList();
        result = result * 59 + ($tableWhiteList == null ? 43 : $tableWhiteList.hashCode());
        String $serverTimezone = this.getServerTimezone();
        result = result * 59 + ($serverTimezone == null ? 43 : $serverTimezone.hashCode());
        String $intervalMs = this.getIntervalMs();
        result = result * 59 + ($intervalMs == null ? 43 : $intervalMs.hashCode());
        String $snapshotMode = this.getSnapshotMode();
        result = result * 59 + ($snapshotMode == null ? 43 : $snapshotMode.hashCode());
        String $offsetFilename = this.getOffsetFilename();
        result = result * 59 + ($offsetFilename == null ? 43 : $offsetFilename.hashCode());
        String $historyFilename = this.getHistoryFilename();
        result = result * 59 + ($historyFilename == null ? 43 : $historyFilename.hashCode());
        String $monitoredDdl = this.getMonitoredDdl();
        result = result * 59 + ($monitoredDdl == null ? 43 : $monitoredDdl.hashCode());
        String $timestampFormatStandard = this.getTimestampFormatStandard();
        result = result * 59 + ($timestampFormatStandard == null ? 43 : $timestampFormatStandard.hashCode());
        return result;
    }

    public String toString() {
        return "BinlogSourceDTO(user=" + this.getUser() + ", password=" + this.getPassword() + ", hostname=" + this.getHostname() + ", port=" + this.getPort() + ", includeSchema=" + this.getIncludeSchema() + ", databaseWhiteList=" + this.getDatabaseWhiteList() + ", tableWhiteList=" + this.getTableWhiteList() + ", serverTimezone=" + this.getServerTimezone() + ", intervalMs=" + this.getIntervalMs() + ", snapshotMode=" + this.getSnapshotMode() + ", offsetFilename=" + this.getOffsetFilename() + ", historyFilename=" + this.getHistoryFilename() + ", monitoredDdl=" + this.getMonitoredDdl() + ", timestampFormatStandard=" + this.getTimestampFormatStandard() + ", allMigration=" + this.isAllMigration() + ")";
    }

    public BinlogSourceDTO() {
    }

    public BinlogSourceDTO(String user, String password, String hostname, int port, String includeSchema, String databaseWhiteList, String tableWhiteList, String serverTimezone, String intervalMs, String snapshotMode, String offsetFilename, String historyFilename, String monitoredDdl, String timestampFormatStandard, boolean allMigration) {
        this.user = user;
        this.password = password;
        this.hostname = hostname;
        this.port = port;
        this.includeSchema = includeSchema;
        this.databaseWhiteList = databaseWhiteList;
        this.tableWhiteList = tableWhiteList;
        this.serverTimezone = serverTimezone;
        this.intervalMs = intervalMs;
        this.snapshotMode = snapshotMode;
        this.offsetFilename = offsetFilename;
        this.historyFilename = historyFilename;
        this.monitoredDdl = monitoredDdl;
        this.timestampFormatStandard = timestampFormatStandard;
        this.allMigration = allMigration;
    }

    public static class BinlogSourceDTOBuilder {
        private String user;
        private String password;
        private String hostname;
        private int port;
        private String includeSchema;
        private String databaseWhiteList;
        private String tableWhiteList;
        private String serverTimezone;
        private String intervalMs;
        private String snapshotMode;
        private String offsetFilename;
        private String historyFilename;
        private String monitoredDdl;
        private String timestampFormatStandard;
        private boolean allMigration;

        BinlogSourceDTOBuilder() {
        }

        public BinlogSourceDTOBuilder user(String user) {
            this.user = user;
            return this;
        }

        public BinlogSourceDTOBuilder password(String password) {
            this.password = password;
            return this;
        }

        public BinlogSourceDTOBuilder hostname(String hostname) {
            this.hostname = hostname;
            return this;
        }

        public BinlogSourceDTOBuilder port(int port) {
            this.port = port;
            return this;
        }

        public BinlogSourceDTOBuilder includeSchema(String includeSchema) {
            this.includeSchema = includeSchema;
            return this;
        }

        public BinlogSourceDTOBuilder databaseWhiteList(String databaseWhiteList) {
            this.databaseWhiteList = databaseWhiteList;
            return this;
        }

        public BinlogSourceDTOBuilder tableWhiteList(String tableWhiteList) {
            this.tableWhiteList = tableWhiteList;
            return this;
        }

        public BinlogSourceDTOBuilder serverTimezone(String serverTimezone) {
            this.serverTimezone = serverTimezone;
            return this;
        }

        public BinlogSourceDTOBuilder intervalMs(String intervalMs) {
            this.intervalMs = intervalMs;
            return this;
        }

        public BinlogSourceDTOBuilder snapshotMode(String snapshotMode) {
            this.snapshotMode = snapshotMode;
            return this;
        }

        public BinlogSourceDTOBuilder offsetFilename(String offsetFilename) {
            this.offsetFilename = offsetFilename;
            return this;
        }

        public BinlogSourceDTOBuilder historyFilename(String historyFilename) {
            this.historyFilename = historyFilename;
            return this;
        }

        public BinlogSourceDTOBuilder monitoredDdl(String monitoredDdl) {
            this.monitoredDdl = monitoredDdl;
            return this;
        }

        public BinlogSourceDTOBuilder timestampFormatStandard(String timestampFormatStandard) {
            this.timestampFormatStandard = timestampFormatStandard;
            return this;
        }

        public BinlogSourceDTOBuilder allMigration(boolean allMigration) {
            this.allMigration = allMigration;
            return this;
        }

        public BinlogSourceDTO build() {
            return new BinlogSourceDTO(this.user, this.password, this.hostname, this.port, this.includeSchema, this.databaseWhiteList, this.tableWhiteList, this.serverTimezone, this.intervalMs, this.snapshotMode, this.offsetFilename, this.historyFilename, this.monitoredDdl, this.timestampFormatStandard, this.allMigration);
        }

        public String toString() {
            return "BinlogSourceDTO.BinlogSourceDTOBuilder(user=" + this.user + ", password=" + this.password + ", hostname=" + this.hostname + ", port=" + this.port + ", includeSchema=" + this.includeSchema + ", databaseWhiteList=" + this.databaseWhiteList + ", tableWhiteList=" + this.tableWhiteList + ", serverTimezone=" + this.serverTimezone + ", intervalMs=" + this.intervalMs + ", snapshotMode=" + this.snapshotMode + ", offsetFilename=" + this.offsetFilename + ", historyFilename=" + this.historyFilename + ", monitoredDdl=" + this.monitoredDdl + ", timestampFormatStandard=" + this.timestampFormatStandard + ", allMigration=" + this.allMigration + ")";
        }
    }
}

