/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.common.pojo.source.binlog;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.apache.inlong.manager.common.enums.SourceType;
import org.apache.inlong.manager.common.pojo.source.SourceResponse;

@ApiModel(value="Response of the binlog source")
public class BinlogSourceResponse
extends SourceResponse {
    @ApiModelProperty(value="Username of the DB server")
    private String user;
    @ApiModelProperty(value="Password of the DB server")
    private String password;
    @ApiModelProperty(value="Hostname of the DB server")
    private String hostname;
    @ApiModelProperty(value="Exposed port of the DB server")
    private int port;
    @ApiModelProperty(value="Whether include schema, default is 'false'")
    private String includeSchema;
    @ApiModelProperty(value="List of DBs to be collected, supporting regular expressions")
    private String databaseWhiteList;
    @ApiModelProperty(value="List of tables to be collected, supporting regular expressions")
    private String tableWhiteList;
    @ApiModelProperty(value="Database time zone, Default is UTC")
    private String serverTimezone;
    @ApiModelProperty(value="The interval for recording an offset")
    private String intervalMs;
    @ApiModelProperty(value="Snapshot mode, supports: initial, when_needed, never, schema_only, schema_only_recovery")
    private String snapshotMode;
    @ApiModelProperty(value="The file path to store offset info")
    private String offsetFilename;
    @ApiModelProperty(value="The file path to store history info")
    private String historyFilename;
    @ApiModelProperty(value="Whether to monitor the DDL, default is 'false'")
    private String monitoredDdl;
    @ApiModelProperty(value="Timestamp standard for binlog: SQL, ISO_8601")
    private String timestampFormatStandard = "SQL";
    @ApiModelProperty(value="Need transfer total database")
    private boolean allMigration;

    public BinlogSourceResponse() {
        this.setSourceType(SourceType.BINLOG.name());
    }

    public String getUser() {
        return this.user;
    }

    public String getPassword() {
        return this.password;
    }

    public String getHostname() {
        return this.hostname;
    }

    public int getPort() {
        return this.port;
    }

    public String getIncludeSchema() {
        return this.includeSchema;
    }

    public String getDatabaseWhiteList() {
        return this.databaseWhiteList;
    }

    public String getTableWhiteList() {
        return this.tableWhiteList;
    }

    public String getServerTimezone() {
        return this.serverTimezone;
    }

    public String getIntervalMs() {
        return this.intervalMs;
    }

    public String getSnapshotMode() {
        return this.snapshotMode;
    }

    public String getOffsetFilename() {
        return this.offsetFilename;
    }

    public String getHistoryFilename() {
        return this.historyFilename;
    }

    public String getMonitoredDdl() {
        return this.monitoredDdl;
    }

    public String getTimestampFormatStandard() {
        return this.timestampFormatStandard;
    }

    public boolean isAllMigration() {
        return this.allMigration;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setIncludeSchema(String includeSchema) {
        this.includeSchema = includeSchema;
    }

    public void setDatabaseWhiteList(String databaseWhiteList) {
        this.databaseWhiteList = databaseWhiteList;
    }

    public void setTableWhiteList(String tableWhiteList) {
        this.tableWhiteList = tableWhiteList;
    }

    public void setServerTimezone(String serverTimezone) {
        this.serverTimezone = serverTimezone;
    }

    public void setIntervalMs(String intervalMs) {
        this.intervalMs = intervalMs;
    }

    public void setSnapshotMode(String snapshotMode) {
        this.snapshotMode = snapshotMode;
    }

    public void setOffsetFilename(String offsetFilename) {
        this.offsetFilename = offsetFilename;
    }

    public void setHistoryFilename(String historyFilename) {
        this.historyFilename = historyFilename;
    }

    public void setMonitoredDdl(String monitoredDdl) {
        this.monitoredDdl = monitoredDdl;
    }

    public void setTimestampFormatStandard(String timestampFormatStandard) {
        this.timestampFormatStandard = timestampFormatStandard;
    }

    public void setAllMigration(boolean allMigration) {
        this.allMigration = allMigration;
    }

    @Override
    public String toString() {
        return "BinlogSourceResponse(super=" + super.toString() + ", user=" + this.getUser() + ", password=" + this.getPassword() + ", hostname=" + this.getHostname() + ", port=" + this.getPort() + ", includeSchema=" + this.getIncludeSchema() + ", databaseWhiteList=" + this.getDatabaseWhiteList() + ", tableWhiteList=" + this.getTableWhiteList() + ", serverTimezone=" + this.getServerTimezone() + ", intervalMs=" + this.getIntervalMs() + ", snapshotMode=" + this.getSnapshotMode() + ", offsetFilename=" + this.getOffsetFilename() + ", historyFilename=" + this.getHistoryFilename() + ", monitoredDdl=" + this.getMonitoredDdl() + ", timestampFormatStandard=" + this.getTimestampFormatStandard() + ", allMigration=" + this.isAllMigration() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BinlogSourceResponse)) {
            return false;
        }
        BinlogSourceResponse other = (BinlogSourceResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getPort() != other.getPort()) {
            return false;
        }
        if (this.isAllMigration() != other.isAllMigration()) {
            return false;
        }
        String this$user = this.getUser();
        String other$user = other.getUser();
        if (this$user == null ? other$user != null : !this$user.equals(other$user)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        String this$hostname = this.getHostname();
        String other$hostname = other.getHostname();
        if (this$hostname == null ? other$hostname != null : !this$hostname.equals(other$hostname)) {
            return false;
        }
        String this$includeSchema = this.getIncludeSchema();
        String other$includeSchema = other.getIncludeSchema();
        if (this$includeSchema == null ? other$includeSchema != null : !this$includeSchema.equals(other$includeSchema)) {
            return false;
        }
        String this$databaseWhiteList = this.getDatabaseWhiteList();
        String other$databaseWhiteList = other.getDatabaseWhiteList();
        if (this$databaseWhiteList == null ? other$databaseWhiteList != null : !this$databaseWhiteList.equals(other$databaseWhiteList)) {
            return false;
        }
        String this$tableWhiteList = this.getTableWhiteList();
        String other$tableWhiteList = other.getTableWhiteList();
        if (this$tableWhiteList == null ? other$tableWhiteList != null : !this$tableWhiteList.equals(other$tableWhiteList)) {
            return false;
        }
        String this$serverTimezone = this.getServerTimezone();
        String other$serverTimezone = other.getServerTimezone();
        if (this$serverTimezone == null ? other$serverTimezone != null : !this$serverTimezone.equals(other$serverTimezone)) {
            return false;
        }
        String this$intervalMs = this.getIntervalMs();
        String other$intervalMs = other.getIntervalMs();
        if (this$intervalMs == null ? other$intervalMs != null : !this$intervalMs.equals(other$intervalMs)) {
            return false;
        }
        String this$snapshotMode = this.getSnapshotMode();
        String other$snapshotMode = other.getSnapshotMode();
        if (this$snapshotMode == null ? other$snapshotMode != null : !this$snapshotMode.equals(other$snapshotMode)) {
            return false;
        }
        String this$offsetFilename = this.getOffsetFilename();
        String other$offsetFilename = other.getOffsetFilename();
        if (this$offsetFilename == null ? other$offsetFilename != null : !this$offsetFilename.equals(other$offsetFilename)) {
            return false;
        }
        String this$historyFilename = this.getHistoryFilename();
        String other$historyFilename = other.getHistoryFilename();
        if (this$historyFilename == null ? other$historyFilename != null : !this$historyFilename.equals(other$historyFilename)) {
            return false;
        }
        String this$monitoredDdl = this.getMonitoredDdl();
        String other$monitoredDdl = other.getMonitoredDdl();
        if (this$monitoredDdl == null ? other$monitoredDdl != null : !this$monitoredDdl.equals(other$monitoredDdl)) {
            return false;
        }
        String this$timestampFormatStandard = this.getTimestampFormatStandard();
        String other$timestampFormatStandard = other.getTimestampFormatStandard();
        return !(this$timestampFormatStandard == null ? other$timestampFormatStandard != null : !this$timestampFormatStandard.equals(other$timestampFormatStandard));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof BinlogSourceResponse;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.getPort();
        result = result * 59 + (this.isAllMigration() ? 79 : 97);
        String $user = this.getUser();
        result = result * 59 + ($user == null ? 43 : $user.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        String $hostname = this.getHostname();
        result = result * 59 + ($hostname == null ? 43 : $hostname.hashCode());
        String $includeSchema = this.getIncludeSchema();
        result = result * 59 + ($includeSchema == null ? 43 : $includeSchema.hashCode());
        String $databaseWhiteList = this.getDatabaseWhiteList();
        result = result * 59 + ($databaseWhiteList == null ? 43 : $databaseWhiteList.hashCode());
        String $tableWhiteList = this.getTableWhiteList();
        result = result * 59 + ($tableWhiteList == null ? 43 : $tableWhiteList.hashCode());
        String $serverTimezone = this.getServerTimezone();
        result = result * 59 + ($serverTimezone == null ? 43 : $serverTimezone.hashCode());
        String $intervalMs = this.getIntervalMs();
        result = result * 59 + ($intervalMs == null ? 43 : $intervalMs.hashCode());
        String $snapshotMode = this.getSnapshotMode();
        result = result * 59 + ($snapshotMode == null ? 43 : $snapshotMode.hashCode());
        String $offsetFilename = this.getOffsetFilename();
        result = result * 59 + ($offsetFilename == null ? 43 : $offsetFilename.hashCode());
        String $historyFilename = this.getHistoryFilename();
        result = result * 59 + ($historyFilename == null ? 43 : $historyFilename.hashCode());
        String $monitoredDdl = this.getMonitoredDdl();
        result = result * 59 + ($monitoredDdl == null ? 43 : $monitoredDdl.hashCode());
        String $timestampFormatStandard = this.getTimestampFormatStandard();
        result = result * 59 + ($timestampFormatStandard == null ? 43 : $timestampFormatStandard.hashCode());
        return result;
    }
}

