/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.common.pojo.stream;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Date;
import java.util.List;
import org.apache.inlong.manager.common.pojo.stream.InlongStreamBaseInfo;
import org.apache.inlong.manager.common.pojo.stream.InlongStreamFieldInfo;
import org.apache.inlong.manager.common.pojo.stream.InlongStreamResponse;
import org.apache.inlong.manager.common.util.CommonBeanUtils;

@ApiModel(value="Inlong stream info")
public class InlongStreamInfo
extends InlongStreamBaseInfo {
    @ApiModelProperty(value="Primary key")
    private Integer id;
    @ApiModelProperty(value="Inlong stream name", required=true)
    private String name;
    @ApiModelProperty(value="Inlong stream description")
    private String description;
    @ApiModelProperty(value="MQ resource object, in inlong group", notes="Tube corresponds to Topic, Pulsar corresponds to Namespace")
    private String mqResourceObj;
    @ApiModelProperty(value="Data storage period, unit: day (required when dataSourceType=AUTO_PUSH)")
    private Integer storagePeriod;
    @ApiModelProperty(value="Data type, including: TEXT, KV, etc.")
    private String dataType;
    @ApiModelProperty(value="Data encoding format: UTF-8, GBK")
    private String dataEncoding;
    @ApiModelProperty(value="Data separator, stored as ASCII code")
    private String dataSeparator;
    @ApiModelProperty(value="Data field escape symbol, stored as ASCII code")
    private String dataEscapeChar;
    @ApiModelProperty(value="(File and DB access) Whether there are predefined fields, 0: no, 1: yes")
    private Integer havePredefinedFields;
    @ApiModelProperty(value="Whether to send synchronously, 0: no, 1: yes", notes="Each task under this stream sends data synchronously, which will affect the throughput of data collection, please choose carefully")
    private Integer syncSend;
    @ApiModelProperty(value="Number of access items per day, unit: 10,000 items per day")
    private Integer dailyRecords;
    @ApiModelProperty(value="Access size per day, unit: GB per day")
    private Integer dailyStorage;
    @ApiModelProperty(value="peak access per second, unit: bars per second")
    private Integer peakRecords;
    @ApiModelProperty(value="The maximum length of a single piece of data, unit: Byte")
    private Integer maxLength;
    @ApiModelProperty(value="Names of responsible persons, separated by commas")
    private String inCharges;
    @ApiModelProperty(value="Status")
    private Integer status;
    @ApiModelProperty(value="Previous status")
    private Integer previousStatus;
    @ApiModelProperty(value="is deleted? 0: deleted, 1: not deleted")
    private Integer isDeleted = 0;
    private String creator;
    private String modifier;
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss")
    private Date createTime;
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss")
    private Date modifyTime;
    @ApiModelProperty(value="Temporary view, string in JSON format")
    private String tempView;
    @ApiModelProperty(value="Field list")
    private List<InlongStreamFieldInfo> fieldList;

    public InlongStreamResponse genResponse() {
        return CommonBeanUtils.copyProperties(this, InlongStreamResponse::new);
    }

    public Integer getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getMqResourceObj() {
        return this.mqResourceObj;
    }

    public Integer getStoragePeriod() {
        return this.storagePeriod;
    }

    public String getDataType() {
        return this.dataType;
    }

    public String getDataEncoding() {
        return this.dataEncoding;
    }

    public String getDataSeparator() {
        return this.dataSeparator;
    }

    public String getDataEscapeChar() {
        return this.dataEscapeChar;
    }

    public Integer getHavePredefinedFields() {
        return this.havePredefinedFields;
    }

    public Integer getSyncSend() {
        return this.syncSend;
    }

    public Integer getDailyRecords() {
        return this.dailyRecords;
    }

    public Integer getDailyStorage() {
        return this.dailyStorage;
    }

    public Integer getPeakRecords() {
        return this.peakRecords;
    }

    public Integer getMaxLength() {
        return this.maxLength;
    }

    public String getInCharges() {
        return this.inCharges;
    }

    public Integer getStatus() {
        return this.status;
    }

    public Integer getPreviousStatus() {
        return this.previousStatus;
    }

    public Integer getIsDeleted() {
        return this.isDeleted;
    }

    public String getCreator() {
        return this.creator;
    }

    public String getModifier() {
        return this.modifier;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public Date getModifyTime() {
        return this.modifyTime;
    }

    public String getTempView() {
        return this.tempView;
    }

    public List<InlongStreamFieldInfo> getFieldList() {
        return this.fieldList;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setMqResourceObj(String mqResourceObj) {
        this.mqResourceObj = mqResourceObj;
    }

    public void setStoragePeriod(Integer storagePeriod) {
        this.storagePeriod = storagePeriod;
    }

    public void setDataType(String dataType) {
        this.dataType = dataType;
    }

    public void setDataEncoding(String dataEncoding) {
        this.dataEncoding = dataEncoding;
    }

    public void setDataSeparator(String dataSeparator) {
        this.dataSeparator = dataSeparator;
    }

    public void setDataEscapeChar(String dataEscapeChar) {
        this.dataEscapeChar = dataEscapeChar;
    }

    public void setHavePredefinedFields(Integer havePredefinedFields) {
        this.havePredefinedFields = havePredefinedFields;
    }

    public void setSyncSend(Integer syncSend) {
        this.syncSend = syncSend;
    }

    public void setDailyRecords(Integer dailyRecords) {
        this.dailyRecords = dailyRecords;
    }

    public void setDailyStorage(Integer dailyStorage) {
        this.dailyStorage = dailyStorage;
    }

    public void setPeakRecords(Integer peakRecords) {
        this.peakRecords = peakRecords;
    }

    public void setMaxLength(Integer maxLength) {
        this.maxLength = maxLength;
    }

    public void setInCharges(String inCharges) {
        this.inCharges = inCharges;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public void setPreviousStatus(Integer previousStatus) {
        this.previousStatus = previousStatus;
    }

    public void setIsDeleted(Integer isDeleted) {
        this.isDeleted = isDeleted;
    }

    public void setCreator(String creator) {
        this.creator = creator;
    }

    public void setModifier(String modifier) {
        this.modifier = modifier;
    }

    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss")
    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss")
    public void setModifyTime(Date modifyTime) {
        this.modifyTime = modifyTime;
    }

    public void setTempView(String tempView) {
        this.tempView = tempView;
    }

    public void setFieldList(List<InlongStreamFieldInfo> fieldList) {
        this.fieldList = fieldList;
    }

    @Override
    public String toString() {
        return "InlongStreamInfo(id=" + this.getId() + ", name=" + this.getName() + ", description=" + this.getDescription() + ", mqResourceObj=" + this.getMqResourceObj() + ", storagePeriod=" + this.getStoragePeriod() + ", dataType=" + this.getDataType() + ", dataEncoding=" + this.getDataEncoding() + ", dataSeparator=" + this.getDataSeparator() + ", dataEscapeChar=" + this.getDataEscapeChar() + ", havePredefinedFields=" + this.getHavePredefinedFields() + ", syncSend=" + this.getSyncSend() + ", dailyRecords=" + this.getDailyRecords() + ", dailyStorage=" + this.getDailyStorage() + ", peakRecords=" + this.getPeakRecords() + ", maxLength=" + this.getMaxLength() + ", inCharges=" + this.getInCharges() + ", status=" + this.getStatus() + ", previousStatus=" + this.getPreviousStatus() + ", isDeleted=" + this.getIsDeleted() + ", creator=" + this.getCreator() + ", modifier=" + this.getModifier() + ", createTime=" + this.getCreateTime() + ", modifyTime=" + this.getModifyTime() + ", tempView=" + this.getTempView() + ", fieldList=" + this.getFieldList() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InlongStreamInfo)) {
            return false;
        }
        InlongStreamInfo other = (InlongStreamInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Integer this$id = this.getId();
        Integer other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Integer this$storagePeriod = this.getStoragePeriod();
        Integer other$storagePeriod = other.getStoragePeriod();
        if (this$storagePeriod == null ? other$storagePeriod != null : !((Object)this$storagePeriod).equals(other$storagePeriod)) {
            return false;
        }
        Integer this$havePredefinedFields = this.getHavePredefinedFields();
        Integer other$havePredefinedFields = other.getHavePredefinedFields();
        if (this$havePredefinedFields == null ? other$havePredefinedFields != null : !((Object)this$havePredefinedFields).equals(other$havePredefinedFields)) {
            return false;
        }
        Integer this$syncSend = this.getSyncSend();
        Integer other$syncSend = other.getSyncSend();
        if (this$syncSend == null ? other$syncSend != null : !((Object)this$syncSend).equals(other$syncSend)) {
            return false;
        }
        Integer this$dailyRecords = this.getDailyRecords();
        Integer other$dailyRecords = other.getDailyRecords();
        if (this$dailyRecords == null ? other$dailyRecords != null : !((Object)this$dailyRecords).equals(other$dailyRecords)) {
            return false;
        }
        Integer this$dailyStorage = this.getDailyStorage();
        Integer other$dailyStorage = other.getDailyStorage();
        if (this$dailyStorage == null ? other$dailyStorage != null : !((Object)this$dailyStorage).equals(other$dailyStorage)) {
            return false;
        }
        Integer this$peakRecords = this.getPeakRecords();
        Integer other$peakRecords = other.getPeakRecords();
        if (this$peakRecords == null ? other$peakRecords != null : !((Object)this$peakRecords).equals(other$peakRecords)) {
            return false;
        }
        Integer this$maxLength = this.getMaxLength();
        Integer other$maxLength = other.getMaxLength();
        if (this$maxLength == null ? other$maxLength != null : !((Object)this$maxLength).equals(other$maxLength)) {
            return false;
        }
        Integer this$status = this.getStatus();
        Integer other$status = other.getStatus();
        if (this$status == null ? other$status != null : !((Object)this$status).equals(other$status)) {
            return false;
        }
        Integer this$previousStatus = this.getPreviousStatus();
        Integer other$previousStatus = other.getPreviousStatus();
        if (this$previousStatus == null ? other$previousStatus != null : !((Object)this$previousStatus).equals(other$previousStatus)) {
            return false;
        }
        Integer this$isDeleted = this.getIsDeleted();
        Integer other$isDeleted = other.getIsDeleted();
        if (this$isDeleted == null ? other$isDeleted != null : !((Object)this$isDeleted).equals(other$isDeleted)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$mqResourceObj = this.getMqResourceObj();
        String other$mqResourceObj = other.getMqResourceObj();
        if (this$mqResourceObj == null ? other$mqResourceObj != null : !this$mqResourceObj.equals(other$mqResourceObj)) {
            return false;
        }
        String this$dataType = this.getDataType();
        String other$dataType = other.getDataType();
        if (this$dataType == null ? other$dataType != null : !this$dataType.equals(other$dataType)) {
            return false;
        }
        String this$dataEncoding = this.getDataEncoding();
        String other$dataEncoding = other.getDataEncoding();
        if (this$dataEncoding == null ? other$dataEncoding != null : !this$dataEncoding.equals(other$dataEncoding)) {
            return false;
        }
        String this$dataSeparator = this.getDataSeparator();
        String other$dataSeparator = other.getDataSeparator();
        if (this$dataSeparator == null ? other$dataSeparator != null : !this$dataSeparator.equals(other$dataSeparator)) {
            return false;
        }
        String this$dataEscapeChar = this.getDataEscapeChar();
        String other$dataEscapeChar = other.getDataEscapeChar();
        if (this$dataEscapeChar == null ? other$dataEscapeChar != null : !this$dataEscapeChar.equals(other$dataEscapeChar)) {
            return false;
        }
        String this$inCharges = this.getInCharges();
        String other$inCharges = other.getInCharges();
        if (this$inCharges == null ? other$inCharges != null : !this$inCharges.equals(other$inCharges)) {
            return false;
        }
        String this$creator = this.getCreator();
        String other$creator = other.getCreator();
        if (this$creator == null ? other$creator != null : !this$creator.equals(other$creator)) {
            return false;
        }
        String this$modifier = this.getModifier();
        String other$modifier = other.getModifier();
        if (this$modifier == null ? other$modifier != null : !this$modifier.equals(other$modifier)) {
            return false;
        }
        Date this$createTime = this.getCreateTime();
        Date other$createTime = other.getCreateTime();
        if (this$createTime == null ? other$createTime != null : !((Object)this$createTime).equals(other$createTime)) {
            return false;
        }
        Date this$modifyTime = this.getModifyTime();
        Date other$modifyTime = other.getModifyTime();
        if (this$modifyTime == null ? other$modifyTime != null : !((Object)this$modifyTime).equals(other$modifyTime)) {
            return false;
        }
        String this$tempView = this.getTempView();
        String other$tempView = other.getTempView();
        if (this$tempView == null ? other$tempView != null : !this$tempView.equals(other$tempView)) {
            return false;
        }
        List<InlongStreamFieldInfo> this$fieldList = this.getFieldList();
        List<InlongStreamFieldInfo> other$fieldList = other.getFieldList();
        return !(this$fieldList == null ? other$fieldList != null : !((Object)this$fieldList).equals(other$fieldList));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof InlongStreamInfo;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Integer $storagePeriod = this.getStoragePeriod();
        result = result * 59 + ($storagePeriod == null ? 43 : ((Object)$storagePeriod).hashCode());
        Integer $havePredefinedFields = this.getHavePredefinedFields();
        result = result * 59 + ($havePredefinedFields == null ? 43 : ((Object)$havePredefinedFields).hashCode());
        Integer $syncSend = this.getSyncSend();
        result = result * 59 + ($syncSend == null ? 43 : ((Object)$syncSend).hashCode());
        Integer $dailyRecords = this.getDailyRecords();
        result = result * 59 + ($dailyRecords == null ? 43 : ((Object)$dailyRecords).hashCode());
        Integer $dailyStorage = this.getDailyStorage();
        result = result * 59 + ($dailyStorage == null ? 43 : ((Object)$dailyStorage).hashCode());
        Integer $peakRecords = this.getPeakRecords();
        result = result * 59 + ($peakRecords == null ? 43 : ((Object)$peakRecords).hashCode());
        Integer $maxLength = this.getMaxLength();
        result = result * 59 + ($maxLength == null ? 43 : ((Object)$maxLength).hashCode());
        Integer $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : ((Object)$status).hashCode());
        Integer $previousStatus = this.getPreviousStatus();
        result = result * 59 + ($previousStatus == null ? 43 : ((Object)$previousStatus).hashCode());
        Integer $isDeleted = this.getIsDeleted();
        result = result * 59 + ($isDeleted == null ? 43 : ((Object)$isDeleted).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $mqResourceObj = this.getMqResourceObj();
        result = result * 59 + ($mqResourceObj == null ? 43 : $mqResourceObj.hashCode());
        String $dataType = this.getDataType();
        result = result * 59 + ($dataType == null ? 43 : $dataType.hashCode());
        String $dataEncoding = this.getDataEncoding();
        result = result * 59 + ($dataEncoding == null ? 43 : $dataEncoding.hashCode());
        String $dataSeparator = this.getDataSeparator();
        result = result * 59 + ($dataSeparator == null ? 43 : $dataSeparator.hashCode());
        String $dataEscapeChar = this.getDataEscapeChar();
        result = result * 59 + ($dataEscapeChar == null ? 43 : $dataEscapeChar.hashCode());
        String $inCharges = this.getInCharges();
        result = result * 59 + ($inCharges == null ? 43 : $inCharges.hashCode());
        String $creator = this.getCreator();
        result = result * 59 + ($creator == null ? 43 : $creator.hashCode());
        String $modifier = this.getModifier();
        result = result * 59 + ($modifier == null ? 43 : $modifier.hashCode());
        Date $createTime = this.getCreateTime();
        result = result * 59 + ($createTime == null ? 43 : ((Object)$createTime).hashCode());
        Date $modifyTime = this.getModifyTime();
        result = result * 59 + ($modifyTime == null ? 43 : ((Object)$modifyTime).hashCode());
        String $tempView = this.getTempView();
        result = result * 59 + ($tempView == null ? 43 : $tempView.hashCode());
        List<InlongStreamFieldInfo> $fieldList = this.getFieldList();
        result = result * 59 + ($fieldList == null ? 43 : ((Object)$fieldList).hashCode());
        return result;
    }
}

