/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.common.pojo.workflow.form;

import com.google.common.collect.Maps;
import io.swagger.annotations.ApiModelProperty;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.inlong.manager.common.exceptions.FormValidateException;
import org.apache.inlong.manager.common.pojo.group.InlongGroupInfo;
import org.apache.inlong.manager.common.pojo.stream.StreamBriefResponse;
import org.apache.inlong.manager.common.pojo.workflow.form.BaseProcessForm;
import org.apache.inlong.manager.common.util.Preconditions;

public class NewGroupProcessForm
extends BaseProcessForm {
    public static final String FORM_NAME = "NewGroupProcessForm";
    @ApiModelProperty(value="Inlong group info", required=true)
    private InlongGroupInfo groupInfo;
    @ApiModelProperty(value="All inlong stream info under the inlong group, including the sink info")
    private List<StreamBriefResponse> streamInfoList;

    @Override
    public void validate() throws FormValidateException {
        Preconditions.checkNotNull((Object)this.groupInfo, "inlong group info is empty");
    }

    @Override
    public String getFormName() {
        return FORM_NAME;
    }

    @Override
    public String getInlongGroupId() {
        return this.groupInfo.getInlongGroupId();
    }

    @Override
    public Map<String, Object> showInList() {
        HashMap show = Maps.newHashMap();
        show.put("inlongGroupId", this.groupInfo.getInlongGroupId());
        return show;
    }

    public InlongGroupInfo getGroupInfo() {
        return this.groupInfo;
    }

    public List<StreamBriefResponse> getStreamInfoList() {
        return this.streamInfoList;
    }

    public void setGroupInfo(InlongGroupInfo groupInfo) {
        this.groupInfo = groupInfo;
    }

    public void setStreamInfoList(List<StreamBriefResponse> streamInfoList) {
        this.streamInfoList = streamInfoList;
    }

    @Override
    public String toString() {
        return "NewGroupProcessForm(groupInfo=" + this.getGroupInfo() + ", streamInfoList=" + this.getStreamInfoList() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NewGroupProcessForm)) {
            return false;
        }
        NewGroupProcessForm other = (NewGroupProcessForm)o;
        if (!other.canEqual(this)) {
            return false;
        }
        InlongGroupInfo this$groupInfo = this.getGroupInfo();
        InlongGroupInfo other$groupInfo = other.getGroupInfo();
        if (this$groupInfo == null ? other$groupInfo != null : !((Object)this$groupInfo).equals(other$groupInfo)) {
            return false;
        }
        List<StreamBriefResponse> this$streamInfoList = this.getStreamInfoList();
        List<StreamBriefResponse> other$streamInfoList = other.getStreamInfoList();
        return !(this$streamInfoList == null ? other$streamInfoList != null : !((Object)this$streamInfoList).equals(other$streamInfoList));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof NewGroupProcessForm;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        InlongGroupInfo $groupInfo = this.getGroupInfo();
        result = result * 59 + ($groupInfo == null ? 43 : ((Object)$groupInfo).hashCode());
        List<StreamBriefResponse> $streamInfoList = this.getStreamInfoList();
        result = result * 59 + ($streamInfoList == null ? 43 : ((Object)$streamInfoList).hashCode());
        return result;
    }
}

