/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.common.pojo.workflow.form;

import com.google.common.collect.Maps;
import io.swagger.annotations.ApiModelProperty;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.inlong.manager.common.exceptions.FormValidateException;
import org.apache.inlong.manager.common.pojo.group.InlongGroupInfo;
import org.apache.inlong.manager.common.pojo.stream.InlongStreamInfo;
import org.apache.inlong.manager.common.pojo.workflow.form.BaseProcessForm;
import org.apache.inlong.manager.common.util.Preconditions;

public class UpdateGroupProcessForm
extends BaseProcessForm {
    public static final String FORM_NAME = "UpdateGroupProcessForm";
    @ApiModelProperty(value="Inlong group info", required=true)
    private InlongGroupInfo groupInfo;
    @ApiModelProperty(value="OperateType to define the update operation", required=true)
    private OperateType operateType;
    private List<InlongStreamInfo> streamList;

    @Override
    public void validate() throws FormValidateException {
        Preconditions.checkNotNull((Object)this.groupInfo, "inlong group info is empty");
        Preconditions.checkNotNull((Object)this.operateType, "operate type is empty");
    }

    @Override
    public String getFormName() {
        return FORM_NAME;
    }

    @Override
    public String getInlongGroupId() {
        return this.groupInfo.getInlongGroupId();
    }

    @Override
    public Map<String, Object> showInList() {
        HashMap show = Maps.newHashMap();
        show.put("inlongGroupId", this.groupInfo.getInlongGroupId());
        show.put("operateType", this.operateType.name().toLowerCase(Locale.ROOT));
        return show;
    }

    public InlongGroupInfo getGroupInfo() {
        return this.groupInfo;
    }

    public List<InlongStreamInfo> getStreamList() {
        return this.streamList;
    }

    public void setGroupInfo(InlongGroupInfo groupInfo) {
        this.groupInfo = groupInfo;
    }

    public void setStreamList(List<InlongStreamInfo> streamList) {
        this.streamList = streamList;
    }

    @Override
    public String toString() {
        return "UpdateGroupProcessForm(groupInfo=" + this.getGroupInfo() + ", operateType=" + (Object)((Object)this.getOperateType()) + ", streamList=" + this.getStreamList() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UpdateGroupProcessForm)) {
            return false;
        }
        UpdateGroupProcessForm other = (UpdateGroupProcessForm)o;
        if (!other.canEqual(this)) {
            return false;
        }
        InlongGroupInfo this$groupInfo = this.getGroupInfo();
        InlongGroupInfo other$groupInfo = other.getGroupInfo();
        if (this$groupInfo == null ? other$groupInfo != null : !((Object)this$groupInfo).equals(other$groupInfo)) {
            return false;
        }
        OperateType this$operateType = this.getOperateType();
        OperateType other$operateType = other.getOperateType();
        if (this$operateType == null ? other$operateType != null : !((Object)((Object)this$operateType)).equals((Object)other$operateType)) {
            return false;
        }
        List<InlongStreamInfo> this$streamList = this.getStreamList();
        List<InlongStreamInfo> other$streamList = other.getStreamList();
        return !(this$streamList == null ? other$streamList != null : !((Object)this$streamList).equals(other$streamList));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof UpdateGroupProcessForm;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        InlongGroupInfo $groupInfo = this.getGroupInfo();
        result = result * 59 + ($groupInfo == null ? 43 : ((Object)$groupInfo).hashCode());
        OperateType $operateType = this.getOperateType();
        result = result * 59 + ($operateType == null ? 43 : ((Object)((Object)$operateType)).hashCode());
        List<InlongStreamInfo> $streamList = this.getStreamList();
        result = result * 59 + ($streamList == null ? 43 : ((Object)$streamList).hashCode());
        return result;
    }

    public OperateType getOperateType() {
        return this.operateType;
    }

    public void setOperateType(OperateType operateType) {
        this.operateType = operateType;
    }

    public static enum OperateType {
        INIT,
        SUSPEND,
        RESTART,
        DELETE;

    }
}

