/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.common.enums;

import java.util.HashSet;
import java.util.Set;
import org.apache.inlong.manager.common.exceptions.BusinessException;

public class ClusterType {
    public static final String AGENT = "AGENT";
    public static final String TUBEMQ = "TUBEMQ";
    public static final String PULSAR = "PULSAR";
    public static final String DATAPROXY = "DATAPROXY";
    public static final String KAFKA = "KAFKA";
    public static final String SORT_ES = "SORT_ES";
    public static final String SORT_CLS = "SORT_CLS";
    public static final String SORT_PULSAR = "SORT_PULSAR";
    private static final Set<String> TYPE_SET = new HashSet<String>(){
        {
            this.add(ClusterType.AGENT);
            this.add(ClusterType.TUBEMQ);
            this.add(ClusterType.PULSAR);
            this.add(ClusterType.DATAPROXY);
            this.add(ClusterType.KAFKA);
            this.add(ClusterType.SORT_ES);
            this.add(ClusterType.SORT_CLS);
            this.add(ClusterType.SORT_PULSAR);
        }
    };

    public static String checkType(String clusterType) {
        if (TYPE_SET.contains(clusterType)) {
            return clusterType;
        }
        throw new BusinessException(String.format("Unsupported cluster type=%s, supported cluster types are: %s", clusterType, TYPE_SET));
    }
}

