/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.common.enums;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.exceptions.BusinessException;

public enum GroupStatus {
    TO_BE_SUBMIT(100, "waiting for submit"),
    TO_BE_APPROVAL(101, "waiting for approval"),
    APPROVE_REJECTED(102, "approval rejected"),
    APPROVE_PASSED(103, "approval passed"),
    CONFIG_ING(110, "in configure"),
    CONFIG_FAILED(120, "configuration failed"),
    CONFIG_SUCCESSFUL(130, "configuration successful"),
    CONFIG_OFFLINE_ING(141, "in configure offline"),
    CONFIGURATION_OFFLINE(140, "configure offline successful"),
    CONFIG_ONLINE_ING(151, "in configure online"),
    CONFIG_DELETING(41, "configure deleting"),
    CONFIG_DELETED(40, "configure deleted"),
    FINISH(131, "finish");

    private static final Map<GroupStatus, Set<GroupStatus>> GROUP_STATE_AUTOMATON;
    private final Integer code;
    private final String description;

    private GroupStatus(Integer code, String description) {
        this.code = code;
        this.description = description;
    }

    public static GroupStatus forCode(int code) {
        for (GroupStatus status : GroupStatus.values()) {
            if (status.getCode() != code) continue;
            return status;
        }
        throw new BusinessException(ErrorCodeEnum.ILLEGAL_RECORD_FIELD_VALUE, String.format("Illegal code=%s for GroupStatus", code));
    }

    public static boolean notAllowedTransition(GroupStatus pre, GroupStatus now) {
        Set<GroupStatus> nextStates = GROUP_STATE_AUTOMATON.get((Object)pre);
        return nextStates == null || !nextStates.contains((Object)now);
    }

    public static boolean notAllowedUpdate(GroupStatus status) {
        return status == TO_BE_APPROVAL || status == CONFIG_ING || status == CONFIG_OFFLINE_ING || status == CONFIG_ONLINE_ING || status == CONFIG_DELETING;
    }

    public static boolean allowedUpdateMQ(GroupStatus status) {
        return status == TO_BE_SUBMIT || status == TO_BE_APPROVAL || status == APPROVE_REJECTED || status == CONFIG_FAILED;
    }

    public static boolean allowedUpdateSource(GroupStatus status) {
        return status == CONFIG_SUCCESSFUL || status == CONFIG_FAILED;
    }

    public static boolean deleteStreamFirst(GroupStatus status) {
        return status == APPROVE_PASSED || status == CONFIG_FAILED || status == CONFIG_SUCCESSFUL || status == CONFIGURATION_OFFLINE || status == FINISH;
    }

    public static boolean allowedDeleteSubInfos(GroupStatus status) {
        return status == TO_BE_SUBMIT || status == APPROVE_REJECTED || status == CONFIG_DELETED;
    }

    public static boolean allowedSuspend(GroupStatus status) {
        return status == CONFIG_SUCCESSFUL || status == CONFIGURATION_OFFLINE || status == FINISH;
    }

    public static boolean isTempStatus(GroupStatus status) {
        return status == TO_BE_APPROVAL || status == CONFIG_ING || status == CONFIG_OFFLINE_ING || status == CONFIG_ONLINE_ING || status == CONFIG_DELETING;
    }

    public Integer getCode() {
        return this.code;
    }

    public String getDescription() {
        return this.description;
    }

    public String toString() {
        return this.name().toLowerCase(Locale.ROOT);
    }

    static {
        GROUP_STATE_AUTOMATON = Maps.newHashMap();
        GROUP_STATE_AUTOMATON.put(TO_BE_SUBMIT, Sets.newHashSet((Object[])new GroupStatus[]{TO_BE_SUBMIT, TO_BE_APPROVAL, CONFIG_DELETING}));
        GROUP_STATE_AUTOMATON.put(TO_BE_APPROVAL, Sets.newHashSet((Object[])new GroupStatus[]{APPROVE_REJECTED, APPROVE_PASSED}));
        GROUP_STATE_AUTOMATON.put(APPROVE_REJECTED, Sets.newHashSet((Object[])new GroupStatus[]{APPROVE_REJECTED, TO_BE_APPROVAL, CONFIG_DELETING}));
        GROUP_STATE_AUTOMATON.put(APPROVE_PASSED, Sets.newHashSet((Object[])new GroupStatus[]{APPROVE_PASSED, CONFIG_ING, CONFIG_DELETING}));
        GROUP_STATE_AUTOMATON.put(CONFIG_ING, Sets.newHashSet((Object[])new GroupStatus[]{CONFIG_ING, CONFIG_FAILED, CONFIG_SUCCESSFUL, FINISH}));
        GROUP_STATE_AUTOMATON.put(CONFIG_FAILED, Sets.newHashSet((Object[])new GroupStatus[]{CONFIG_FAILED, CONFIG_ING, CONFIG_SUCCESSFUL, TO_BE_APPROVAL, CONFIG_DELETING}));
        GROUP_STATE_AUTOMATON.put(CONFIG_SUCCESSFUL, Sets.newHashSet((Object[])new GroupStatus[]{CONFIG_SUCCESSFUL, TO_BE_APPROVAL, CONFIG_ING, CONFIG_OFFLINE_ING, CONFIG_DELETING}));
        GROUP_STATE_AUTOMATON.put(CONFIG_OFFLINE_ING, Sets.newHashSet((Object[])new GroupStatus[]{CONFIG_OFFLINE_ING, CONFIGURATION_OFFLINE, CONFIG_FAILED}));
        GROUP_STATE_AUTOMATON.put(CONFIGURATION_OFFLINE, Sets.newHashSet((Object[])new GroupStatus[]{CONFIGURATION_OFFLINE, CONFIG_ONLINE_ING, CONFIG_DELETING}));
        GROUP_STATE_AUTOMATON.put(CONFIG_ONLINE_ING, Sets.newHashSet((Object[])new GroupStatus[]{CONFIG_ONLINE_ING, CONFIG_FAILED, CONFIG_SUCCESSFUL}));
        GROUP_STATE_AUTOMATON.put(CONFIG_DELETING, Sets.newHashSet((Object[])new GroupStatus[]{CONFIG_DELETING, CONFIG_DELETED, CONFIG_FAILED}));
        GROUP_STATE_AUTOMATON.put(CONFIG_DELETED, Sets.newHashSet((Object[])new GroupStatus[]{CONFIG_DELETED}));
        GROUP_STATE_AUTOMATON.put(FINISH, Sets.newHashSet((Object[])new GroupStatus[]{FINISH, CONFIG_DELETING}));
    }
}

