/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.common.consts;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.inlong.manager.common.consts.SortType;
import org.apache.inlong.manager.common.consts.StreamType;
import org.apache.inlong.manager.common.consts.SupportSortType;

public class SinkType
extends StreamType {
    @SupportSortType(sortType=SortType.SORT_FLINK)
    public static final String HIVE = "HIVE";
    @SupportSortType(sortType=SortType.SORT_FLINK)
    public static final String CLICKHOUSE = "CLICKHOUSE";
    @SupportSortType(sortType=SortType.SORT_FLINK)
    public static final String HBASE = "HBASE";
    @SupportSortType(sortType=SortType.SORT_STANDALONE)
    public static final String ES = "ES";
    @SupportSortType(sortType=SortType.SORT_FLINK)
    public static final String HDFS = "HDFS";
    @SupportSortType(sortType=SortType.SORT_FLINK)
    public static final String GREENPLUM = "GREENPLUM";
    @SupportSortType(sortType=SortType.SORT_FLINK)
    public static final String MYSQL = "MYSQL";
    @SupportSortType(sortType=SortType.SORT_FLINK)
    public static final String TDSQLPOSTGRESQL = "TDSQLPOSTGRESQL";
    @SupportSortType(sortType=SortType.SORT_FLINK)
    public static final String DORIS = "DORIS";
    @SupportSortType(sortType=SortType.SORT_FLINK)
    public static final String STARROCKS = "STARROCKS";
    @SupportSortType(sortType=SortType.SORT_FLINK)
    public static final String KUDU = "KUDU";
    @SupportSortType(sortType=SortType.SORT_FLINK)
    public static final String REDIS = "REDIS";
    @SupportSortType(sortType=SortType.SORT_FLINK)
    public static final String TUBEMQ = "TUBEMQ";
    @SupportSortType(sortType=SortType.SORT_STANDALONE)
    public static final String CLS = "CLS";
    public static final Map<String, String> SINK_TO_CLUSTER;
    public static final Set<String> SORT_FLINK_SINK;
    public static final Set<String> SORT_STANDALONE_SINK;

    public static boolean containSortFlinkSink(List<String> sinkTypes) {
        return sinkTypes.stream().anyMatch(SORT_FLINK_SINK::contains);
    }

    public static String relatedSortClusterType(String sinkType) {
        return SINK_TO_CLUSTER.get(sinkType);
    }

    static {
        Field[] fields;
        SINK_TO_CLUSTER = new HashMap<String, String>();
        SORT_FLINK_SINK = new HashSet<String>();
        SORT_STANDALONE_SINK = new HashSet<String>();
        SINK_TO_CLUSTER.put(CLS, "SORT_CLS");
        SINK_TO_CLUSTER.put(ES, "SORT_ES");
        SINK_TO_CLUSTER.put("PULSAR", "SORT_PULSAR");
        SINK_TO_CLUSTER.put("KAFKA", "SORT_KAFKA");
        SinkType obj = new SinkType();
        Class<?> clazz = obj.getClass();
        for (Field field : fields = clazz.getFields()) {
            if (!field.isAnnotationPresent(SupportSortType.class)) continue;
            SupportSortType annotation = field.getAnnotation(SupportSortType.class);
            if (Objects.equals((Object)annotation.sortType(), (Object)SortType.SORT_STANDALONE)) {
                SORT_STANDALONE_SINK.add(field.getName());
                continue;
            }
            SORT_FLINK_SINK.add(field.getName());
        }
    }
}

